/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.phd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.caseHandling.Activity;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProgramProcessDocument;
import org.fenixedu.academic.domain.phd.guidance.PhdGuidanceDocument;
import org.fenixedu.academic.dto.contacts.PendingPartyContactBean;
import org.fenixedu.academic.dto.person.PersonBean;
import org.fenixedu.academic.service.services.caseHandling.ExecuteProcessActivity;
import org.fenixedu.academic.ui.struts.action.phd.PhdDA;
import org.fenixedu.academic.ui.struts.action.phd.PhdDocumentsZip;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.fenixframework.FenixFramework;

public abstract class PhdProcessDA
extends PhdDA {
    protected static final Pattern AREA_CODE_REGEX = Pattern.compile("\\d{4}-\\d{3}");

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Person loggedPerson;
        PhdProgramProcess process2 = this.getProcess(request);
        if (process2 != null) {
            request.setAttribute("processId", (Object)process2.getExternalId());
            request.setAttribute("process", (Object)process2);
        }
        if ((loggedPerson = this.getLoggedPerson(request)) != null) {
            request.setAttribute("alertMessagesToNotify", loggedPerson.getUnreadedPhdAlertMessages());
            request.setAttribute("isTeacher", (Object)(RoleType.TEACHER.isMember(loggedPerson.getUser()) || !loggedPerson.getProfessorshipsSet().isEmpty() ? 1 : 0));
        }
        return super.execute(mapping, actionForm, request, response);
    }

    protected PhdProgramProcess getProcess(HttpServletRequest request) {
        String processIdAttribute = (String)request.getAttribute("processId");
        return (PhdProgramProcess)FenixFramework.getDomainObject((String)(processIdAttribute != null ? processIdAttribute : request.getParameter("processId")));
    }

    protected ActionForward executeActivity(Class<? extends Activity<? extends Process>> activity, Object activityParameter, HttpServletRequest request, ActionMapping mapping, String errorForward, String sucessForward) {
        return this.executeActivity(activity, activityParameter, request, mapping, errorForward, sucessForward, null, new String[0]);
    }

    protected ActionForward executeActivity(Class<? extends Activity<? extends Process>> activityClass, Object activityParameter, HttpServletRequest request, ActionMapping mapping, String errorForward, String sucessForward, String sucessMessage, String ... sucessMessageArgs) {
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), activityClass.getSimpleName(), activityParameter);
            if (!StringUtils.isEmpty((String)sucessMessage)) {
                this.addSuccessMessage(request, sucessMessage, sucessMessageArgs);
            }
            return mapping.findForward(sucessForward);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            return mapping.findForward(errorForward);
        }
    }

    protected boolean validateAreaCodeAndAreaOfAreaCode(HttpServletRequest request, Person person, Country country, String areaCode, String areaOfAreaCode) {
        if (country.isDefaultCountry() && !StringUtils.isEmpty((String)areaCode) && !AREA_CODE_REGEX.matcher(areaCode).matches()) {
            this.addErrorMessage(request, "error.areaCode.invalidFormat.for.national.address", new String[0]);
            return false;
        }
        if (!StringUtils.isEmpty((String)areaCode) && StringUtils.isEmpty((String)areaOfAreaCode)) {
            this.addErrorMessage(request, "error.areaOfAreaCode.is.required.if.areaCode.is.specified", new String[0]);
            return false;
        }
        return true;
    }

    protected String getMessageFromResource(String key, String ... args) {
        return BundleUtil.getString((String)"resources.PhdResources", (String)key, (String[])args);
    }

    protected String getZipDocumentsFilename(PhdIndividualProgramProcess process2) {
        return process2.getProcessNumber().replace("/", "-") + "-Documents.zip";
    }

    protected byte[] createZip(Collection<PhdProgramProcessDocument> documents) throws IOException {
        return PhdDocumentsZip.zip(documents);
    }

    protected byte[] createZip(HttpServletRequest request) throws IOException {
        return PhdDocumentsZip.zip(this.getProcess(request).getLatestDocumentVersions());
    }

    protected byte[] createGuidanceDocumentsZip(HttpServletRequest request) throws IOException {
        return PhdDocumentsZip.zip(new ArrayList<PhdGuidanceDocument>(((PhdIndividualProgramProcess)((Object)this.getProcess(request))).getLatestGuidanceDocumentVersions()));
    }

    protected void initPersonBeanUglyHack(PersonBean personBean, Person person) {
        personBean.setGivenNames(person.getGivenNames());
        personBean.setFamilyNames(person.getFamilyNames());
        personBean.setUsername(person.getUsername());
        personBean.setGender(person.getGender());
        personBean.setMaritalStatus(person.getMaritalStatus());
        personBean.setFatherName(person.getNameOfFather());
        personBean.setMotherName(person.getNameOfMother());
        personBean.setProfession(person.getProfession());
        personBean.setNationality(person.getCountry());
        personBean.setCountryOfBirth(person.getCountryOfBirth());
        personBean.setDateOfBirth(person.getDateOfBirthYearMonthDay());
        personBean.setParishOfBirth(person.getParishOfBirth());
        personBean.setDistrictOfBirth(person.getDistrictOfBirth());
        personBean.setDistrictSubdivisionOfBirth(person.getDistrictSubdivisionOfBirth());
        personBean.setDocumentIdEmissionDate(person.getEmissionDateOfDocumentIdYearMonthDay());
        personBean.setDocumentIdEmissionLocation(person.getEmissionLocationOfDocumentId());
        personBean.setDocumentIdExpirationDate(person.getExpirationDateOfDocumentIdYearMonthDay());
        personBean.setDocumentIdNumber(person.getDocumentIdNumber());
        personBean.setIdDocumentType(person.getIdDocumentType());
        personBean.setSocialSecurityNumber(person.getSocialSecurityNumber());
        PendingPartyContactBean pendingPartyContactBean = new PendingPartyContactBean(person);
        if (pendingPartyContactBean.getDefaultPhysicalAddress() != null) {
            PhysicalAddress physicalAddress = pendingPartyContactBean.getDefaultPhysicalAddress();
            personBean.setAddress(physicalAddress.getAddress());
            personBean.setArea(physicalAddress.getArea());
            personBean.setAreaCode(physicalAddress.getAreaCode());
            personBean.setAreaOfAreaCode(physicalAddress.getAreaOfAreaCode());
            personBean.setParishOfResidence(physicalAddress.getParishOfResidence());
            personBean.setDistrictSubdivisionOfResidence(physicalAddress.getDistrictSubdivisionOfResidence());
            personBean.setDistrictOfResidence(physicalAddress.getDistrictOfResidence());
            personBean.setCountryOfResidence(physicalAddress.getCountryOfResidence());
        }
        personBean.setPhone(pendingPartyContactBean.getDefaultPhone() != null ? pendingPartyContactBean.getDefaultPhone().getNumber() : null);
        personBean.setMobile(pendingPartyContactBean.getDefaultMobilePhone() != null ? pendingPartyContactBean.getDefaultMobilePhone().getNumber() : null);
        if (pendingPartyContactBean.getDefaultEmailAddress() != null) {
            personBean.setEmail(pendingPartyContactBean.getDefaultEmailAddress().getValue());
        }
        personBean.setEmailAvailable(person.getAvailableEmail());
        personBean.setHomepageAvailable(person.getAvailableWebSite());
        personBean.setPerson(person);
    }
}

