/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.phd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.phd.PhdProgram;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcessBean;
import org.fenixedu.academic.ui.renderers.providers.AbstractDomainObjectProvider;
import org.fenixedu.bennu.core.security.Authenticate;

public class ActivePhdProgramsOnExecutionYearProvider
extends AbstractDomainObjectProvider {
    public Object provide(Object source, Object currentValue) {
        PhdProgramCandidacyProcessBean bean = (PhdProgramCandidacyProcessBean)source;
        if (bean.getExecutionYear() == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<PhdProgram> phdProgramsList = new ArrayList<PhdProgram>();
        for (PhdProgram phdProgram : AcademicAccessRule.getPhdProgramsAccessibleToFunction(AcademicOperationType.MANAGE_PHD_PROCESSES, Authenticate.getUser()).collect(Collectors.toSet())) {
            if (!phdProgram.isActive(bean.getExecutionYear())) continue;
            phdProgramsList.add(phdProgram);
        }
        return phdProgramsList;
    }
}

