/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.manager.payments;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.accounting.PaymentCodeMapping;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.manager.ManagerApplications;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=ManagerApplications.ManagerPaymentsApp.class, path="payment-codes", titleKey="label.payments.paymentCodes", bundle="AcademicAdminOffice")
@Mapping(path="/paymentCodesAttribution", module="manager")
@Forwards(value={@Forward(name="viewCodes", path="/manager/payments/codes/viewCodes.jsp"), @Forward(name="createPaymentCodeMapping", path="/manager/payments/codes/createPaymentCodeMapping.jsp")})
public class PaymentCodesAttributionDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward prepareViewPaymentCodeMappings(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("paymentCodeMappingBean", (Object)new PaymentCodeMapping.PaymentCodeMappingBean());
        return mapping.findForward("viewCodes");
    }

    public ActionForward viewPaymentCodeMappings(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PaymentCodeMapping.PaymentCodeMappingBean bean = (PaymentCodeMapping.PaymentCodeMappingBean)this.getRenderedObject("paymentCodeMappingBean");
        request.setAttribute("paymentCodeMappingBean", (Object)bean);
        if (bean.hasExecutionInterval()) {
            request.setAttribute("paymentCodeMappings", (Object)bean.getExecutionInterval().getPaymentCodeMappingsSet());
        }
        return mapping.findForward("viewCodes");
    }

    public ActionForward prepareCreatePaymentCodeMapping(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        RenderUtils.invalidateViewState();
        PaymentCodeMapping.PaymentCodeMappingBean bean = new PaymentCodeMapping.PaymentCodeMappingBean();
        bean.setExecutionInterval((ExecutionInterval)((Object)this.getDomainObject(request, "executionIntervalOid")));
        request.setAttribute("paymentCodeMappingBean", (Object)bean);
        return mapping.findForward("createPaymentCodeMapping");
    }

    public ActionForward createPaymentCodeMapping(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PaymentCodeMapping.PaymentCodeMappingBean bean = (PaymentCodeMapping.PaymentCodeMappingBean)this.getRenderedObject("paymentCodeMappingBean");
        request.setAttribute("paymentCodeMappingBean", (Object)bean);
        try {
            bean.create();
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getKey(), e.getArgs());
            return mapping.findForward("createPaymentCodeMapping");
        }
        request.setAttribute("paymentCodeMappings", (Object)bean.getExecutionInterval().getPaymentCodeMappingsSet());
        RenderUtils.invalidateViewState();
        bean.clear();
        return mapping.findForward("viewCodes");
    }

    public ActionForward createPaymentCodeMappingInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("paymentCodeMappingBean", this.getRenderedObject("paymentCodeMappingBean"));
        return mapping.findForward("createPaymentCodeMapping");
    }

    public ActionForward deletePaymentCodeMapping(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PaymentCodeMapping codeMapping = (PaymentCodeMapping)((Object)this.getDomainObject(request, "paymentCodeMappingOid"));
        PaymentCodeMapping.PaymentCodeMappingBean bean = new PaymentCodeMapping.PaymentCodeMappingBean();
        bean.setExecutionInterval(codeMapping.getExecutionInterval());
        request.setAttribute("paymentCodeMappingBean", (Object)bean);
        request.setAttribute("paymentCodeMappings", (Object)bean.getExecutionInterval().getPaymentCodeMappingsSet());
        try {
            codeMapping.delete();
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
        }
        return mapping.findForward("viewCodes");
    }
}

