/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.academicAdministration.payments;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.Discount;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.Receipt;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.DomainExceptionWithLabelFormatter;
import org.fenixedu.academic.dto.accounting.AnnulAccountingTransactionBean;
import org.fenixedu.academic.dto.accounting.CancelEventBean;
import org.fenixedu.academic.dto.accounting.DepositAmountBean;
import org.fenixedu.academic.dto.accounting.TransferPaymentsToOtherEventAndCancelBean;
import org.fenixedu.academic.dto.person.SimpleSearchPersonWithStudentBean;
import org.fenixedu.academic.predicate.AcademicPredicates;
import org.fenixedu.academic.service.services.accounting.AnnulAccountingTransaction;
import org.fenixedu.academic.service.services.accounting.AnnulReceipt;
import org.fenixedu.academic.service.services.accounting.CancelEvent;
import org.fenixedu.academic.service.services.accounting.DepositAmountOnEvent;
import org.fenixedu.academic.service.services.accounting.OpenEvent;
import org.fenixedu.academic.service.services.accounting.TransferPaymentsToOtherEventAndCancel;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;

@StrutsFunctionality(app=AcademicAdministrationApplication.AcademicAdminPaymentsApp.class, path="manage-payments", titleKey="label.payments.management", accessGroup="academic(MANAGE_STUDENT_PAYMENTS_ADV)")
@Mapping(path="/paymentsManagement", module="academicAdministration")
@Forwards(value={@Forward(name="searchPersons", path="/academicAdministration/payments/events/searchPersons.jsp"), @Forward(name="showEvents", path="/academicAdministration/payments/events/showEvents.jsp"), @Forward(name="editCancelEventJustification", path="/academicAdministration/payments/events/editCancelEventJustification.jsp"), @Forward(name="showPaymentsForEvent", path="/academicAdministration/payments/events/showPaymentsForEvent.jsp"), @Forward(name="chooseTargetEventForPaymentsTransfer", path="/academicAdministration/payments/events/chooseTargetEventForPaymentsTransfer.jsp"), @Forward(name="annulTransaction", path="/academicAdministration/payments/events/annulTransaction.jsp"), @Forward(name="showOperations", path="/academicAdministration/payments/showOperations.jsp"), @Forward(name="showReceipts", path="/academicAdministration/payments/receipts/showReceipts.jsp"), @Forward(name="showReceipt", path="/academicAdministration/payments/receipts/showReceipt.jsp"), @Forward(name="depositAmount", path="/academicAdministration/payments/events/depositAmount.jsp"), @Forward(name="viewCodes", path="/academicAdministration/payments/codes/viewCodes.jsp"), @Forward(name="createPaymentCodeMapping", path="/academicAdministration/payments/codes/createPaymentCodeMapping.jsp"), @Forward(name="changePaymentPlan", path="/academicAdministration/payments/events/changePaymentPlan.jsp"), @Forward(name="viewEventsForCancellation", path="/academicAdministration/payments/events/viewEventsForCancellation.jsp")})
public class PaymentsManagementDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward prepareSearchPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("searchPersonBean", (Object)new SimpleSearchPersonWithStudentBean());
        return mapping.findForward("searchPersons");
    }

    public ActionForward prepareSearchPersonInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("searchPersonBean", this.getObjectFromViewState("searchPersonBean"));
        return mapping.findForward("searchPersons");
    }

    public ActionForward searchPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        SimpleSearchPersonWithStudentBean searchPersonBean = (SimpleSearchPersonWithStudentBean)this.getObjectFromViewState("searchPersonBean");
        request.setAttribute("searchPersonBean", (Object)searchPersonBean);
        Collection<Person> persons = searchPersonBean.search();
        if (persons.size() == 1) {
            request.setAttribute("personId", (Object)persons.iterator().next().getExternalId());
            return this.showOperations(mapping, form, request, response);
        }
        request.setAttribute("persons", persons);
        return mapping.findForward("searchPersons");
    }

    public ActionForward showEvents(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        request.setAttribute("person", (Object)this.getPerson(request));
        return mapping.findForward("showEvents");
    }

    public ActionForward showPaymentsForEvent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Event event = this.getEvent(request);
        request.setAttribute("event", (Object)event);
        if (!StringUtils.isEmpty((String)event.getCreatedBy())) {
            User responsible = User.findByUsername((String)event.getCreatedBy());
            request.setAttribute("responsible", (Object)responsible.getPerson());
        }
        if (event.isOpen()) {
            request.setAttribute("entryDTOs", event.calculateEntries());
            request.setAttribute("accountingEventPaymentCodes", event.getNonProcessedPaymentCodes());
        }
        return mapping.findForward("showPaymentsForEvent");
    }

    public ActionForward prepareCancelEvent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("cancelEventBean", (Object)new CancelEventBean(this.getEvent(request), this.getLoggedPerson(request)));
        return mapping.findForward("editCancelEventJustification");
    }

    public ActionForward cancelEvent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        CancelEventBean cancelEventBean = this.getCancelEventBean();
        try {
            CancelEvent.run(cancelEventBean.getEvent(), cancelEventBean.getResponsible(), cancelEventBean.getJustification());
        }
        catch (DomainExceptionWithLabelFormatter ex) {
            this.addActionMessage(request, ex.getKey(), this.solveLabelFormatterArgs(request, ex.getLabelFormatterArgs()));
            request.setAttribute("cancelEventBean", (Object)cancelEventBean);
            return mapping.findForward("editCancelEventJustification");
        }
        catch (DomainException ex) {
            this.addActionMessage(request, ex.getKey(), ex.getArgs());
            request.setAttribute("cancelEventBean", (Object)cancelEventBean);
            return mapping.findForward("editCancelEventJustification");
        }
        request.setAttribute("person", (Object)cancelEventBean.getEvent().getPerson());
        return mapping.findForward("showEvents");
    }

    public ActionForward openEvent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            OpenEvent.run(this.getEvent(request));
        }
        catch (DomainExceptionWithLabelFormatter ex) {
            this.addActionMessage(request, ex.getKey(), this.solveLabelFormatterArgs(request, ex.getLabelFormatterArgs()));
        }
        catch (DomainException ex) {
            this.addActionMessage(request, ex.getKey(), ex.getArgs());
        }
        request.setAttribute("personId", (Object)this.getEvent(request).getPerson().getExternalId());
        return this.showEvents(mapping, form, request, response);
    }

    private CancelEventBean getCancelEventBean() {
        CancelEventBean cancelEventBean = (CancelEventBean)this.getObjectFromViewState("cancelEventBean");
        return cancelEventBean;
    }

    public ActionForward backToShowEvents(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("person", (Object)this.getPerson(request));
        return mapping.findForward("showEvents");
    }

    protected Person getPerson(HttpServletRequest request) {
        return (Person)((Object)this.getDomainObject(request, "personId"));
    }

    private Event getEvent(HttpServletRequest request) {
        return (Event)((Object)this.getDomainObject(request, "eventId"));
    }

    public ActionForward prepareTransferPaymentsToOtherEventAndCancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Event event = this.getEvent(request);
        TransferPaymentsToOtherEventAndCancelBean transferPaymentsBean = new TransferPaymentsToOtherEventAndCancelBean(event, this.getLoggedPerson(request));
        request.setAttribute("transferPaymentsBean", (Object)transferPaymentsBean);
        return mapping.findForward("chooseTargetEventForPaymentsTransfer");
    }

    public ActionForward transferPaymentsToOtherEventAndCancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        TransferPaymentsToOtherEventAndCancelBean transferPaymentsBean = (TransferPaymentsToOtherEventAndCancelBean)this.getObjectFromViewState("transferPaymentsBean");
        try {
            TransferPaymentsToOtherEventAndCancel.run(transferPaymentsBean.getResponsible(), transferPaymentsBean.getSourceEvent(), transferPaymentsBean.getTargetEvent(), transferPaymentsBean.getCancelJustification());
        }
        catch (DomainExceptionWithLabelFormatter ex) {
            this.addActionMessage(request, ex.getKey(), this.solveLabelFormatterArgs(request, ex.getLabelFormatterArgs()));
            request.setAttribute("transferPaymentsBean", (Object)transferPaymentsBean);
            return mapping.findForward("chooseTargetEventForPaymentsTransfer");
        }
        catch (DomainException ex) {
            this.addActionMessage(request, ex.getKey(), ex.getArgs());
            request.setAttribute("transferPaymentsBean", (Object)transferPaymentsBean);
            return mapping.findForward("chooseTargetEventForPaymentsTransfer");
        }
        request.setAttribute("event", (Object)transferPaymentsBean.getSourceEvent());
        return mapping.findForward("showPaymentsForEvent");
    }

    public ActionForward prepareAnnulTransaction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("annulAccountingTransactionBean", (Object)new AnnulAccountingTransactionBean(this.getTransaction(request)));
        return mapping.findForward("annulTransaction");
    }

    public ActionForward prepareAnnulTransactionInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("annulAccountingTransactionBean", this.getObjectFromViewState("annulAccountingTransactionBean"));
        return mapping.findForward("annulTransaction");
    }

    public ActionForward annulTransaction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        AnnulAccountingTransactionBean annulAccountingTransactionBean = (AnnulAccountingTransactionBean)this.getObjectFromViewState("annulAccountingTransactionBean");
        try {
            AnnulAccountingTransaction.run(annulAccountingTransactionBean);
        }
        catch (DomainExceptionWithLabelFormatter ex) {
            this.addActionMessage(request, ex.getKey(), this.solveLabelFormatterArgs(request, ex.getLabelFormatterArgs()));
            request.setAttribute("annulAccountingTransactionBean", (Object)annulAccountingTransactionBean);
            return mapping.findForward("annulTransaction");
        }
        catch (DomainException ex) {
            this.addActionMessage(request, ex.getKey(), ex.getArgs());
            request.setAttribute("annulAccountingTransactionBean", (Object)annulAccountingTransactionBean);
            return mapping.findForward("annulTransaction");
        }
        return this.showEvents(mapping, form, request, response);
    }

    private AccountingTransaction getTransaction(HttpServletRequest request) {
        return (AccountingTransaction)((Object)this.getDomainObject(request, "transactionId"));
    }

    public ActionForward showOperations(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("permission", (Object)this.getPermissionForAcademicAdministration(this.getPerson(request)));
        request.setAttribute("person", (Object)this.getPerson(request));
        return mapping.findForward("showOperations");
    }

    private boolean getPermissionForAcademicAdministration(Person person) {
        return AcademicPredicates.MANAGE_STUDENT_PAYMENTS_ADV.evaluate((Object)person);
    }

    public ActionForward showReceipts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("person", (Object)this.getPerson(request));
        return mapping.findForward("showReceipts");
    }

    public ActionForward showReceipt(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("receipt", (Object)this.getReceipt(request));
        return mapping.findForward("showReceipt");
    }

    public ActionForward annulReceipt(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            AnnulReceipt.run(this.getLoggedPerson(request), this.getReceipt(request));
        }
        catch (DomainExceptionWithLabelFormatter ex) {
            this.addActionMessage(request, ex.getKey(), this.solveLabelFormatterArgs(request, ex.getLabelFormatterArgs()));
        }
        catch (DomainException ex) {
            this.addActionMessage(request, ex.getKey(), ex.getArgs());
        }
        return this.showReceipts(mapping, form, request, response);
    }

    private Receipt getReceipt(HttpServletRequest request) {
        return (Receipt)((Object)this.getDomainObject(request, "receiptId"));
    }

    public ActionForward prepareDepositAmount(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("depositAmountBean", (Object)new DepositAmountBean(this.getEvent(request)));
        return mapping.findForward("depositAmount");
    }

    public ActionForward prepareDepositAmountInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("depositAmountBean", this.getRenderedObject("depositAmountBean"));
        return mapping.findForward("depositAmount");
    }

    public ActionForward depositAmount(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        DepositAmountBean renderedObject = (DepositAmountBean)this.getRenderedObject("depositAmountBean");
        try {
            DepositAmountOnEvent.run(renderedObject);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getKey(), e.getArgs());
            request.setAttribute("depositAmountBean", (Object)renderedObject);
            return mapping.findForward("depositAmount");
        }
        return this.showEvents(mapping, form, request, response);
    }

    public ActionForward prepareChangePaymentPlan(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("event", (Object)this.getEvent(request));
        return mapping.findForward("changePaymentPlan");
    }

    public ActionForward deleteDiscount(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Discount discount = (Discount)((Object)this.getDomainObject(request, "discountOid"));
        request.setAttribute("eventId", (Object)discount.getEvent().getExternalId());
        try {
            discount.delete();
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
        }
        return this.showPaymentsForEvent(mapping, actionForm, request, response);
    }

    public ActionForward prepareViewEventsToCancel(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Person person = (Person)((Object)this.getDomainObject(request, "personId"));
        request.setAttribute("person", (Object)person);
        return mapping.findForward("viewEventsForCancellation");
    }
}

