/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers;

import org.apache.commons.lang.StringUtils;
import org.fenixedu.bennu.io.domain.GenericFile;
import org.fenixedu.bennu.io.servlets.FileDownloadServlet;
import pt.ist.fenixWebFramework.renderers.OutputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlBlockContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlLink;
import pt.ist.fenixWebFramework.renderers.components.HtmlLinkWithPreprendedComment;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public class FileLinkRenderer
extends OutputRenderer {
    private String key;
    private String bundle;
    private String text;

    protected Layout getLayout(Object object, Class type) {
        return new Layout(){

            public HtmlComponent createComponent(Object object, Class type) {
                if (object != null && object instanceof GenericFile) {
                    GenericFile file = (GenericFile)object;
                    HtmlBlockContainer container = new HtmlBlockContainer();
                    HtmlLink link = this.getLink(file);
                    container.addChild((HtmlComponent)link);
                    link.setIndented(false);
                    link.setText(this.getLinkText(file));
                    return container;
                }
                return new HtmlLink();
            }

            private HtmlLink getLink(GenericFile file) {
                HtmlLinkWithPreprendedComment link = new HtmlLinkWithPreprendedComment("<!-- NO_CHECKSUM -->");
                link.setContextRelative(false);
                link.setModuleRelative(false);
                link.setUrl(FileDownloadServlet.getDownloadUrl((GenericFile)file));
                return link;
            }

            private String getLinkText(GenericFile file) {
                if (FileLinkRenderer.this.getKey() != null) {
                    return RenderUtils.getResourceString((String)FileLinkRenderer.this.getBundle(), (String)FileLinkRenderer.this.getKey());
                }
                if (!StringUtils.isEmpty((String)FileLinkRenderer.this.getText())) {
                    return FileLinkRenderer.this.getText();
                }
                return file.getDisplayName();
            }
        };
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }
}

