/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.servlet.taglib.sop.v3;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.struts.util.RequestUtils;
import org.fenixedu.academic.dto.InfoShowOccupation;
import org.fenixedu.academic.servlet.taglib.sop.v3.DayColumn;
import org.fenixedu.academic.servlet.taglib.sop.v3.InfoLessonWrapper;
import org.fenixedu.academic.servlet.taglib.sop.v3.LessonSlot;
import org.fenixedu.academic.servlet.taglib.sop.v3.TimeTableSlot;
import org.fenixedu.academic.util.DiaSemana;
import org.fenixedu.academic.util.HourMinuteSecond;

public class TimeTable {
    private List days;
    private TimeTableSlot[][] timeTableGrid;
    private int minimumHourInMinutes;
    private Integer slotSize;
    private Integer numberOfDays;
    private Integer numberOfHours;
    private HashMap infoLessonWrapperMap;

    public TimeTable(Integer numberOfHours, Integer numberOfDays, Calendar minimumHour, Integer slotSize, Locale locale, PageContext pageContext) {
        this.minimumHourInMinutes = TimeTable.getMinutes(minimumHour);
        this.slotSize = slotSize;
        this.numberOfDays = numberOfDays;
        this.numberOfHours = numberOfHours;
        this.infoLessonWrapperMap = new HashMap();
        this.days = new ArrayList(numberOfDays);
        for (int day = 0; day < numberOfDays; ++day) {
            DayColumn column = new DayColumn(day, this.getDiaSemanaLabel(day, locale, pageContext));
            this.days.add(day, column);
        }
        this.timeTableGrid = new TimeTableSlot[numberOfDays.intValue()][numberOfHours.intValue()];
    }

    private String getDiaSemanaLabel(int day, Locale locale, PageContext pageContext) {
        switch (day) {
            case 0: {
                return this.getMessageResource(pageContext, "public.degree.information.label.monday", locale);
            }
            case 1: {
                return this.getMessageResource(pageContext, "public.degree.information.label.tusday", locale);
            }
            case 2: {
                return this.getMessageResource(pageContext, "public.degree.information.label.wednesday", locale);
            }
            case 3: {
                return this.getMessageResource(pageContext, "public.degree.information.label.thursday", locale);
            }
            case 4: {
                return this.getMessageResource(pageContext, "public.degree.information.label.friday", locale);
            }
            case 5: {
                return this.getMessageResource(pageContext, "public.degree.information.label.saturday", locale);
            }
        }
        return this.getMessageResource(pageContext, "public.degree.information.label.invalid", locale) + day;
    }

    private String getMessageResource(PageContext pageContext, String key, Locale locale) {
        try {
            return RequestUtils.message((PageContext)pageContext, (String)"PUBLIC_DEGREE_INFORMATION", (String)"org.apache.struts.action.LOCALE", (String)key);
        }
        catch (JspException e) {
            return "???" + key + "???";
        }
    }

    public void addLesson(InfoShowOccupation infoShowOccupation) {
        int dayIndex = this.getDayIndex(infoShowOccupation.getDiaSemana());
        DayColumn dayColumn = (DayColumn)this.days.get(dayIndex);
        int startIndex = TimeTable.getHourIndex(infoShowOccupation.getBeginHourMinuteSecond(), this.minimumHourInMinutes, this.slotSize);
        int endIndex = TimeTable.getHourIndex(infoShowOccupation.getEndHourMinuteSecond(), this.minimumHourInMinutes, this.slotSize);
        for (int hourIndex = startIndex; hourIndex < endIndex; ++hourIndex) {
            LessonSlot lessonSlot = new LessonSlot(this.getInfoLessonWrapper(infoShowOccupation), startIndex, endIndex - 1);
            TimeTableSlot timeTableSlot = this.getTimeTableSlot(dayColumn, hourIndex);
            timeTableSlot.addLessonSlot(lessonSlot);
        }
    }

    private InfoLessonWrapper getInfoLessonWrapper(InfoShowOccupation infoShowOccupation) {
        InfoLessonWrapper infoLessonWrapper = (InfoLessonWrapper)this.infoLessonWrapperMap.get(infoShowOccupation);
        if (infoLessonWrapper == null) {
            infoLessonWrapper = new InfoLessonWrapper(infoShowOccupation);
            this.infoLessonWrapperMap.put(infoShowOccupation, infoLessonWrapper);
        }
        return infoLessonWrapper;
    }

    private TimeTableSlot getTimeTableSlot(DayColumn day, int hourIndex) {
        TimeTableSlot timeTableSlot = this.timeTableGrid[day.getIndex()][hourIndex];
        if (timeTableSlot == null) {
            this.timeTableGrid[day.getIndex()][hourIndex] = timeTableSlot = new TimeTableSlot(day, new Integer(hourIndex));
        }
        return timeTableSlot;
    }

    private int getDayIndex(DiaSemana day) {
        int dayIndex = -1;
        if (day != null) {
            switch (day.getDiaSemana()) {
                case 2: {
                    dayIndex = 0;
                    break;
                }
                case 3: {
                    dayIndex = 1;
                    break;
                }
                case 4: {
                    dayIndex = 2;
                    break;
                }
                case 5: {
                    dayIndex = 3;
                    break;
                }
                case 6: {
                    dayIndex = 4;
                    break;
                }
                case 7: {
                    dayIndex = 5;
                    break;
                }
                default: {
                    dayIndex = -1;
                }
            }
        }
        return dayIndex;
    }

    public static int getHourIndex(HourMinuteSecond hms, int minimumHourInMinutes, int slotSize) {
        int hourInMinutes = TimeTable.getMinutes(hms);
        return (hourInMinutes - minimumHourInMinutes) / slotSize;
    }

    public static int getMinutes(HourMinuteSecond hms) {
        return hms.getHour() * 60 + hms.getMinuteOfHour();
    }

    public static int getMinutes(Calendar cal) {
        return cal.get(11) * 60 + cal.get(12);
    }

    public TimeTableSlot[][] getTimeTableGrid() {
        return this.timeTableGrid;
    }

    public Integer getNumberOfDays() {
        return this.numberOfDays;
    }

    public Integer getNumberOfHours() {
        return this.numberOfHours;
    }

    public DayColumn getDayColumn(int dayIndex) {
        return (DayColumn)this.days.get(dayIndex);
    }

    public int getMinimumHourInMinutes() {
        return this.minimumHourInMinutes;
    }

    public Integer getSlotSize() {
        return this.slotSize;
    }
}

