/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.servlet.taglib;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.util.LabelValueBean;
import org.apache.struts.util.MessageResources;

public class EnumTagLib
extends BodyTagSupport {
    private String id;
    private String enumeration;
    private String locale = "org.apache.struts.action.LOCALE";
    private String bundle;
    private String excludedFields;
    private String includedFields;
    protected static MessageResources messages = MessageResources.getMessageResources((String)"org.apache.struts.taglib.bean.LocalStrings");

    public int doStartTag() throws JspException {
        Collection<LabelValueBean> labelValueBeans = this.getLabelValues();
        this.pageContext.getRequest().setAttribute(this.id, labelValueBeans);
        return super.doStartTag();
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public void setEnumeration(String enumeration) {
        this.enumeration = enumeration;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setExcludedFields(String excludedFields) {
        this.excludedFields = excludedFields;
    }

    public void setIncludedFields(String includedFields) {
        this.includedFields = includedFields;
    }

    public Collection<LabelValueBean> getLabelValues() {
        return this.getLabelValuesLookup();
    }

    public Collection<LabelValueBean> getLabelValuesLookup() {
        try {
            Class<?> clazz = Class.forName(this.enumeration);
            if (!clazz.isEnum()) {
                throw new IllegalArgumentException("Expected an enum type, got: " + this.enumeration);
            }
            if (this.excludedFields != null && this.includedFields != null) {
                throw new IllegalArgumentException("includedFields and excludedFields are both not empty");
            }
            Method method = clazz.getMethod("values", null);
            Object[] objects = (Object[])method.invoke(clazz, (Object[])null);
            ArrayList<LabelValueBean> labelValueBeans = new ArrayList<LabelValueBean>(objects.length);
            HashSet<String> excludedFieldsNames = new HashSet<String>();
            this.fillSetWithSplittedString(excludedFieldsNames, this.excludedFields);
            HashSet<String> includedFieldsNames = new HashSet<String>();
            this.fillSetWithSplittedString(includedFieldsNames, this.includedFields);
            for (Object object : objects) {
                String value = object.toString();
                if (!(!excludedFieldsNames.isEmpty() && !excludedFieldsNames.contains(value) || !includedFieldsNames.isEmpty() && includedFieldsNames.contains(value)) && (!includedFieldsNames.isEmpty() || !excludedFieldsNames.isEmpty())) continue;
                String message = this.getMessage(clazz, value);
                labelValueBeans.add(new LabelValueBean(message, value));
            }
            return labelValueBeans;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Expected an enum type, got: " + this.enumeration);
        }
    }

    private String getMessage(Class clazz, String key) throws JspException {
        String message = null;
        message = this.getMessageFromBundle(clazz.getName() + "." + key);
        if (message == null) {
            message = this.getMessageFromBundle(clazz.getSimpleName() + "." + key);
        }
        if (message == null) {
            message = this.getMessageFromBundle(key);
        }
        return message != null ? message : key;
    }

    private String getMessageFromBundle(String key) throws JspException {
        return TagUtils.getInstance().present(this.pageContext, this.bundle, this.locale, key) ? TagUtils.getInstance().message(this.pageContext, this.bundle, this.locale, key) : null;
    }

    private void fillSetWithSplittedString(Set<String> fieldsNamesSet, String fieldNamesString) {
        if (fieldNamesString != null && fieldNamesString.length() > 0) {
            String[] fieldsNamesArray;
            for (String fieldName : fieldsNamesArray = fieldNamesString.split(",")) {
                fieldsNamesSet.add(fieldName.trim());
            }
        }
    }
}

