/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.messaging;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.messaging.ConversationMessage;
import org.fenixedu.academic.domain.messaging.ConversationThread;
import org.fenixedu.academic.domain.messaging.ForumSubscription;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.Recipient;
import org.fenixedu.academic.domain.util.email.ReplyTo;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.domain.util.email.SystemSender;
import org.fenixedu.academic.util.HtmlToTextConverterUtil;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.groups.UserGroup;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public abstract class ForumService {
    protected static final Locale DEFAULT_LOCALE = new Locale("pt");

    private static String getString(String key) {
        return BundleUtil.getString((String)"resources.GlobalResources", (Locale)DEFAULT_LOCALE, (String)key, (String[])new String[0]);
    }

    protected void sendNotifications(ConversationMessage conversationMessage) {
        this.notifyEmailSubscribers(conversationMessage);
        this.notifyLastReplier(conversationMessage);
    }

    private void notifyEmailSubscribers(ConversationMessage conversationMessage) {
        Set readers = conversationMessage.getConversationThread().getForum().getReadersGroup().getMembers();
        HashSet<Person> teachers = new HashSet<Person>();
        HashSet<Person> students = new HashSet<Person>();
        HashSet<ForumSubscription> subscriptionsToRemove = new HashSet<ForumSubscription>();
        for (ForumSubscription subscription : conversationMessage.getConversationThread().getForum().getForumSubscriptionsSet()) {
            Person subscriber = subscription.getPerson();
            if (!readers.contains(subscriber.getUser())) {
                subscriptionsToRemove.add(subscription);
            }
            if (!subscription.getReceivePostsByEmail().booleanValue()) continue;
            if (subscriber.getEmail() == null) {
                subscription.setReceivePostsByEmail(false);
                continue;
            }
            if (RoleType.TEACHER.isMember(subscriber.getUser())) {
                teachers.add(subscriber);
                continue;
            }
            students.add(subscriber);
        }
        for (ForumSubscription subscriptionToRemove : subscriptionsToRemove) {
            conversationMessage.getConversationThread().getForum().removeForumSubscriptions(subscriptionToRemove);
            subscriptionToRemove.delete();
        }
        this.sendEmailWithConversationMessage(teachers, students, conversationMessage);
    }

    private void notifyLastReplier(ConversationMessage conversationMessage) {
        ConversationMessage nextToLastConversationMessage = conversationMessage.getConversationThread().getNextToLastConversationMessage();
        if (nextToLastConversationMessage != null) {
            Person nextToLastMessageReplier = nextToLastConversationMessage.getCreator();
            if (!conversationMessage.getConversationThread().getForum().isPersonReceivingMessagesByEmail(nextToLastMessageReplier)) {
                HashSet<Person> teachers = new HashSet<Person>();
                HashSet<Person> students = new HashSet<Person>();
                if (RoleType.TEACHER.isMember(nextToLastMessageReplier.getUser())) {
                    teachers.add(nextToLastMessageReplier);
                } else {
                    students.add(nextToLastMessageReplier);
                }
                this.sendEmailWithConversationMessage(teachers, students, conversationMessage);
            }
        }
    }

    private void sendEmailToPersons(Set<Person> persons, String personsName, String subject, String body) {
        if (!persons.isEmpty()) {
            Recipient recipient = new Recipient(ForumService.getString("label.teachers"), UserGroup.of(Person.convertToUsers(persons)));
            SystemSender systemSender = Bennu.getInstance().getSystemSender();
            new Message((Sender)((Object)systemSender), (Collection<? extends ReplyTo>)systemSender.getConcreteReplyTos(), recipient.asCollection(), subject, body, "");
        }
    }

    private void sendEmailWithConversationMessage(Set<Person> teachers, Set<Person> students, ConversationMessage conversationMessage) {
        String emailSubject = this.getEmailFormattedSubject(conversationMessage.getConversationThread());
        this.sendEmailToPersons(teachers, ForumService.getString("label.teachers"), emailSubject, this.getEmailFormattedBody(conversationMessage, true));
        this.sendEmailToPersons(students, ForumService.getString("label.students"), emailSubject, this.getEmailFormattedBody(conversationMessage, false));
    }

    private String getEmailFormattedSubject(ConversationThread conversationThread) {
        String emailSubject = MessageFormat.format(ForumService.getString("forum.email.subject"), conversationThread.getTitle());
        return emailSubject;
    }

    private String getEmailFormattedBody(ConversationMessage conversationMessage, boolean isForTeacher) {
        String emailBodyAsText = HtmlToTextConverterUtil.convertToText(conversationMessage.getBody().getContent());
        String emailFormattedBody = MessageFormat.format(ForumService.getString("forum.email.body"), conversationMessage.getCreator().getName(), conversationMessage.getConversationThread().getTitle(), conversationMessage.getConversationThread().getForum().getName(), emailBodyAsText);
        return emailFormattedBody;
    }
}

