/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.filter;

import org.fenixedu.academic.domain.Evaluation;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.service.filter.AuthorizationByRoleFilter;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import pt.ist.fenixframework.FenixFramework;

public class ExecutionCourseAndExamLecturingTeacherAuthorizationFilter
extends AuthorizationByRoleFilter {
    public static final ExecutionCourseAndExamLecturingTeacherAuthorizationFilter instance = new ExecutionCourseAndExamLecturingTeacherAuthorizationFilter();

    @Override
    protected RoleType getRoleType() {
        return RoleType.TEACHER;
    }

    public void execute(String executionCourseID, String evaluationID) throws NotAuthorizedException {
        User id = Authenticate.getUser();
        try {
            if (!(id != null && this.getRoleType().isMember(id.getPerson().getUser()) && this.lecturesExecutionCourse(id, executionCourseID) && this.examBelongsExecutionCourse(id, executionCourseID, evaluationID))) {
                throw new NotAuthorizedException();
            }
        }
        catch (RuntimeException e) {
            throw new NotAuthorizedException();
        }
    }

    private boolean lecturesExecutionCourse(User id, String executionCourseID) {
        if (executionCourseID == null) {
            return false;
        }
        try {
            Teacher teacher = Teacher.readTeacherByUsername(id.getUsername());
            Professorship professorship = null;
            if (teacher != null) {
                ExecutionCourse executionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)executionCourseID);
                professorship = teacher.getProfessorshipByExecutionCourse(executionCourse);
            }
            return professorship != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean examBelongsExecutionCourse(User id, String executionCourseID, String evaluationID) {
        if (executionCourseID == null || evaluationID == null) {
            return false;
        }
        try {
            ExecutionCourse executionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)executionCourseID);
            if (executionCourse != null && evaluationID != null) {
                for (Evaluation associatedEvaluation : executionCourse.getAssociatedEvaluationsSet()) {
                    if (!associatedEvaluation.getExternalId().equals(evaluationID)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

