/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.academicAdministrativeOffice;

import java.text.MessageFormat;
import java.util.Locale;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IDocumentRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IRSDeclarationRequest;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.report.academicAdministrativeOffice.AdministrativeOfficeDocument;
import org.fenixedu.academic.util.FenixStringTools;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;

public class IRSDeclaration
extends AdministrativeOfficeDocument {
    protected IRSDeclaration(IDocumentRequest documentRequest) {
        super(documentRequest);
    }

    @Override
    protected DocumentRequest getDocumentRequest() {
        return (DocumentRequest)super.getDocumentRequest();
    }

    @Override
    protected void fillReport() {
        Registration registration = this.getDocumentRequest().getRegistration();
        Person person = registration.getPerson();
        Integer civilYear = ((IRSDeclarationRequest)((Object)this.getDocumentRequest())).getYear();
        this.addParameter("registration", (Object)registration);
        this.addParameter("documentTitle", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.title.declaration", (String[])new String[0]));
        String institutionName = this.getInstitutionName();
        String universityName = this.getUniversityName(new DateTime());
        String socialSecurityNumber = Bennu.getInstance().getInstitutionUnit().getSocialSecurityNumber().toString();
        String stringTemplate1 = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.irs.declaration.firstParagraph", (String[])new String[0]);
        this.addParameter("firstParagraph", MessageFormat.format(stringTemplate1, institutionName.toUpperCase(this.getLocale()), universityName.toUpperCase(this.getLocale())));
        String stringTemplate2 = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.irs.declaration.secondParagraph", (String[])new String[0]);
        this.addParameter("secondParagraph", MessageFormat.format(stringTemplate2, socialSecurityNumber));
        this.addParameter("socialSecurityNumber", socialSecurityNumber);
        this.addParameter("thirdParagraph", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.irs.declaration.thirdParagraph", (String[])new String[0]));
        this.addParameter("sixthParagraph", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.irs.declaration.sixthParagraph", (String[])new String[0]));
        this.addParameter("seventhParagraph", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.irs.declaration.seventhParagraph", (String[])new String[0]));
        this.setPersonFields(registration, person);
        this.addParameter("civilYear", civilYear.toString());
        this.setAmounts(person, civilYear);
        this.setFooter(this.getDocumentRequest());
        this.fillInstitutionAndStaffFields();
    }

    private final void setPersonFields(Registration registration, Person person) {
        String name = person.getName().toUpperCase();
        this.addParameter("name", FenixStringTools.multipleLineRightPad(name, 64, '-'));
        String registrationNumber = registration.getNumber().toString();
        String fourthParagraph = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.irs.declaration.fourthParagraph", (String[])new String[0]);
        this.addParameter("fourthParagraph", fourthParagraph);
        int fourthParagraphLength = fourthParagraph.length();
        this.addParameter("registrationNumber", FenixStringTools.multipleLineRightPad(registrationNumber, 64 - fourthParagraphLength, '-'));
        String documentIdNumber = person.getDocumentIdNumber().toString();
        String fifthParagraph = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.irs.declaration.fifthParagraph", (String[])new String[0]);
        this.addParameter("fifthParagraph", fifthParagraph);
        int fithParagraphLength = fifthParagraph.length();
        this.addParameter("documentIdNumber", FenixStringTools.multipleLineRightPad(documentIdNumber, 64 - fithParagraphLength, '-'));
    }

    private final void setAmounts(Person person, Integer civilYear) {
        Money gratuityPayedAmount = person.getMaxDeductableAmountForLegalTaxes(EventType.GRATUITY, civilYear);
        Money othersPayedAmount = this.calculateOthersPayedAmount(person, civilYear);
        StringBuilder eventTypes = new StringBuilder();
        StringBuilder payedAmounts = new StringBuilder();
        if (!gratuityPayedAmount.isZero()) {
            eventTypes.append("- ").append(BundleUtil.getString((String)"resources.EnumerationResources", (Locale)this.getLocale(), (String)EventType.GRATUITY.getQualifiedName(), (String[])new String[0])).append("\n");
            payedAmounts.append("*").append(gratuityPayedAmount.toPlainString()).append("Eur").append("\n");
        }
        if (!othersPayedAmount.isZero()) {
            eventTypes.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.irs.declaration.eighthParagraph", (String[])new String[0])).append("\n");
            payedAmounts.append("*").append(othersPayedAmount.toPlainString()).append("Eur").append("\n");
        }
        this.addParameter("eventTypes", eventTypes.toString());
        this.addParameter("payedAmounts", payedAmounts.toString());
        Money totalPayedAmount = othersPayedAmount.add(gratuityPayedAmount);
        this.addParameter("totalPayedAmount", "*" + totalPayedAmount.toString() + "Eur");
        this.addParameter("total", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.irs.declaration.total", (String[])new String[0]));
    }

    private Money calculateOthersPayedAmount(Person person, Integer civilYear) {
        Money result = Money.ZERO;
        for (EventType eventType : EventType.values()) {
            if (eventType == EventType.GRATUITY) continue;
            result = result.add(person.getMaxDeductableAmountForLegalTaxes(eventType, civilYear));
        }
        return result;
    }
}

