/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.predicate;

import java.util.Collection;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.AccessControlPredicate;

public class ExecutionCoursePredicates {
    public static final AccessControlPredicate<ExecutionCourse> executionCourseLecturingTeacherOrDegreeCoordinator = new AccessControlPredicate<ExecutionCourse>(){

        @Override
        public boolean evaluate(ExecutionCourse executionCourse) {
            Person person = AccessControl.getPerson();
            Teacher teacher = person.getTeacher();
            if (executionCourse.teacherLecturesExecutionCourse(teacher)) {
                return true;
            }
            if (RoleType.COORDINATOR.isMember(person.getUser())) {
                Collection<DegreeCurricularPlan> degreeCurricularPlans = executionCourse.getAssociatedDegreeCurricularPlans();
                for (DegreeCurricularPlan degreeCurricularPlan : degreeCurricularPlans) {
                    Collection<ExecutionDegree> coordinatedExecutionDegrees = person.getCoordinatedExecutionDegrees(degreeCurricularPlan);
                    for (ExecutionDegree executionDegree : coordinatedExecutionDegrees) {
                        if (!executionCourse.getExecutionYear().equals(executionCourse.getExecutionYear())) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    };
}

