/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.predicate;

import java.util.List;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.AccessControlPredicate;
import org.fenixedu.bennu.core.groups.Group;

public class CompetenceCoursePredicates {
    public static final AccessControlPredicate<CompetenceCourse> writePredicate = new AccessControlPredicate<CompetenceCourse>(){

        @Override
        public boolean evaluate(CompetenceCourse competenceCourse) {
            if (!competenceCourse.isBolonha()) {
                return true;
            }
            Person person = AccessControl.getPerson();
            if (RoleType.MANAGER.isMember(person.getUser())) {
                return true;
            }
            boolean isDegreeCurricularPlansMember = false;
            isDegreeCurricularPlansMember = CompetenceCoursePredicates.isMemberOfDegreeCurricularPlansGroup(person);
            boolean isCompetenceGroupMember = CompetenceCoursePredicates.isMemberOfCompetenceCourseGroup(competenceCourse, person);
            switch (competenceCourse.getCurricularStage()) {
                case DRAFT: {
                    return isCompetenceGroupMember;
                }
                case PUBLISHED: {
                    return isCompetenceGroupMember || isDegreeCurricularPlansMember;
                }
                case APPROVED: {
                    return RoleType.SCIENTIFIC_COUNCIL.isMember(person.getUser());
                }
            }
            return false;
        }
    };
    @Deprecated
    public static final AccessControlPredicate<CompetenceCourse> editCurricularStagePredicate = new AccessControlPredicate<CompetenceCourse>(){

        @Override
        public boolean evaluate(CompetenceCourse competenceCourse) {
            Person person = AccessControl.getPerson();
            boolean isCompetenceGroupMember = CompetenceCoursePredicates.isMemberOfCompetenceCourseGroup(competenceCourse, person);
            switch (competenceCourse.getCurricularStage()) {
                case DRAFT: {
                    return isCompetenceGroupMember;
                }
                case PUBLISHED: {
                    return isCompetenceGroupMember || RoleType.SCIENTIFIC_COUNCIL.isMember(person.getUser());
                }
                case APPROVED: {
                    return RoleType.SCIENTIFIC_COUNCIL.isMember(person.getUser());
                }
            }
            return false;
        }
    };

    private static boolean isMemberOfDegreeCurricularPlansGroup(Person person) {
        List<DegreeCurricularPlan> degreeCurricularPlans = DegreeCurricularPlan.readNotEmptyDegreeCurricularPlans();
        for (DegreeCurricularPlan plan : degreeCurricularPlans) {
            Group curricularPlanMembersGroup = plan.getCurricularPlanMembersGroup();
            if (curricularPlanMembersGroup == null) continue;
            return curricularPlanMembersGroup.isMember(person.getUser());
        }
        return false;
    }

    private static boolean isMemberOfCompetenceCourseGroup(CompetenceCourse competenceCourse, Person person) {
        Group competenceCourseMembersGroup = competenceCourse.getDepartmentUnit().getDepartment().getCompetenceCourseMembersGroup();
        if (competenceCourseMembersGroup != null) {
            return competenceCourseMembersGroup.isMember(person.getUser());
        }
        return false;
    }
}

