/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.student;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.curriculum.EnrollmentState;

public class ExecutionPeriodStatisticsBean
implements Serializable {
    private ExecutionSemester executionSemester;
    private List<Enrolment> enrolmentsWithinExecutionPeriod;
    private Integer totalEnrolmentsNumber;
    private Integer approvedEnrolmentsNumber;
    private Integer approvedRatio;
    private Double aritmeticAverage;

    public ExecutionPeriodStatisticsBean() {
        this.setExecutionPeriod(null);
        this.totalEnrolmentsNumber = 0;
        this.approvedEnrolmentsNumber = 0;
        this.approvedRatio = 0;
        this.aritmeticAverage = 0.0;
    }

    public ExecutionPeriodStatisticsBean(ExecutionSemester executionSemester) {
        this.setExecutionPeriod(executionSemester);
        this.enrolmentsWithinExecutionPeriod = new ArrayList<Enrolment>();
    }

    public ExecutionSemester getExecutionPeriod() {
        return this.executionSemester;
    }

    public void setExecutionPeriod(ExecutionSemester executionSemester) {
        this.executionSemester = executionSemester;
    }

    public List<Enrolment> getEnrolmentsWithinExecutionPeriod() {
        return this.enrolmentsWithinExecutionPeriod;
    }

    public void setEnrolmentsWithinExecutionPeriod(List<Enrolment> enrolmentsWithinExecutionPeriod) {
        this.enrolmentsWithinExecutionPeriod = enrolmentsWithinExecutionPeriod;
    }

    public Integer getTotalEnrolmentsNumber() {
        return this.totalEnrolmentsNumber;
    }

    public void setTotalEnrolmentsNumber(Integer totalEnrolmentsNumber) {
        this.totalEnrolmentsNumber = totalEnrolmentsNumber;
    }

    public Integer getApprovedEnrolmentsNumber() {
        return this.approvedEnrolmentsNumber;
    }

    public void setApprovedEnrolmentsNumber(Integer approvedEnrolmentsNumber) {
        this.approvedEnrolmentsNumber = approvedEnrolmentsNumber;
    }

    public Integer getApprovedRatio() {
        return this.approvedRatio;
    }

    public void setApprovedRatio(Integer approvedRatio) {
        this.approvedRatio = approvedRatio;
    }

    public Double getAritmeticAverage() {
        return this.aritmeticAverage;
    }

    public void setAritmeticAverage(Double aritmeticAverage) {
        this.aritmeticAverage = aritmeticAverage;
    }

    private void calculateTotalEnrolmentsNumber() {
        this.setTotalEnrolmentsNumber(this.getEnrolmentsWithinExecutionPeriod().size());
    }

    private void calculateApprovedEnrolmentsNumber() {
        int approvedEnrolmentsNumber = 0;
        for (Enrolment enrolment : this.getEnrolmentsWithinExecutionPeriod()) {
            if (!enrolment.isApproved()) continue;
            ++approvedEnrolmentsNumber;
        }
        this.setApprovedEnrolmentsNumber(approvedEnrolmentsNumber);
    }

    private void calculateAritmeticAverage() {
        int concludedCurricularCourses = 0;
        double gradesAcumulator = 0.0;
        double aritmeticAverage = 0.0;
        for (Enrolment enrolment : this.getEnrolmentsWithinExecutionPeriod()) {
            if (!enrolment.isApproved() || enrolment.getGrade() == null || !enrolment.getGrade().isNumeric()) continue;
            ++concludedCurricularCourses;
            gradesAcumulator += enrolment.getGrade().getNumericValue().doubleValue();
        }
        aritmeticAverage = gradesAcumulator / (double)concludedCurricularCourses;
        this.setAritmeticAverage((double)((int)(aritmeticAverage * 100.0)) / 100.0);
    }

    private void calculateApprovedRatio() {
        int concludedEnrolments = 0;
        for (Enrolment enrolment : this.getEnrolmentsWithinExecutionPeriod()) {
            if (!enrolment.getEnrollmentState().equals((Object)EnrollmentState.APROVED)) continue;
            ++concludedEnrolments;
        }
        int ratio = Math.round((float)concludedEnrolments / (float)this.getTotalEnrolmentsNumber().intValue() * 100.0f);
        this.setApprovedRatio(ratio);
    }

    public void addEnrolmentsWithinExecutionPeriod(List<Enrolment> enrolments) {
        if (!this.enrolmentsWithinExecutionPeriod.isEmpty()) {
            for (Enrolment newEnrolment : enrolments) {
                StudentCurricularPlan newEnrolmentSCP = newEnrolment.getStudentCurricularPlan();
                Enrolment previousAddedEnrolment = this.getPreviousEnrolmentGivenCurricularCourse(newEnrolment.getCurricularCourse());
                if (previousAddedEnrolment != null) {
                    StudentCurricularPlan previousEnrolmentSCP = previousAddedEnrolment.getStudentCurricularPlan();
                    if (!newEnrolmentSCP.getStartExecutionYear().isAfterOrEquals(previousEnrolmentSCP.getStartExecutionYear())) continue;
                    this.enrolmentsWithinExecutionPeriod.remove(previousAddedEnrolment);
                    this.enrolmentsWithinExecutionPeriod.add(newEnrolment);
                    continue;
                }
                this.enrolmentsWithinExecutionPeriod.add(newEnrolment);
            }
        } else {
            this.enrolmentsWithinExecutionPeriod = enrolments;
        }
        this.recalculateStatistics();
    }

    private Enrolment getPreviousEnrolmentGivenCurricularCourse(CurricularCourse curricular) {
        for (Enrolment enrolment : this.enrolmentsWithinExecutionPeriod) {
            if (!enrolment.getCurricularCourse().equals((Object)curricular)) continue;
            return enrolment;
        }
        return null;
    }

    private void recalculateStatistics() {
        this.calculateTotalEnrolmentsNumber();
        this.calculateApprovedEnrolmentsNumber();
        this.calculateApprovedRatio();
        this.calculateAritmeticAverage();
    }
}

