/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.util.email;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.util.email.EmailBean$callable$removeRecipients;
import org.fenixedu.academic.domain.util.email.EmailBean$callable$send;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.Recipient;
import org.fenixedu.academic.domain.util.email.ReplyTo;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class EmailBean
implements Serializable {
    private Sender sender;
    private Set<Recipient> recipients;
    private String tos;
    private String ccs;
    private String bccs;
    private String subject;
    private String message;
    private String htmlMessage;
    private Set<ReplyTo> replyTos;
    private DateTime createdDate;
    public static final Advice advice$send = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$removeRecipients = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public EmailBean() {
    }

    public EmailBean(Message message) {
        this.subject = message.getSubject();
        this.message = message.getBody();
        this.htmlMessage = message.getHtmlBody();
        this.bccs = message.getBccs();
        this.createdDate = message.getCreated();
    }

    public Sender getSender() {
        return this.sender;
    }

    public void setSender(Sender sender) {
        this.sender = sender;
    }

    public List<Recipient> getRecipients() {
        ArrayList<Recipient> result = new ArrayList<Recipient>();
        if (this.recipients != null) {
            for (Recipient recipient : this.recipients) {
                result.add(recipient);
            }
        }
        return result;
    }

    public void setRecipients(List<Recipient> recipients) {
        if (recipients == null) {
            this.recipients = null;
        } else {
            this.recipients = new HashSet<Recipient>();
            for (Recipient recipient : recipients) {
                this.recipients.add(recipient);
            }
        }
    }

    public List<ReplyTo> getReplyTos() {
        ArrayList<ReplyTo> result = new ArrayList<ReplyTo>();
        if (this.replyTos != null) {
            for (ReplyTo replyTo : this.replyTos) {
                result.add(replyTo);
            }
        }
        return result;
    }

    public void setReplyTos(List<ReplyTo> replyTos) {
        if (replyTos == null) {
            this.replyTos = null;
        } else {
            this.replyTos = new HashSet<ReplyTo>();
            for (ReplyTo replyTo : replyTos) {
                this.replyTos.add(replyTo);
            }
        }
    }

    public String getTos() {
        return this.tos;
    }

    public void setTos(String tos) {
        this.tos = tos;
    }

    public String getCcs() {
        return this.ccs;
    }

    public void setCcs(String ccs) {
        this.ccs = ccs;
    }

    public String getBccs() {
        return this.bccs;
    }

    public void setBccs(String bccs) {
        this.bccs = bccs;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getHtmlMessage() {
        return this.htmlMessage;
    }

    public void setHtmlMessage(String htmlMessage) {
        this.htmlMessage = htmlMessage;
    }

    public String validate() {
        String bccs = this.getBccs();
        if (this.getRecipients().isEmpty() && StringUtils.isEmpty((String)bccs)) {
            return BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.email.validation.no.recipients", (String[])new String[0]);
        }
        if (!StringUtils.isEmpty((String)bccs)) {
            String[] emails;
            for (String emailString : emails = bccs.split(",")) {
                String email = emailString.trim();
                if (email.matches("(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])")) continue;
                StringBuilder builder = new StringBuilder(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.email.validation.bcc.invalid", (String[])new String[0]));
                builder.append(email);
                return builder.toString();
            }
        }
        if (StringUtils.isEmpty((String)this.getSubject())) {
            return BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.email.validation.subject.empty", (String[])new String[0]);
        }
        if (StringUtils.isEmpty((String)this.getMessage()) && StringUtils.isEmpty((String)this.getHtmlMessage())) {
            return BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.email.validation.message.empty", (String[])new String[0]);
        }
        return null;
    }

    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(DateTime createdDate) {
        this.createdDate = createdDate;
    }

    public Message send() {
        return (Message)((Object)advice$send.perform((Callable)new EmailBean$callable$send(this)));
    }

    static /* synthetic */ Message advised$send(EmailBean this_) {
        StringBuilder message = new StringBuilder();
        if (this_.getMessage() != null && !this_.getMessage().trim().isEmpty()) {
            message.append(this_.getMessage());
            message.append("\n\n---\n");
            message.append(BundleUtil.getString((String)"resources.ApplicationResources", (String)"message.email.footer.prefix", (String[])new String[0]));
            message.append(this_.getSender().getFromName());
            message.append(BundleUtil.getString((String)"resources.ApplicationResources", (String)"message.email.footer.prefix.suffix", (String[])new String[0]));
            for (Recipient recipient : this_.getRecipients()) {
                message.append("\n\t");
                message.append(recipient.getToName());
            }
            message.append("\n");
        }
        String bccs = this_.getBccs() == null ? null : this_.getBccs().replace(" ", "");
        String htmlMessage = this_.getHtmlMessage();
        return new Message(this_.getSender(), this_.getReplyTos(), this_.getRecipients(), this_.getSubject(), message.toString(), bccs, htmlMessage);
    }

    public void removeRecipients() {
        Object object = advice$removeRecipients.perform((Callable)new EmailBean$callable$removeRecipients(this));
    }

    static /* synthetic */ void advised$removeRecipients(EmailBean this_) {
        for (Recipient recipient : this_.getRecipients()) {
            this_.getSender().removeRecipients(recipient);
        }
        this_.setRecipients(null);
    }
}

