/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.time.calendarStructure;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicSemesters;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicTrimesters;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicYears;
import org.joda.time.base.BaseSingleFieldPeriod;

public abstract class AcademicPeriod
extends BaseSingleFieldPeriod {
    public static AcademicPeriod SEMESTER = new AcademicSemesters(1, "SEMESTER");
    public static AcademicPeriod YEAR = new AcademicYears(1, "YEAR");
    public static AcademicPeriod TWO_YEAR = new AcademicYears(2, "TWO_YEAR");
    public static AcademicPeriod THREE_YEAR = new AcademicYears(3, "THREE_YEAR");
    public static AcademicPeriod FOUR_YEAR = new AcademicYears(4, "FOUR_YEAR");
    public static AcademicPeriod FIVE_YEAR = new AcademicYears(5, "FIVE_YEAR");
    public static AcademicPeriod SIX_YEAR = new AcademicYears(6, "SIX_YEAR");
    public static AcademicPeriod TRIMESTER = new AcademicTrimesters(1, "TRIMESTER");
    private static Map<String, AcademicPeriod> academicPeriods = new HashMap<String, AcademicPeriod>();
    private final String name;

    protected AcademicPeriod(int period, String name) {
        super(period);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getAbbreviatedName() {
        return this.getName() + ".ABBREVIATION";
    }

    public String getRepresentationInStringFormat() {
        return ((Object)((Object)this)).getClass().getName() + ":" + this.getValue();
    }

    public static AcademicPeriod getAcademicPeriodFromString(String representationInStringFormat) {
        return academicPeriods.get(representationInStringFormat);
    }

    protected final void setValue(int value) {
    }

    public abstract float getWeight();

    public int compareTo(BaseSingleFieldPeriod other) {
        if (!(other instanceof AcademicPeriod)) {
            throw new ClassCastException(((Object)((Object)this)).getClass() + " cannot be compared to " + other.getClass());
        }
        AcademicPeriod otherAcademicPeriod = (AcademicPeriod)other;
        if (this.getWeight() > otherAcademicPeriod.getWeight()) {
            return -1;
        }
        if (this.getWeight() < otherAcademicPeriod.getWeight()) {
            return 1;
        }
        return 0;
    }

    public static Set<AcademicPeriod> values() {
        return Collections.unmodifiableSet(new HashSet<AcademicPeriod>(academicPeriods.values()));
    }

    public boolean isSmaller(AcademicPeriod input) {
        return this.compareTo(input) > 0;
    }

    public boolean isSmallerOrEquals(AcademicPeriod input) {
        return this.compareTo(input) >= 0;
    }

    public boolean isBigger(AcademicPeriod input) {
        return this.compareTo(input) < 0;
    }

    public boolean isBiggerOrEquals(AcademicPeriod input) {
        return this.compareTo(input) <= 0;
    }

    public abstract AcademicPeriod getPossibleChild();

    static {
        academicPeriods.put(SEMESTER.getRepresentationInStringFormat(), SEMESTER);
        academicPeriods.put(YEAR.getRepresentationInStringFormat(), YEAR);
        academicPeriods.put(TWO_YEAR.getRepresentationInStringFormat(), TWO_YEAR);
        academicPeriods.put(THREE_YEAR.getRepresentationInStringFormat(), THREE_YEAR);
        academicPeriods.put(FOUR_YEAR.getRepresentationInStringFormat(), FOUR_YEAR);
        academicPeriods.put(FIVE_YEAR.getRepresentationInStringFormat(), FIVE_YEAR);
        academicPeriods.put(SIX_YEAR.getRepresentationInStringFormat(), SIX_YEAR);
        academicPeriods.put(TRIMESTER.getRepresentationInStringFormat(), TRIMESTER);
    }
}

