/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student;

import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.student.WeeklyWorkLoad_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationFieldType;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class WeeklyWorkLoad
extends WeeklyWorkLoad_Base
implements Comparable<WeeklyWorkLoad> {
    public WeeklyWorkLoad(Attends attends, Integer weekOffset, Integer contact, Integer autonomousStudy, Integer other) {
        this.setRootDomainObject(Bennu.getInstance());
        if (attends == null || weekOffset == null) {
            throw new NullPointerException();
        }
        this.setAttends(attends);
        this.setContact(contact);
        this.setAutonomousStudy(autonomousStudy);
        this.setOther(other);
        this.setWeekOffset(weekOffset);
    }

    public int getTotal() {
        int contact = this.getContact() != null ? this.getContact() : 0;
        int autonomousStudy = this.getAutonomousStudy() != null ? this.getAutonomousStudy() : 0;
        int other = this.getOther() != null ? this.getOther() : 0;
        return contact + autonomousStudy + other;
    }

    @Override
    public int compareTo(WeeklyWorkLoad weeklyWorkLoad) {
        if (weeklyWorkLoad == null) {
            throw new NullPointerException("Cannot compare weekly work load with null");
        }
        if (this.getAttends() != weeklyWorkLoad.getAttends()) {
            throw new IllegalArgumentException("Cannot compare weekly work loads of different attends.");
        }
        return this.getWeekOffset().compareTo(weeklyWorkLoad.getWeekOffset());
    }

    public Interval getInterval() {
        DateTime beginningOfSemester = new DateTime((Object)this.getAttends().getBegginingOfLessonPeriod());
        DateTime firstMonday = beginningOfSemester.withField(DateTimeFieldType.dayOfWeek(), 1);
        DateTime start = firstMonday.withFieldAdded(DurationFieldType.weeks(), this.getWeekOffset().intValue());
        DateTime end = start.plusWeeks(1);
        return new Interval((ReadableInstant)start, (ReadableInstant)end);
    }

    public void delete() {
        this.setAttends(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }
}

