/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests;

import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.FreeSolicitationAcademicRequest_Base;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.AcademicServiceRequestType;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestBean;
import org.fenixedu.academic.dto.serviceRequests.RegistrationAcademicServiceRequestCreateBean;

public class FreeSolicitationAcademicRequest
extends FreeSolicitationAcademicRequest_Base {
    protected FreeSolicitationAcademicRequest() {
    }

    public FreeSolicitationAcademicRequest(RegistrationAcademicServiceRequestCreateBean bean) {
        this();
        super.init(bean);
        this.checkParameters(bean);
        super.setSubject(bean.getSubject());
        super.setPurpose(bean.getPurpose());
    }

    private void checkParameters(RegistrationAcademicServiceRequestCreateBean bean) {
        if (StringUtils.isEmpty((String)bean.getSubject())) {
            throw new DomainException("error.FreeSolicitationAcademicRequest.invalid.subject", new String[0]);
        }
    }

    protected void checkRegistrationStartDate(RegistrationAcademicServiceRequestCreateBean bean) {
    }

    public void setSubject(String subject) {
        throw new DomainException("error.FreeSolicitationAcademicRequest.cannot.modify.subject", new String[0]);
    }

    public void setPurpose(String purpose) {
        throw new DomainException("error.FreeSolicitationAcademicRequest.cannot.modify.purpose", new String[0]);
    }

    public AcademicServiceRequestType getAcademicServiceRequestType() {
        return AcademicServiceRequestType.FREE_SOLICITATION_ACADEMIC_REQUEST;
    }

    public EventType getEventType() {
        return null;
    }

    protected void internalChangeState(AcademicServiceRequestBean academicServiceRequestBean) {
        super.internalChangeState(academicServiceRequestBean);
        if (academicServiceRequestBean.isToProcess()) {
            academicServiceRequestBean.setSituationDate(this.getActiveSituation().getSituationDate().toYearMonthDay());
        }
    }

    public boolean isToPrint() {
        return false;
    }

    public boolean isPossibleToSendToOtherEntity() {
        return true;
    }

    public boolean isManagedWithRectorateSubmissionBatch() {
        return false;
    }

    public boolean isAvailableForTransitedRegistrations() {
        return false;
    }

    public boolean isPayedUponCreation() {
        return false;
    }

    public boolean hasPersonalInfo() {
        return false;
    }
}

