/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.debts;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.Exemption;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProgram;
import org.fenixedu.academic.domain.phd.debts.PhdGratuityEvent$callable$create;
import org.fenixedu.academic.domain.phd.debts.PhdGratuityEvent_Base;
import org.fenixedu.academic.domain.phd.debts.PhdGratuityPR;
import org.fenixedu.academic.domain.phd.debts.PhdGratuityPaymentPeriod;
import org.fenixedu.academic.util.LabelFormatter;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PhdGratuityEvent
extends PhdGratuityEvent_Base {
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public PhdGratuityEvent(PhdIndividualProgramProcess process2, int year, DateTime phdGratuityDate) {
        if (process2.hasPhdGratuityEventForYear(year)) {
            throw new DomainException("error.PhdRegistrationFee.process.already.has.registration.fee.for.this.year", new String[0]);
        }
        this.init(EventType.PHD_GRATUITY, process2.getPerson(), year, process2, phdGratuityDate);
    }

    public boolean hasExemptionsOfType(Class cl) {
        for (Exemption exemption : this.getExemptionsSet()) {
            if (!cl.isAssignableFrom(((Object)((Object)exemption)).getClass())) continue;
            return true;
        }
        return false;
    }

    protected void init(EventType eventType, Person person, int year, PhdIndividualProgramProcess process2, DateTime phdGratuityDate) {
        super.init(eventType, person);
        if (year < 2006) {
            throw new DomainException("invalid.year", new String[0]);
        }
        if (process2 == null) {
            throw new DomainException("proces.may.not.be.null", new String[0]);
        }
        if (phdGratuityDate == null) {
            throw new DomainException("phdGratuityDate.may.not.be.null", new String[0]);
        }
        this.setYear(year);
        this.setPhdIndividualProgramProcess(process2);
        this.setPhdGratuityDate(phdGratuityDate);
    }

    protected PhdProgram getPhdProgram() {
        return this.getPhdIndividualProgramProcess().getPhdProgram();
    }

    public static PhdGratuityEvent create(PhdIndividualProgramProcess phdIndividualProgramProcess, int n, DateTime dateTime) {
        return (PhdGratuityEvent)((Object)advice$create.perform((Callable)new PhdGratuityEvent$callable$create(phdIndividualProgramProcess, n, dateTime)));
    }

    static /* synthetic */ PhdGratuityEvent advised$create(PhdIndividualProgramProcess phdIndividualProgramProcess, int year, DateTime phdGratuityDate) {
        return new PhdGratuityEvent(phdIndividualProgramProcess, year, phdGratuityDate);
    }

    public LabelFormatter getDescriptionForEntryType(EntryType entryType) {
        return new LabelFormatter().appendLabel(entryType.name(), "resources.EnumerationResources").appendLabel(" - ").appendLabel("" + this.getYear()).appendLabel(" (").appendLabel(this.getPhdProgram().getName().getContent()).appendLabel(")");
    }

    public LabelFormatter getDescription() {
        return new LabelFormatter().appendLabel(this.getEventType().getQualifiedName(), "resources.EnumerationResources").appendLabel(" - ").appendLabel("" + this.getYear()).appendLabel(" (").appendLabel(this.getPhdProgram().getName().getContent()).appendLabel(")");
    }

    public boolean isExemptionAppliable() {
        return true;
    }

    public DateTime getLimitDateToPay() {
        DateTime endDay;
        LocalDate whenFormalizedRegistration = this.getPhdIndividualProgramProcess().getWhenFormalizedRegistration();
        PhdGratuityPaymentPeriod phdGratuityPeriod = ((PhdGratuityPR)((Object)this.getPostingRule())).getPhdGratuityPeriod(whenFormalizedRegistration);
        DateTime lastPaymentDay = new LocalDate(this.getYear().intValue(), phdGratuityPeriod.getLastPayment().get(DateTimeFieldType.monthOfYear()), phdGratuityPeriod.getLastPayment().get(DateTimeFieldType.dayOfMonth())).toDateMidnight().toDateTime();
        if (lastPaymentDay.isBefore((ReadableInstant)(endDay = new LocalDate(this.getYear().intValue(), phdGratuityPeriod.getEnd().get(DateTimeFieldType.monthOfYear()), phdGratuityPeriod.getEnd().get(DateTimeFieldType.dayOfMonth())).toDateMidnight().toDateTime()))) {
            return new LocalDate(this.getYear() + 1, phdGratuityPeriod.getLastPayment().get(DateTimeFieldType.monthOfYear()), phdGratuityPeriod.getLastPayment().get(DateTimeFieldType.dayOfMonth())).toDateMidnight().toDateTime();
        }
        return lastPaymentDay;
    }

    public boolean isOpen() {
        if (this.isCancelled()) {
            return false;
        }
        return this.calculateAmountToPay(new DateTime()).greaterThan(Money.ZERO);
    }

    public boolean isClosed() {
        if (this.isCancelled()) {
            return false;
        }
        return this.calculateAmountToPay(new DateTime()).lessOrEqualThan(Money.ZERO);
    }
}

