/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd;

import java.io.Serializable;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdParticipant;
import org.fenixedu.academic.domain.phd.PhdProgramDocumentUploadBean;

public class PhdParticipantBean
implements Serializable {
    private static final long serialVersionUID = -5481393284887457872L;
    private PhdIndividualProgramProcess individualProgramProcess;
    private PhdParticipant participant;
    private PhdParticipantSelectType participantSelectType = null;
    private PhdParticipantType participantType = null;
    private Person person;
    private String name;
    private String title;
    private String qualification;
    private String category;
    private String workLocation;
    private String institution;
    private String address;
    private String email;
    private String phone;
    private PhdProgramDocumentUploadBean guidingAcceptanceLetter;

    public PhdParticipantBean() {
    }

    public PhdParticipantBean(PhdIndividualProgramProcess individualProgramProcess) {
        this.setIndividualProgramProcess(individualProgramProcess);
    }

    public PhdParticipantBean(PhdParticipant phdParticipant) {
        this.setParticipant(phdParticipant);
        this.setName(phdParticipant.getName());
        this.setTitle(phdParticipant.getTitle());
        this.setQualification(phdParticipant.getQualification());
        this.setCategory(phdParticipant.getCategory());
        this.setWorkLocation(phdParticipant.getWorkLocation());
        this.setInstitution(phdParticipant.getInstitution());
        this.setAddress(phdParticipant.getAddress());
        this.setEmail(phdParticipant.getEmail());
        this.setPhone(phdParticipant.getPhone());
    }

    public PhdIndividualProgramProcess getIndividualProgramProcess() {
        return this.individualProgramProcess;
    }

    public void setIndividualProgramProcess(PhdIndividualProgramProcess individualProgramProcess) {
        this.individualProgramProcess = individualProgramProcess;
    }

    public PhdParticipant getParticipant() {
        return this.participant;
    }

    public void setParticipant(PhdParticipant participant) {
        this.participant = participant;
    }

    public boolean hasParticipant() {
        return this.getParticipant() != null;
    }

    public PhdParticipantSelectType getParticipantSelectType() {
        return this.participantSelectType;
    }

    public void setParticipantSelectType(PhdParticipantSelectType participantSelectType) {
        this.participantSelectType = participantSelectType;
    }

    public PhdParticipantType getParticipantType() {
        return this.participantType;
    }

    public void setParticipantType(PhdParticipantType participantType) {
        this.participantType = participantType;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getQualification() {
        return this.qualification;
    }

    public void setQualification(String qualification) {
        this.qualification = qualification;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getWorkLocation() {
        return this.workLocation;
    }

    public void setWorkLocation(String workLocation) {
        this.workLocation = workLocation;
    }

    public String getInstitution() {
        return this.institution;
    }

    public void setInstitution(String institution) {
        this.institution = institution;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public boolean isInternal() {
        return this.getParticipantType() == PhdParticipantType.INTERNAL;
    }

    public boolean isExistingElement() {
        return this.getParticipantSelectType() == PhdParticipantSelectType.EXISTING;
    }

    public PhdParticipantBean setInternalParticipant(Person person) {
        this.setParticipantType(PhdParticipantType.INTERNAL);
        this.setPerson(person);
        return this;
    }

    public PhdProgramDocumentUploadBean getGuidingAcceptanceLetter() {
        return this.guidingAcceptanceLetter;
    }

    public void setGuidingAcceptanceLetter(PhdProgramDocumentUploadBean guidingAcceptanceLetter) {
        this.guidingAcceptanceLetter = guidingAcceptanceLetter;
    }

    public static enum PhdParticipantType {
        INTERNAL,
        EXTERNAL;


        public String getName() {
            return this.name();
        }
    }

    public static enum PhdParticipantSelectType {
        NEW,
        EXISTING;


        public String getName() {
            return this.name();
        }
    }
}

