/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.mobility.outbound;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacy$callable$delete;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacy$callable$reorder;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacy$callable$select;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacy$callable$unselect;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyContest;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacySubmission;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacy_Base;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.Recipient;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.domain.util.email.SystemSender;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.UserGroup;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class OutboundMobilityCandidacy
extends OutboundMobilityCandidacy_Base
implements Comparable<OutboundMobilityCandidacy> {
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$reorder = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$select = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$unselect = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public OutboundMobilityCandidacy(OutboundMobilityCandidacyContest outboundMobilityCandidacyContest, OutboundMobilityCandidacySubmission outboundMobilityCandidacySubmission) {
        this.setRootDomainObject(Bennu.getInstance());
        this.setOutboundMobilityCandidacyContest(outboundMobilityCandidacyContest);
        this.setOutboundMobilityCandidacySubmission(outboundMobilityCandidacySubmission);
        this.setPreferenceOrder(outboundMobilityCandidacySubmission.getOutboundMobilityCandidacySet().size());
        this.setSelected(Boolean.FALSE);
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new OutboundMobilityCandidacy$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(OutboundMobilityCandidacy this_) {
        OutboundMobilityCandidacySubmission submission = this_.getOutboundMobilityCandidacySubmission();
        if (!submission.getOutboundMobilityCandidacyPeriod().isAcceptingCandidacies()) {
            throw new DomainException("error.CandidacyPeriod.closed", new String[0]);
        }
        if (this_.getSubmissionFromSelectedCandidacy() != null) {
            throw new DomainException("error.SubmissionFromSelectedCandidacy.not.empty", new String[0]);
        }
        this_.setOutboundMobilityCandidacySubmission(null);
        this_.setOutboundMobilityCandidacyContest(null);
        this_.setRootDomainObject(null);
        this_.deleteDomainObject();
        if (!submission.getOutboundMobilityCandidacySet().isEmpty()) {
            int i = 0;
            for (OutboundMobilityCandidacy candidacy : submission.getSortedOutboundMobilityCandidacySet()) {
                candidacy.setPreferenceOrder(++i);
            }
        } else {
            submission.delete();
        }
    }

    public void reorder(int n) {
        Object object = advice$reorder.perform((Callable)new OutboundMobilityCandidacy$callable$reorder(this, n));
    }

    static /* synthetic */ void advised$reorder(OutboundMobilityCandidacy this_, int index) {
        int currentOrder = this_.getPreferenceOrder();
        if (index != currentOrder) {
            OutboundMobilityCandidacySubmission submission = this_.getOutboundMobilityCandidacySubmission();
            if (index < currentOrder) {
                for (OutboundMobilityCandidacy candidacy : submission.getSortedOutboundMobilityCandidacySet()) {
                    int order = candidacy.getPreferenceOrder();
                    if (order < index || order >= currentOrder) continue;
                    candidacy.setPreferenceOrder(order + 1);
                }
            } else {
                for (OutboundMobilityCandidacy candidacy : submission.getSortedOutboundMobilityCandidacySet()) {
                    int order = candidacy.getPreferenceOrder();
                    if (order > index || order <= currentOrder) continue;
                    candidacy.setPreferenceOrder(order - 1);
                }
            }
            this_.setPreferenceOrder(index);
        }
    }

    @Override
    public int compareTo(OutboundMobilityCandidacy o) {
        int s = this.getOutboundMobilityCandidacySubmission().compareTo(o.getOutboundMobilityCandidacySubmission());
        if (s != 0) {
            return s;
        }
        int p = this.getPreferenceOrder().compareTo(o.getPreferenceOrder());
        return p == 0 ? this.getExternalId().compareTo(o.getExternalId()) : p;
    }

    public void deleteWithNotification() {
        SystemSender sender = this.getRootDomainObject().getSystemSender();
        if (sender != null) {
            Registration registration = this.getOutboundMobilityCandidacySubmission().getRegistration();
            Recipient recipient = new Recipient(UserGroup.of((User[])new User[]{registration.getPerson().getUser()}));
            new Message((Sender)((Object)sender), recipient, BundleUtil.getString((String)"resources.StudentResources", (String)"label.email.deleted.contest.subject", (String[])new String[0]), BundleUtil.getString((String)"resources.StudentResources", (String)"label.email.deleted.contest.body", (String[])new String[]{this.getOutboundMobilityCandidacyContest().getMobilityAgreement().getUniversityUnit().getPresentationName()}));
        }
        this.delete();
    }

    public void select() {
        Object object = advice$select.perform((Callable)new OutboundMobilityCandidacy$callable$select(this));
    }

    static /* synthetic */ void advised$select(OutboundMobilityCandidacy this_) {
        OutboundMobilityCandidacySubmission submission = this_.getOutboundMobilityCandidacySubmission();
        if (submission.getSelectedCandidacy() != this_) {
            if (submission.getSelectedCandidacy() != null) {
                throw new DomainException("error.message.cannot.select.multiple.candidacies", submission.getRegistration().getPerson().getUsername());
            }
            OutboundMobilityCandidacyContest contest = this_.getOutboundMobilityCandidacyContest();
            if (contest.hasVacancy()) {
                this_.setSelected(Boolean.TRUE);
                submission.setSelectedCandidacy(this_);
            } else {
                throw new DomainException("error.message.contest.has.no.more.vacancies", new String[0]);
            }
        }
    }

    public void unselect() {
        Object object = advice$unselect.perform((Callable)new OutboundMobilityCandidacy$callable$unselect(this));
    }

    static /* synthetic */ void advised$unselect(OutboundMobilityCandidacy this_) {
        this_.setSelected(Boolean.FALSE);
        this_.setSubmissionFromSelectedCandidacy(null);
    }
}

