/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.graduatedPerson;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.events.candidacy.DegreeCandidacyForGraduatedPersonEvent;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacySeriesGrade;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyState;
import org.fenixedu.academic.domain.candidacyProcess.PrecedentDegreeInformationForIndividualCandidacyFactory;
import org.fenixedu.academic.domain.candidacyProcess.graduatedPerson.DegreeCandidacyForGraduatedPersonIndividualCandidacyResultBean;
import org.fenixedu.academic.domain.candidacyProcess.graduatedPerson.DegreeCandidacyForGraduatedPersonIndividualProcess;
import org.fenixedu.academic.domain.candidacyProcess.graduatedPerson.DegreeCandidacyForGraduatedPersonIndividualProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.graduatedPerson.DegreeCandidacyForGraduatedPersonSeriesGade;
import org.fenixedu.academic.domain.candidacyProcess.graduatedPerson.DegreeCandidacyForGraduatedPerson_Base;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.dto.candidacy.PrecedentDegreeInformationBean;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.LocalDate;

public class DegreeCandidacyForGraduatedPerson
extends DegreeCandidacyForGraduatedPerson_Base {
    private DegreeCandidacyForGraduatedPerson() {
    }

    DegreeCandidacyForGraduatedPerson(DegreeCandidacyForGraduatedPersonIndividualProcess process2, DegreeCandidacyForGraduatedPersonIndividualProcessBean bean) {
        this();
        Person person = this.init(bean, (IndividualCandidacyProcess)((Object)process2));
        this.createFormationEntries(bean.getFormationConcludedBeanList(), bean.getFormationNonConcludedBeanList());
        DegreeCandidacyForGraduatedPersonSeriesGade newSCICSeriesGrade = new DegreeCandidacyForGraduatedPersonSeriesGade();
        newSCICSeriesGrade.setDegree(bean.getSelectedDegree());
        this.getIndividualCandidacySeriesGradeSet().add(newSCICSeriesGrade);
        this.setSelectedDegree(bean.getSelectedDegree());
        if (bean.getInternalPersonCandidacy().booleanValue()) {
            this.createDebt(person);
        }
    }

    protected void checkParameters(Person person, IndividualCandidacyProcess process2, IndividualCandidacyProcessBean bean) {
        DegreeCandidacyForGraduatedPersonIndividualProcess degreeCandidacyProcess = (DegreeCandidacyForGraduatedPersonIndividualProcess)((Object)process2);
        DegreeCandidacyForGraduatedPersonIndividualProcessBean degreeCandidacyBean = (DegreeCandidacyForGraduatedPersonIndividualProcessBean)bean;
        LocalDate candidacyDate = degreeCandidacyBean.getCandidacyDate();
        Degree selectedDegree = degreeCandidacyBean.getSelectedDegree();
        PrecedentDegreeInformationBean precedentDegreeInformation = degreeCandidacyBean.getPrecedentDegreeInformation();
        this.checkParameters(person, degreeCandidacyProcess, candidacyDate, selectedDegree, precedentDegreeInformation);
    }

    private void checkParameters(Person person, DegreeCandidacyForGraduatedPersonIndividualProcess process2, LocalDate candidacyDate, Degree selectedDegree, PrecedentDegreeInformationBean precedentDegreeInformation) {
        this.checkParameters(person, (IndividualCandidacyProcess)((Object)process2), candidacyDate);
        if (selectedDegree == null) {
            throw new DomainException("error.DegreeCandidacyForGraduatedPerson.invalid.degree", new String[0]);
        }
        if (precedentDegreeInformation == null) {
            throw new DomainException("error.DegreeCandidacyForGraduatedPerson.invalid.precedentDegreeInformation", new String[0]);
        }
    }

    protected void createDebt(Person person) {
        new DegreeCandidacyForGraduatedPersonEvent(this, person);
    }

    public DegreeCandidacyForGraduatedPersonIndividualProcess getCandidacyProcess() {
        return (DegreeCandidacyForGraduatedPersonIndividualProcess)((Object)super.getCandidacyProcess());
    }

    public void editCandidacyInformation(DegreeCandidacyForGraduatedPersonIndividualProcessBean bean) {
        this.checkParameters(bean.getCandidacyDate(), bean.getSelectedDegree(), bean.getPrecedentDegreeInformation());
        this.setCandidacyDate(bean.getCandidacyDate());
        this.setSelectedDegree(bean.getSelectedDegree());
        PrecedentDegreeInformationForIndividualCandidacyFactory.edit(bean);
    }

    private void checkParameters(LocalDate candidacyDate, Degree selectedDegree, PrecedentDegreeInformationBean precedentDegreeInformation) {
        this.checkParameters(this.getPersonalDetails().getPerson(), (IndividualCandidacyProcess)((Object)this.getCandidacyProcess()), candidacyDate);
        if (selectedDegree == null) {
            throw new DomainException("error.DegreeCandidacyForGraduatedPerson.invalid.degree", new String[0]);
        }
        if (this.getRegistration() != null && this.getRegistration().getDegree() != selectedDegree) {
            throw new DomainException("error.DegreeCandidacyForGraduatedPerson.cannot.change.degree", new String[0]);
        }
        if (precedentDegreeInformation == null) {
            throw new DomainException("error.DegreeCandidacyForGraduatedPerson.invalid.precedentDegreeInformation", new String[0]);
        }
    }

    void editCandidacyResult(DegreeCandidacyForGraduatedPersonIndividualCandidacyResultBean bean) {
        this.checkParameters(bean);
        this.setAffinity(bean.getAffinity());
        this.setDegreeNature(bean.getDegreeNature());
        this.setCandidacyGrade(bean.getGrade());
        if (this.isCandidacyResultStateValid(bean.getState())) {
            this.setState(bean.getState());
        }
    }

    private void checkParameters(DegreeCandidacyForGraduatedPersonIndividualCandidacyResultBean bean) {
        if (this.isAccepted() && bean.getState() != IndividualCandidacyState.ACCEPTED && this.getRegistration() != null) {
            throw new DomainException("error.DegreeCandidacyForGraduatedPerson.cannot.change.state.from.accepted.candidacies", new String[0]);
        }
    }

    void editSelectedDegree(Degree selectedDegree) {
        this.setSelectedDegree(selectedDegree);
    }

    protected ExecutionYear getCandidacyExecutionInterval() {
        return (ExecutionYear)((Object)super.getCandidacyExecutionInterval());
    }

    protected Registration createRegistration(Person person, DegreeCurricularPlan degreeCurricularPlan, CycleType cycleType, IngressionType ingressionType) {
        Registration registration = super.createRegistration(person, degreeCurricularPlan, cycleType, ingressionType);
        registration.setRegistrationYear(this.getCandidacyExecutionInterval());
        return registration;
    }

    public void exportValues(StringBuilder result) {
        super.exportValues(result);
        Formatter formatter = new Formatter(result);
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.CandidateResources", (String)"label.process.id", (String[])new String[0]), this.getCandidacyProcess().getProcessCode());
        PrecedentDegreeInformation precedentDegreeInformation = this.getCandidacyProcess().getPrecedentDegreeInformation();
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.SecondCycleIndividualCandidacy.previous.degree", (String[])new String[0]), precedentDegreeInformation.getDegreeDesignation());
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.conclusionDate", (String[])new String[0]), precedentDegreeInformation.getConclusionDate());
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.SecondCycleIndividualCandidacy.institution", (String[])new String[0]), precedentDegreeInformation.getInstitution().getName());
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.conclusionGrade", (String[])new String[0]), precedentDegreeInformation.getConclusionGrade());
        formatter.format("\n", new Object[0]);
        formatter.format("%s: %f\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.SecondCycleIndividualCandidacy.affinity", (String[])new String[0]), this.getAffinity() != null ? this.getAffinity() : BigDecimal.ZERO);
        formatter.format("%s: %d\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.SecondCycleIndividualCandidacy.degreeNature", (String[])new String[0]), this.getDegreeNature() != null ? this.getDegreeNature() : 0);
        formatter.format("%s: %f\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.SecondCycleIndividualCandidacy.candidacyGrade", (String[])new String[0]), this.getCandidacyGrade() != null ? this.getCandidacyGrade() : BigDecimal.ZERO);
        formatter.close();
    }

    public String getDescription() {
        return this.getCandidacyProcess().getDisplayName() + (this.getSelectedDegree() != null ? ": " + this.getSelectedDegree().getNameI18N() : "");
    }

    public boolean isDegreeCandidacyForGraduatedPerson() {
        return true;
    }

    public DegreeCandidacyForGraduatedPersonSeriesGade getDegreeCandidacyForGraduatedPersonSeriesGadeForDegree(Degree degree) {
        for (IndividualCandidacySeriesGrade seriesGrade : this.getIndividualCandidacySeriesGradeSet()) {
            if (seriesGrade.getDegree() != degree) continue;
            return (DegreeCandidacyForGraduatedPersonSeriesGade)((Object)seriesGrade);
        }
        return null;
    }

    private DegreeCandidacyForGraduatedPersonSeriesGade getDegreeCandidacyForGraduatedPersonSeriesGade() {
        if (this.getIndividualCandidacySeriesGradeSet().size() == 0) {
            return null;
        }
        return (DegreeCandidacyForGraduatedPersonSeriesGade)((Object)this.getIndividualCandidacySeriesGradeSet().iterator().next());
    }

    public BigDecimal getAffinity() {
        if (this.getDegreeCandidacyForGraduatedPersonSeriesGade() != null) {
            return this.getDegreeCandidacyForGraduatedPersonSeriesGade().getAffinity();
        }
        return null;
    }

    public Integer getDegreeNature() {
        if (this.getDegreeCandidacyForGraduatedPersonSeriesGade() != null) {
            return this.getDegreeCandidacyForGraduatedPersonSeriesGade().getDegreeNature();
        }
        return null;
    }

    public BigDecimal getCandidacyGrade() {
        if (this.getDegreeCandidacyForGraduatedPersonSeriesGade() != null) {
            return this.getDegreeCandidacyForGraduatedPersonSeriesGade().getCandidacyGrade();
        }
        return null;
    }

    public Collection<Degree> getAllDegrees() {
        ArrayList<Degree> result = new ArrayList<Degree>();
        result.add(this.getSelectedDegree());
        return result;
    }

    public void setSelectedDegree(Degree selectedDegree) {
        this.getDegreeCandidacyForGraduatedPersonSeriesGade().setDegree(selectedDegree);
        super.setSelectedDegree(selectedDegree);
    }

    public void setAffinity(BigDecimal value) {
        this.getDegreeCandidacyForGraduatedPersonSeriesGade().setAffinity(value);
    }

    public void setDegreeNature(Integer value) {
        this.getDegreeCandidacyForGraduatedPersonSeriesGade().setDegreeNature(value);
    }

    public void setCandidacyGrade(BigDecimal value) {
        this.getDegreeCandidacyForGraduatedPersonSeriesGade().setCandidacyGrade(value);
    }
}

