/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.erasmus;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ExecutedActionType;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ReceptionEmailExecutedAction_Base;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.SendReceptionEmailBean;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityApplicationProcess;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityEmailTemplate;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityEmailTemplateType;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityIndividualApplicationProcess;
import org.fenixedu.academic.domain.exceptions.DomainException;

public class ReceptionEmailExecutedAction
extends ReceptionEmailExecutedAction_Base {
    protected ReceptionEmailExecutedAction() {
    }

    protected ReceptionEmailExecutedAction(ExecutedActionType type, MobilityApplicationProcess applicationProcess, List<MobilityIndividualApplicationProcess> subjectCandidacyProcesses, MobilityEmailTemplate template) {
        this();
        this.init(type, applicationProcess, subjectCandidacyProcesses, template);
        this.sendEmails();
    }

    protected void init(ExecutedActionType type, MobilityApplicationProcess applicationProcess, List<MobilityIndividualApplicationProcess> subjectCandidacyProcesses, MobilityEmailTemplate template) {
        super.init(type, applicationProcess, subjectCandidacyProcesses);
        if (StringUtils.isEmpty((String)template.getSubject())) {
            throw new DomainException("error.reception.email.executed.action.subject.is.empty", new String[0]);
        }
        if (StringUtils.isEmpty((String)template.getBody())) {
            throw new DomainException("error.reception.email.executed.action.body.is.empty", new String[0]);
        }
        if (!ExecutedActionType.SENT_RECEPTION_EMAIL.equals((Object)type)) {
            throw new DomainException("error.reception.email.executed.action.type.is.incorrect", new String[0]);
        }
        this.setMobilityEmailTemplate(template);
    }

    private void sendEmails() {
        this.getMobilityEmailTemplate().sendMultiEmailFor(this.getSubjectMobilityIndividualApplicationProcessSet());
    }

    protected static ReceptionEmailExecutedAction createAction(MobilityApplicationProcess applicationProcess, List<MobilityIndividualApplicationProcess> subjectCandidacyProcesses, MobilityEmailTemplate template) {
        return new ReceptionEmailExecutedAction(ExecutedActionType.SENT_RECEPTION_EMAIL, applicationProcess, subjectCandidacyProcesses, template);
    }

    public static ReceptionEmailExecutedAction createAction(MobilityApplicationProcess process2, SendReceptionEmailBean bean) {
        MobilityEmailTemplate receptionTemplate = process2.getCandidacyPeriod().getEmailTemplateFor(bean.getMobilityProgram(), MobilityEmailTemplateType.IST_RECEPTION);
        return ReceptionEmailExecutedAction.createAction(bean.getMobilityApplicationProcess(), bean.getSubjectProcesses(), receptionTemplate);
    }
}

