/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules;

import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.postingRules.FixedAmountWithPenaltyFromDatePR_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;

public class FixedAmountWithPenaltyFromDatePR
extends FixedAmountWithPenaltyFromDatePR_Base {
    protected FixedAmountWithPenaltyFromDatePR() {
    }

    public FixedAmountWithPenaltyFromDatePR(EntryType entryType, EventType eventType, DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money fixedAmount, Money fixedAmountPenalty, YearMonthDay whenToApplyFixedAmountPenalty) {
        this.init(entryType, eventType, startDate, endDate, serviceAgreementTemplate, fixedAmount, fixedAmountPenalty, whenToApplyFixedAmountPenalty);
    }

    protected void init(EntryType entryType, EventType eventType, DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money fixedAmount, Money fixedAmountPenalty, YearMonthDay whenToApplyFixedAmountPenalty) {
        super.init(entryType, eventType, startDate, endDate, serviceAgreementTemplate, fixedAmount, fixedAmountPenalty);
        this.checkParameters(whenToApplyFixedAmountPenalty);
        super.setWhenToApplyFixedAmountPenalty(whenToApplyFixedAmountPenalty);
    }

    private void checkParameters(YearMonthDay whenToApplyFixedAmountPenalty) {
        if (whenToApplyFixedAmountPenalty == null) {
            throw new DomainException("error.accounting.postingRules.FixedAmountWithPenaltyFromDatePR.whenToApplyFixedAmountPenalty.cannot.be.null", new String[0]);
        }
    }

    public void setWhenToApplyFixedAmountPenalty(YearMonthDay whenToApplyFixedAmountPenalty) {
        throw new DomainException("error.accounting.postingRules.FixedAmountWithPenaltyFromDatePR.cannot.modify.whenToApplyFixedAmountPenalty", new String[0]);
    }

    protected boolean hasPenalty(Event event, DateTime when) {
        return when.toYearMonthDay().isAfter((ReadablePartial)this.getWhenToApplyFixedAmountPenalty());
    }

    public FixedAmountWithPenaltyFromDatePR edit(Money fixedAmount, Money penaltyAmount, YearMonthDay whenToApplyFixedAmountPenalty) {
        this.deactivate();
        return new FixedAmountWithPenaltyFromDatePR(this.getEntryType(), this.getEventType(), new DateTime().minus(1000L), null, this.getServiceAgreementTemplate(), fixedAmount, penaltyAmount, whenToApplyFixedAmountPenalty);
    }
}

