/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.candidacy;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.Exemption;
import org.fenixedu.academic.domain.accounting.events.ExemptionJustification;
import org.fenixedu.academic.domain.accounting.events.candidacy.CandidacyExemptionJustificationType;
import org.fenixedu.academic.domain.accounting.events.candidacy.SecondCycleIndividualCandidacyEvent;
import org.fenixedu.academic.domain.accounting.events.candidacy.SecondCycleIndividualCandidacyExemptionJustification;
import org.fenixedu.academic.domain.accounting.events.candidacy.SecondCycleIndividualCandidacyExemption_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.joda.time.DateTime;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public class SecondCycleIndividualCandidacyExemption
extends SecondCycleIndividualCandidacyExemption_Base {
    private SecondCycleIndividualCandidacyExemption() {
    }

    public SecondCycleIndividualCandidacyExemption(Person responsible, SecondCycleIndividualCandidacyEvent event, CandidacyExemptionJustificationType candidacyExemptionJustificationType) {
        this();
        super.init(responsible, (Event)((Object)event), this.createJustification(candidacyExemptionJustificationType));
        event.recalculateState(new DateTime());
    }

    private ExemptionJustification createJustification(CandidacyExemptionJustificationType justificationType) {
        return new SecondCycleIndividualCandidacyExemptionJustification(this, justificationType);
    }

    public SecondCycleIndividualCandidacyEvent getEvent() {
        return (SecondCycleIndividualCandidacyEvent)((Object)super.getEvent());
    }

    public void delete() {
        this.checkRulesToDelete();
        super.delete();
    }

    private void checkRulesToDelete() {
        if (this.getEvent().hasAnyPayments()) {
            throw new DomainException("error.accounting.events.candidacy.SecondCycleIndividualCandidacyExemption.cannot.delete.event.has.payments", new String[0]);
        }
        if (this.getEvent().getIndividualCandidacy().isAccepted()) {
            throw new DomainException("error.accounting.events.candidacy.SecondCycleIndividualCandidacyExemption.cannot.delete.candidacy.is.accepted", new String[0]);
        }
    }

    public boolean isSecondCycleIndividualCandidacyExemption() {
        return true;
    }

    static {
        SecondCycleIndividualCandidacyExemption.getRelationExemptionEvent().addListener((RelationListener)new RelationAdapter<Exemption, Event>(){

            public void beforeAdd(Exemption exemption, Event event) {
                SecondCycleIndividualCandidacyEvent candidacyEvent;
                if (exemption != null && event != null && exemption instanceof SecondCycleIndividualCandidacyExemption && (candidacyEvent = (SecondCycleIndividualCandidacyEvent)((Object)event)).hasSecondCycleIndividualCandidacyExemption()) {
                    throw new DomainException("error.accounting.events.SecondCycleIndividualCandidacyExemption.event.already.has.exemption", new String[0]);
                }
            }
        });
    }
}

