/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events;

import java.util.Collections;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.events.PastAdministrativeOfficeFeeAndInsuranceEvent_Base;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.util.Money;

public class PastAdministrativeOfficeFeeAndInsuranceEvent
extends PastAdministrativeOfficeFeeAndInsuranceEvent_Base {
    protected PastAdministrativeOfficeFeeAndInsuranceEvent() {
    }

    public PastAdministrativeOfficeFeeAndInsuranceEvent(AdministrativeOffice administrativeOffice, Person person, ExecutionYear executionYear, Money pastAdministrativeOfficeFeeAndInsuranceAmount) {
        this();
        this.init(administrativeOffice, person, executionYear, pastAdministrativeOfficeFeeAndInsuranceAmount);
    }

    private void init(AdministrativeOffice administrativeOffice, Person person, ExecutionYear executionYear, Money pastAdministrativeOfficeFeeAndInsuranceAmount) {
        super.init(administrativeOffice, EventType.ADMINISTRATIVE_OFFICE_FEE_INSURANCE, person, executionYear);
        this.checkParameters(pastAdministrativeOfficeFeeAndInsuranceAmount);
        super.setPastAdministrativeOfficeFeeAndInsuranceAmount(pastAdministrativeOfficeFeeAndInsuranceAmount);
    }

    private void checkParameters(Money pastAdministrativeOfficeFeeAndInsuranceAmount) {
        if (pastAdministrativeOfficeFeeAndInsuranceAmount == null || pastAdministrativeOfficeFeeAndInsuranceAmount.isZero()) {
            throw new DomainException("error.org.fenixedu.academic.domain.accounting.events.PastAdministrativeOfficeFeeAndInsuranceEvent.pastAdministrativeOfficeFeeAndInsuranceAmount.cannot.be.null.and.must.be.greather.than.zero", new String[0]);
        }
    }

    public boolean isExemptionAppliable() {
        return true;
    }

    public Set<EntryType> getPossibleEntryTypesForDeposit() {
        return Collections.singleton(EntryType.ADMINISTRATIVE_OFFICE_FEE_INSURANCE);
    }

    public boolean isInDebt() {
        return this.isOpen();
    }
}

