/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting;

import java.math.BigDecimal;
import java.util.Comparator;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.Installment_Base;
import org.fenixedu.academic.domain.accounting.PaymentPlan;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.accounting.paymentPlan.InstallmentBean;
import org.fenixedu.academic.util.LabelFormatter;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;

public class Installment
extends Installment_Base {
    public static Comparator<Installment> COMPARATOR_BY_END_DATE = new Comparator<Installment>(){

        @Override
        public int compare(Installment leftInstallment, Installment rightInstallment) {
            int comparationResult = leftInstallment.getEndDate().compareTo((ReadablePartial)rightInstallment.getEndDate());
            return comparationResult == 0 ? leftInstallment.getExternalId().compareTo(rightInstallment.getExternalId()) : comparationResult;
        }
    };
    public static Comparator<Installment> COMPARATOR_BY_ORDER = new Comparator<Installment>(){

        @Override
        public int compare(Installment leftInstallment, Installment rightInstallment) {
            int comparationResult = leftInstallment.getInstallmentOrder().compareTo(rightInstallment.getInstallmentOrder());
            return comparationResult == 0 ? leftInstallment.getExternalId().compareTo(rightInstallment.getExternalId()) : comparationResult;
        }
    };

    protected Installment() {
        super.setRootDomainObject(Bennu.getInstance());
        super.setWhenCreated(new DateTime());
    }

    public Installment(PaymentPlan paymentPlan, Money amount, YearMonthDay startDate, YearMonthDay endDate) {
        this();
        this.init(paymentPlan, amount, startDate, endDate);
    }

    protected void init(PaymentPlan paymentPlan, Money amount, YearMonthDay startDate, YearMonthDay endDate) {
        this.checkParameters(paymentPlan, amount, startDate, endDate);
        super.setInstallmentOrder(Integer.valueOf(paymentPlan.getLastInstallmentOrder() + 1));
        super.setPaymentPlan(paymentPlan);
        super.setAmount(amount);
        super.setStartDate(startDate);
        super.setEndDate(endDate);
    }

    protected void checkParameters(PaymentPlan paymentPlan, Money amount, YearMonthDay startDate, YearMonthDay endDate) {
        if (paymentPlan == null) {
            throw new DomainException("error.accounting.Installment.paymentCondition.cannot.be.null", new String[0]);
        }
        this.checkParameters(amount, startDate, endDate);
    }

    private void checkParameters(Money amount, YearMonthDay startDate, YearMonthDay endDate) {
        if (amount == null) {
            throw new DomainException("error.accounting.Installment.amount.cannot.be.null", new String[0]);
        }
        if (startDate == null) {
            throw new DomainException("error.accounting.enclosing_type.startDate.cannot.be.null", new String[0]);
        }
        if (endDate == null) {
            throw new DomainException("error.accounting.Installment.endDate.cannot.be.null", new String[0]);
        }
    }

    public void setPaymentPlan(PaymentPlan paymentPlan) {
        throw new DomainException("error.accounting.Installment.cannot.modify.paymentPlan", new String[0]);
    }

    public void setAmount(Money amount) {
        throw new DomainException("error.accounting.Installment.cannot.modify.amount", new String[0]);
    }

    public void setStartDate(YearMonthDay startDate) {
        throw new DomainException("error.accounting.Installment.cannot.modify.startDate", new String[0]);
    }

    public void setEndDate(YearMonthDay endDate) {
        throw new DomainException("error.accounting.Installment.cannot.modify.endDate", new String[0]);
    }

    public void setWhenCreated(DateTime whenCreated) {
        throw new DomainException("error.accounting.installments.InstallmentWithMonthlyPenalty.cannot.modify.whenCreated", new String[0]);
    }

    public void setInstallmentOrder(Integer order) {
        throw new DomainException("error.accounting.Installment.cannot.modify.installmentOrder", new String[0]);
    }

    public Money calculateAmount(Event event, DateTime when, BigDecimal discountPercentage, boolean applyPenalty) {
        return this.calculateAmountWithDiscount(event, discountPercentage);
    }

    protected Money calculateAmountWithDiscount(Event event, BigDecimal discountPercentage) {
        return this.calculateBaseAmount(event).multiply(BigDecimal.ONE.subtract(discountPercentage));
    }

    protected Money calculateBaseAmount(Event event) {
        return this.getAmount();
    }

    public int getOrder() {
        return this.getInstallmentOrder();
    }

    public LabelFormatter getDescription() {
        LabelFormatter labelFormatter = new LabelFormatter();
        labelFormatter.appendLabel("resources.ApplicationResources", "label.Installment.description", this.getInstallmentOrder().toString(), this.getStartDate().toString("dd/MM/yyyy"), this.getEndDate().toString("dd/MM/yyyy"));
        return labelFormatter;
    }

    public boolean isWithMonthlyPenalty() {
        return false;
    }

    public boolean isForFirstTimeStudents() {
        return false;
    }

    public void delete() {
        super.setPaymentPlan(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public LocalDate getEndDate(Event event) {
        return super.getEndDate().toLocalDate();
    }

    public void edit(InstallmentBean bean) {
        Money amount = bean.getAmount();
        YearMonthDay startDate = bean.getStartDate();
        YearMonthDay endDate = bean.getEndDate();
        this.checkParameters(amount, startDate, endDate);
        super.setStartDate(startDate);
        super.setEndDate(endDate);
    }
}

