/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl;

import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.Set;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ScientificCommission;
import org.fenixedu.academic.domain.accessControl.FenixGroup;
import org.fenixedu.academic.domain.accessControl.PersistentScientificCommissionGroup;
import org.fenixedu.bennu.core.annotation.GroupArgument;
import org.fenixedu.bennu.core.annotation.GroupOperator;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.groups.PersistentGroup;
import org.joda.time.DateTime;

@GroupOperator(value="scientificCommission")
public class ScientificCommissionGroup
extends FenixGroup {
    private static final long serialVersionUID = 8999642876831933207L;
    @GroupArgument
    private Degree degree;

    private ScientificCommissionGroup() {
    }

    private ScientificCommissionGroup(Degree degree) {
        this();
        this.degree = degree;
    }

    public static ScientificCommissionGroup get(Degree degree) {
        return new ScientificCommissionGroup(degree);
    }

    @Override
    public String[] getPresentationNameKeyArgs() {
        return new String[]{this.degree.getPresentationName()};
    }

    public Set<User> getMembers() {
        HashSet<User> users = new HashSet<User>();
        for (ScientificCommission member : this.degree.getCurrentScientificCommissionMembers()) {
            User user = member.getPerson().getUser();
            if (user == null) continue;
            users.add(user);
        }
        return users;
    }

    public Set<User> getMembers(DateTime when) {
        return this.getMembers();
    }

    public boolean isMember(User user) {
        if (user == null) {
            return false;
        }
        for (ScientificCommission member : user.getPerson().getScientificCommissionsSet()) {
            if (!member.getExecutionDegree().getDegree().equals(this.degree)) continue;
            return true;
        }
        return false;
    }

    public boolean isMember(User user, DateTime when) {
        return this.isMember(user);
    }

    public PersistentGroup toPersistentGroup() {
        return PersistentScientificCommissionGroup.getInstance(this.degree);
    }

    public boolean equals(Object object) {
        if (object instanceof ScientificCommissionGroup) {
            return Objects.equal((Object)this.degree, (Object)((ScientificCommissionGroup)((Object)object)).degree);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.degree});
    }
}

