/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl;

import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.Set;
import org.fenixedu.academic.domain.accessControl.FenixGroup;
import org.fenixedu.academic.domain.accessControl.PersistentCerimonyInquiryGroup;
import org.fenixedu.academic.domain.alumni.CerimonyInquiry;
import org.fenixedu.academic.domain.alumni.CerimonyInquiryPerson;
import org.fenixedu.bennu.core.annotation.GroupArgument;
import org.fenixedu.bennu.core.annotation.GroupOperator;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.groups.PersistentGroup;
import org.joda.time.DateTime;

@GroupOperator(value="cerimonyInquiry")
public class CerimonyInquiryGroup
extends FenixGroup {
    private static final long serialVersionUID = 228948654158148141L;
    @GroupArgument
    private CerimonyInquiry cerimonyInquiry;

    private CerimonyInquiryGroup() {
    }

    private CerimonyInquiryGroup(CerimonyInquiry cerimonyInquiry) {
        this();
        this.cerimonyInquiry = cerimonyInquiry;
    }

    public static CerimonyInquiryGroup get(CerimonyInquiry cerimonyInquiry) {
        return new CerimonyInquiryGroup(cerimonyInquiry);
    }

    @Override
    public String[] getPresentationNameKeyArgs() {
        return new String[]{this.cerimonyInquiry.getDescription()};
    }

    public Set<User> getMembers() {
        HashSet<User> users = new HashSet<User>();
        for (CerimonyInquiryPerson cerimonyInquiryPerson : this.cerimonyInquiry.getCerimonyInquiryPersonSet()) {
            User user = cerimonyInquiryPerson.getPerson().getUser();
            if (user == null) continue;
            users.add(user);
        }
        return users;
    }

    public Set<User> getMembers(DateTime when) {
        return this.getMembers();
    }

    public boolean isMember(User user) {
        if (user == null) {
            return false;
        }
        for (CerimonyInquiryPerson cerimonyInquiryPerson : user.getPerson().getCerimonyInquiryPersonSet()) {
            if (!cerimonyInquiryPerson.getCerimonyInquiry().equals(this.cerimonyInquiry)) continue;
            return true;
        }
        return false;
    }

    public boolean isMember(User user, DateTime when) {
        return this.isMember(user);
    }

    public PersistentGroup toPersistentGroup() {
        return PersistentCerimonyInquiryGroup.getInstance(this.cerimonyInquiry);
    }

    public boolean equals(Object object) {
        if (object instanceof CerimonyInquiryGroup) {
            return Objects.equal((Object)this.cerimonyInquiry, (Object)((CerimonyInquiryGroup)((Object)object)).cerimonyInquiry);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.cerimonyInquiry});
    }
}

