/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.Comparator;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.academic.domain.thesis.Thesis;
import org.joda.time.DateTime;
import org.joda.time.ReadablePartial;

public interface IEnrolment
extends ICurriculumEntry {
    public static final Comparator<IEnrolment> COMPARATOR_BY_APPROVEMENT_DATE = new Comparator<IEnrolment>(){

        @Override
        public int compare(IEnrolment o1, IEnrolment o2) {
            if (o1.getApprovementDate() == null && o2.getApprovementDate() == null) {
                return 0;
            }
            if (o1.getApprovementDate() == null) {
                return -1;
            }
            if (o2.getApprovementDate() == null) {
                return 1;
            }
            return o1.getApprovementDate().compareTo((ReadablePartial)o2.getApprovementDate());
        }
    };

    @Override
    public String getExternalId();

    @Deprecated
    public Integer getFinalGrade();

    public String getDescription();

    public Double getEctsCredits();

    public Grade getEctsGrade(StudentCurricularPlan var1, DateTime var2);

    public boolean isAnual();

    public String getEnrolmentTypeName();

    public Double getWeigth();

    public Unit getAcademicUnit();

    public boolean isApproved();

    public boolean isEnroled();

    public boolean isExternalEnrolment();

    public boolean isEnrolment();

    public Thesis getThesis();

    public void delete();
}

