/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.resourceAllocationManager;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.fenixedu.academic.domain.FrequencyType;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.domain.LessonInstance;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.space.SpaceUtils;
import org.fenixedu.academic.dto.GenericPair;
import org.fenixedu.academic.dto.InfoLesson;
import org.fenixedu.academic.dto.InfoRoom;
import org.fenixedu.academic.dto.InfoRoomOccupationEditor;
import org.fenixedu.academic.dto.InfoShift;
import org.fenixedu.academic.dto.teacher.executionCourse.NextPossibleSummaryLessonsAndDatesBean;
import org.fenixedu.academic.service.services.exceptions.FenixServiceMultipleException;
import org.fenixedu.academic.service.services.resourceAllocationManager.CreateLesson;
import org.fenixedu.academic.service.services.resourceAllocationManager.DeleteLessonInstance;
import org.fenixedu.academic.service.services.resourceAllocationManager.DeleteLessons;
import org.fenixedu.academic.service.services.resourceAllocationManager.EditLesson;
import org.fenixedu.academic.ui.struts.action.exceptions.ExistingActionException;
import org.fenixedu.academic.ui.struts.action.exceptions.InterceptingActionException;
import org.fenixedu.academic.ui.struts.action.exceptions.InvalidTimeIntervalActionException;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.ExecutionPeriodDA;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.base.FenixShiftAndExecutionCourseAndExecutionDegreeAndCurricularYearContextDispatchAction;
import org.fenixedu.academic.ui.struts.action.utils.ContextUtils;
import org.fenixedu.academic.ui.struts.config.FenixErrorExceptionHandler;
import org.fenixedu.academic.util.DiaSemana;
import org.fenixedu.bennu.struts.annotations.ExceptionHandling;
import org.fenixedu.bennu.struts.annotations.Exceptions;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.Interval;
import org.joda.time.YearMonthDay;
import pt.ist.fenixframework.FenixFramework;

@Mapping(path="/manageLesson", module="resourceAllocationManager", input="/manageLesson.do?method=findInput&page=0", formBean="manageLessonForm", functionality=ExecutionPeriodDA.class)
@Forwards(value={@Forward(name="ShowLessonForm", path="/resourceAllocationManager/manageLesson_bd.jsp"), @Forward(name="EditShift", path="/resourceAllocationManager/manageShift.do?method=prepareEditShift&page=0"), @Forward(name="LessonDeleted", path="/resourceAllocationManager/manageShift.do?method=prepareEditShift&page=0"), @Forward(name="ViewAllLessonDates", path="/resourceAllocationManager/showAllLessonDates.jsp"), @Forward(name="ChangeRoom", path="/resourceAllocationManager/changeRoom_bd.jsp")})
@Exceptions(value={@ExceptionHandling(key="resources.Action.exceptions.ExistingActionException", handler=FenixErrorExceptionHandler.class, type=ExistingActionException.class), @ExceptionHandling(key="resources.Action.exceptions.InterceptingActionException", handler=FenixErrorExceptionHandler.class, type=InterceptingActionException.class), @ExceptionHandling(key="resources.Action.exceptions.InvalidTimeIntervalActionException", handler=FenixErrorExceptionHandler.class, type=InvalidTimeIntervalActionException.class)})
public class ManageLessonDA
extends FenixShiftAndExecutionCourseAndExecutionDegreeAndCurricularYearContextDispatchAction {
    public static String INVALID_TIME_INTERVAL = "errors.lesson.invalid.time.interval";
    public static String INVALID_WEEKDAY = "errors.lesson.invalid.weekDay";
    public static String UNKNOWN_ERROR = "errors.unknown";

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ContextUtils.setLessonContext(request);
        ActionForward actionForward = super.execute(mapping, actionForm, request, response);
        return actionForward;
    }

    public ActionForward findInput(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String action = request.getParameter("action");
        if (action != null && action.equals("edit")) {
            return this.prepareEdit(mapping, form, request, response);
        }
        return this.prepareCreate(mapping, form, request, response);
    }

    public ActionForward viewAllLessonDates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NextPossibleSummaryLessonsAndDatesBean bean;
        InfoLesson infoLesson = (InfoLesson)request.getAttribute("lesson_");
        Lesson lesson = infoLesson.getLesson();
        TreeSet<NextPossibleSummaryLessonsAndDatesBean> lessonDatesBean = new TreeSet<NextPossibleSummaryLessonsAndDatesBean>(NextPossibleSummaryLessonsAndDatesBean.COMPARATOR_BY_DATE_AND_HOUR);
        for (LessonInstance instance : infoLesson.getLesson().getLessonInstancesSet()) {
            bean = new NextPossibleSummaryLessonsAndDatesBean(lesson, instance.getDay());
            bean.setRoom(instance.getRoom());
            bean.setTime(instance.getStartTime());
            lessonDatesBean.add(bean);
        }
        if (!lesson.wasFinished()) {
            for (YearMonthDay yearMonthDay : lesson.getAllLessonDatesWithoutInstanceDates()) {
                bean = new NextPossibleSummaryLessonsAndDatesBean(lesson, yearMonthDay);
                bean.setRoom(lesson.getSala());
                bean.setTime(lesson.getBeginHourMinuteSecond());
                lessonDatesBean.add(bean);
            }
        }
        request.setAttribute("lessonDates", lessonDatesBean);
        request.setAttribute("lesson", (Object)lesson);
        return mapping.findForward("ViewAllLessonDates");
    }

    public ActionForward deleteLessonInstance(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NextPossibleSummaryLessonsAndDatesBean bean = NextPossibleSummaryLessonsAndDatesBean.getNewInstance(request.getParameter("lessonDate"));
        try {
            DeleteLessonInstance.run(bean.getLesson(), bean.getDate());
            ActionErrors actionErrors = new ActionErrors();
            actionErrors.add(null, new ActionError("message.deleteLesson", (Object)bean.getDate()));
            this.saveErrors(request, actionErrors);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            ActionErrors actionErrors = new ActionErrors();
            actionErrors.add(unsupportedOperationException.getMessage(), new ActionError("error.Lesson.not.instanced", (Object)bean.getDate()));
            this.saveErrors(request, actionErrors);
        }
        catch (DomainException domainException) {
            ActionErrors actionErrors = new ActionErrors();
            actionErrors.add(domainException.getMessage(), new ActionError(domainException.getMessage()));
            this.saveErrors(request, actionErrors);
        }
        return this.viewAllLessonDates(mapping, form, request, response);
    }

    public ActionForward deleteLessonInstances(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TreeSet<NextPossibleSummaryLessonsAndDatesBean> set = new TreeSet<NextPossibleSummaryLessonsAndDatesBean>();
        for (String lessonDate : request.getParameterValues("lessonDatesToDelete")) {
            set.add(NextPossibleSummaryLessonsAndDatesBean.getNewInstance(lessonDate));
        }
        try {
            DeleteLessonInstance.run(set);
            ActionErrors actionErrors = new ActionErrors();
            for (NextPossibleSummaryLessonsAndDatesBean n : set) {
                actionErrors.add(null, new ActionError("message.deleteLesson", (Object)n.getDate()));
            }
            this.saveErrors(request, actionErrors);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            ActionErrors actionErrors = new ActionErrors();
            for (NextPossibleSummaryLessonsAndDatesBean n : set) {
                actionErrors.add(unsupportedOperationException.getMessage(), new ActionError("error.Lesson.not.instanced", (Object)n.getDate()));
            }
            this.saveErrors(request, actionErrors);
        }
        catch (DomainException domainException) {
            ActionErrors actionErrors = new ActionErrors();
            actionErrors.add(domainException.getMessage(), new ActionError(domainException.getMessage()));
            this.saveErrors(request, actionErrors);
        }
        return this.viewAllLessonDates(mapping, form, request, response);
    }

    public ActionForward prepareCreate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaActionForm manageLessonForm = (DynaActionForm)form;
        InfoShift infoShift = (InfoShift)request.getAttribute("shift");
        Shift shift = (Shift)FenixFramework.getDomainObject((String)infoShift.getExternalId());
        GenericPair<YearMonthDay, YearMonthDay> maxLessonsPeriod = shift.getExecutionCourse().getMaxLessonsPeriod();
        if (maxLessonsPeriod == null) {
            ActionErrors actionErrors = new ActionErrors();
            actionErrors.add("error.executionDegree.empty.lessonsPeriod", new ActionError("error.executionDegree.empty.lessonsPeriod"));
            this.saveErrors(request, actionErrors);
            return mapping.findForward("EditShift");
        }
        request.setAttribute("executionDegreeLessonsStartDate", (Object)maxLessonsPeriod.getLeft().toString("dd/MM/yyyy"));
        request.setAttribute("executionDegreeLessonsEndDate", (Object)maxLessonsPeriod.getRight().toString("dd/MM/yyyy"));
        manageLessonForm.set("newBeginDate", (Object)maxLessonsPeriod.getLeft().toString("dd/MM/yyyy"));
        manageLessonForm.set("newEndDate", (Object)maxLessonsPeriod.getRight().toString("dd/MM/yyyy"));
        manageLessonForm.set("createLessonInstances", (Object)Boolean.TRUE);
        return mapping.findForward("ShowLessonForm");
    }

    public ActionForward prepareEdit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaActionForm manageLessonForm = (DynaActionForm)form;
        InfoLesson infoLesson = (InfoLesson)request.getAttribute("lesson_");
        manageLessonForm.set("diaSemana", (Object)infoLesson.getDiaSemana().getDiaSemana().toString());
        manageLessonForm.set("horaInicio", (Object)("" + infoLesson.getInicio().get(11)));
        manageLessonForm.set("minutosInicio", (Object)("" + infoLesson.getInicio().get(12)));
        manageLessonForm.set("horaFim", (Object)("" + infoLesson.getFim().get(11)));
        manageLessonForm.set("minutosFim", (Object)("" + infoLesson.getFim().get(12)));
        Space allocatableSpace = infoLesson.getAllocatableSpace();
        if (allocatableSpace != null) {
            manageLessonForm.set("nomeSala", (Object)("" + allocatableSpace.getName()));
        }
        if (infoLesson.getFrequency().equals((Object)FrequencyType.BIWEEKLY)) {
            manageLessonForm.set("quinzenal", (Object)Boolean.TRUE);
        }
        if (infoLesson.getLessonBegin() != null) {
            manageLessonForm.set("newBeginDate", (Object)infoLesson.getLessonBegin().toString("dd/MM/yyyy"));
        }
        if (infoLesson.getLessonEnd() != null) {
            manageLessonForm.set("newEndDate", (Object)infoLesson.getLessonEnd().toString("dd/MM/yyyy"));
        }
        manageLessonForm.set("createLessonInstances", (Object)Boolean.TRUE);
        Lesson lesson = (Lesson)FenixFramework.getDomainObject((String)infoLesson.getExternalId());
        GenericPair<YearMonthDay, YearMonthDay> maxLessonsPeriod = lesson.getShift().getExecutionCourse().getMaxLessonsPeriod();
        if (maxLessonsPeriod != null) {
            request.setAttribute("executionDegreeLessonsStartDate", (Object)maxLessonsPeriod.getLeft().toString("dd/MM/yyyy"));
            request.setAttribute("executionDegreeLessonsEndDate", (Object)maxLessonsPeriod.getRight().toString("dd/MM/yyyy"));
        }
        request.setAttribute("action", (Object)"edit");
        return mapping.findForward("ShowLessonForm");
    }

    public ActionForward prepareChangeRoom(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.viewAllLessonDates(mapping, form, request, response);
        InfoLesson infoLesson = (InfoLesson)request.getAttribute("lesson_");
        Interval[] intervals = infoLesson.getLesson().getAllLessonIntervals().toArray(new Interval[0]);
        List<Space> emptySpaces = SpaceUtils.allocatableSpace(null, true, intervals);
        Collections.sort(emptySpaces, SpaceUtils.COMPARATOR_BY_PRESENTATION_NAME);
        request.setAttribute("emptySpaces", emptySpaces);
        return mapping.findForward("ChangeRoom");
    }

    public ActionForward changeRoom(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InfoLesson infoLesson = (InfoLesson)request.getAttribute("lesson_");
        Space space = (Space)this.getDomainObject(request, "spaceOID");
        try {
            EditLesson.run(infoLesson.getLesson(), space);
        }
        catch (DomainException domainException) {
            ActionErrors actionErrors = new ActionErrors();
            actionErrors.add(domainException.getMessage(), new ActionError(domainException.getMessage(), (Object[])domainException.getArgs()));
            this.saveErrors(request, actionErrors);
        }
        return this.viewAllLessonDates(mapping, form, request, response);
    }

    public ActionForward createEditLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaActionForm manageLessonForm = (DynaActionForm)form;
        request.setAttribute("manageLessonForm", (Object)manageLessonForm);
        ContextUtils.setExecutionPeriodContext(request);
        DiaSemana weekDay = new DiaSemana(new Integer(this.formDay2EnumerateDay((String)manageLessonForm.get("diaSemana"))));
        YearMonthDay newBeginDate = this.getDateFromForm(manageLessonForm, "newBeginDate");
        YearMonthDay newEndDate = this.getDateFromForm(manageLessonForm, "newEndDate");
        Boolean quinzenal = (Boolean)manageLessonForm.get("quinzenal");
        if (quinzenal == null) {
            quinzenal = new Boolean(false);
        }
        Calendar inicio = Calendar.getInstance();
        inicio.set(11, Integer.parseInt((String)manageLessonForm.get("horaInicio")));
        inicio.set(12, Integer.parseInt((String)manageLessonForm.get("minutosInicio")));
        inicio.set(13, 0);
        inicio.set(14, 0);
        Calendar fim = Calendar.getInstance();
        fim.setTimeInMillis(inicio.getTimeInMillis());
        fim.set(11, Integer.parseInt((String)manageLessonForm.get("horaFim")));
        fim.set(12, Integer.parseInt((String)manageLessonForm.get("minutosFim")));
        fim.set(13, 0);
        fim.set(14, 0);
        InfoRoom infoSala = null;
        if (!StringUtils.isEmpty((String)((String)manageLessonForm.get("nomeSala")))) {
            infoSala = new InfoRoom(SpaceUtils.findAllocatableSpaceForEducationByName((String)manageLessonForm.get("nomeSala")));
        }
        ActionErrors actionErrors = this.checkTimeIntervalAndWeekDay(inicio, fim, weekDay);
        Lesson lesson = null;
        if (actionErrors.isEmpty()) {
            String action;
            InfoShift infoShift = (InfoShift)request.getAttribute("shift");
            InfoRoomOccupationEditor infoRoomOccupation = null;
            if (infoSala != null) {
                infoRoomOccupation = new InfoRoomOccupationEditor();
                infoRoomOccupation.setDayOfWeek(weekDay);
                infoRoomOccupation.setEndTime(fim);
                infoRoomOccupation.setStartTime(inicio);
                infoRoomOccupation.setInfoRoom(infoSala);
            }
            FrequencyType frequency = quinzenal != false ? FrequencyType.BIWEEKLY : FrequencyType.WEEKLY;
            if (infoRoomOccupation != null) {
                infoRoomOccupation.setFrequency(frequency);
            }
            if ((action = request.getParameter("action")) != null && action.equals("edit")) {
                InfoLesson infoLessonOld = (InfoLesson)request.getAttribute("lesson_");
                Boolean createLessonInstances = (Boolean)manageLessonForm.get("createLessonInstances");
                try {
                    lesson = EditLesson.run(infoLessonOld, weekDay, inicio, fim, frequency, infoRoomOccupation, infoShift, newBeginDate, newEndDate, createLessonInstances);
                }
                catch (DomainException domainException) {
                    actionErrors.add(domainException.getMessage(), new ActionError(domainException.getMessage(), (Object[])domainException.getArgs()));
                    this.saveErrors(request, actionErrors);
                }
            } else {
                try {
                    lesson = CreateLesson.run(weekDay, inicio, fim, frequency, infoRoomOccupation, infoShift, newBeginDate, newEndDate);
                }
                catch (DomainException domainException) {
                    actionErrors.add(domainException.getMessage(), new ActionError(domainException.getMessage(), (Object[])domainException.getArgs()));
                    this.saveErrors(request, actionErrors);
                }
            }
            if (lesson != null) {
                request.setAttribute("lesson_", (Object)InfoLesson.newInfoFromDomain(lesson));
                request.setAttribute("action", (Object)(action != null ? action : "create"));
                request.setAttribute("lesson", (Object)InfoLesson.newInfoFromDomain(lesson));
                return this.prepareChangeRoom(mapping, (ActionForm)manageLessonForm, request, response);
            }
            return mapping.findForward("EditShift");
        }
        this.saveErrors(request, actionErrors);
        return mapping.getInputForward();
    }

    public ActionForward deleteLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ArrayList<String> lessons = new ArrayList<String>();
        lessons.add(request.getParameter("lessonOID"));
        try {
            DeleteLessons.run(lessons);
        }
        catch (FenixServiceMultipleException e) {
            ActionErrors actionErrors = new ActionErrors();
            for (DomainException domainException : e.getExceptionList()) {
                actionErrors.add(domainException.getMessage(), new ActionError(domainException.getMessage(), (Object[])domainException.getArgs()));
            }
            this.saveErrors(request, actionErrors);
            return mapping.findForward("LessonDeleted");
        }
        request.removeAttribute("lessonOID");
        return mapping.findForward("LessonDeleted");
    }

    private YearMonthDay getDateFromForm(DynaActionForm manageLessonForm, String property) {
        String newDateString = (String)manageLessonForm.get(property);
        if (!StringUtils.isEmpty((String)newDateString)) {
            try {
                int day = Integer.parseInt(newDateString.substring(0, 2));
                int month = Integer.parseInt(newDateString.substring(3, 5));
                int year = Integer.parseInt(newDateString.substring(6, 10));
                if (year == 0 || month == 0 || day == 0) {
                    return null;
                }
                return new YearMonthDay(year, month, day);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private String formDay2EnumerateDay(String string) {
        String result = string;
        if (string.equalsIgnoreCase("2")) {
            result = "2";
        }
        if (string.equalsIgnoreCase("3")) {
            result = "3";
        }
        if (string.equalsIgnoreCase("4")) {
            result = "4";
        }
        if (string.equalsIgnoreCase("5")) {
            result = "5";
        }
        if (string.equalsIgnoreCase("6")) {
            result = "6";
        }
        if (string.equalsIgnoreCase("S")) {
            result = "7";
        }
        return result;
    }

    private ActionErrors checkTimeIntervalAndWeekDay(Calendar begining, Calendar end, DiaSemana weekday) {
        ActionErrors actionErrors = new ActionErrors();
        String beginMinAppend = "";
        String endMinAppend = "";
        if (begining.get(12) == 0) {
            beginMinAppend = "0";
        }
        if (end.get(12) == 0) {
            endMinAppend = "0";
        }
        if (begining.getTime().getTime() >= end.getTime().getTime()) {
            actionErrors.add(INVALID_TIME_INTERVAL, new ActionError(INVALID_TIME_INTERVAL, (Object)("" + begining.get(11) + ":" + begining.get(12) + beginMinAppend + " - " + end.get(11) + ":" + end.get(12) + endMinAppend)));
        }
        if (weekday.getDiaSemana() < 1 || weekday.getDiaSemana() > 7) {
            actionErrors.add(INVALID_WEEKDAY, new ActionError(INVALID_WEEKDAY, (Object)""));
        }
        return actionErrors;
    }
}

