/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.resourceAllocationManager;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeModuleScope;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.dto.resourceAllocationManager.ContextSelectionBean;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.RAMApplication;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=RAMApplication.RAMExecutionCoursesApp.class, path="list-groupings", titleKey="link.list.execution.course.groupings")
@Mapping(path="/listExecutionCourseGroupings", module="resourceAllocationManager")
@Forwards(value={@Forward(name="show-choose-execution-period-page", path="/resourceAllocationManager/listExecutionCourseGroupings_bd.jsp")})
public class ListExecutionCourseGroupingsDA
extends FenixDispatchAction {
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("context_selection_bean", (Object)new ContextSelectionBean());
        return mapping.findForward("show-choose-execution-period-page");
    }

    @EntryPoint
    public ActionForward selectExecutionPeriod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ContextSelectionBean contextSelectionBean = (ContextSelectionBean)this.getRenderedObject();
        RenderUtils.invalidateViewState();
        if (contextSelectionBean == null) {
            request.setAttribute("context_selection_bean", (Object)new ContextSelectionBean());
            return mapping.findForward("show-choose-execution-period-page");
        }
        request.setAttribute("context_selection_bean", (Object)contextSelectionBean);
        return mapping.findForward("show-choose-execution-period-page");
    }

    public ActionForward downloadExecutionCourseGroupings(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AcademicInterval academicInterval = AcademicInterval.getAcademicIntervalFromResumedString(request.getParameter("academicInterval"));
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment; filename=executionCourseGroupings_" + academicInterval.getPathName().replace(' ', '_') + "_.xls");
        ServletOutputStream servletOutputStream = response.getOutputStream();
        this.exportToXls(servletOutputStream, academicInterval);
        servletOutputStream.flush();
        response.flushBuffer();
        return null;
    }

    private void exportToXls(ServletOutputStream servletOutputStream, AcademicInterval academicInterval) throws IOException {
        List<Object> headers = this.getHeaders();
        Spreadsheet spreadsheet = new Spreadsheet("Execution Course Groupings", headers);
        this.fillSpreadSheet(spreadsheet, academicInterval);
        spreadsheet.exportToXLSSheet((OutputStream)servletOutputStream);
    }

    private List<Object> getHeaders() {
        ArrayList<Object> headers = new ArrayList<Object>();
        headers.add("Execution Course");
        headers.add("Responsible Fors");
        headers.add("Number of Degrees");
        headers.add("Degrees");
        headers.add("Curricular Years");
        headers.add("Degree Types");
        headers.add("Emails");
        headers.add("Enrolments");
        headers.add("Attends");
        return headers;
    }

    private void fillSpreadSheet(Spreadsheet spreadsheet, AcademicInterval academicInterval) {
        for (ExecutionCourse executionCourse : ExecutionCourse.filterByAcademicInterval(academicInterval)) {
            Spreadsheet.Row row = spreadsheet.addRow();
            row.setCell(executionCourse.getNome());
            StringBuilder responsibleForStringBuilder = new StringBuilder();
            StringBuilder responsibleForEmailsStringBuilder = new StringBuilder();
            boolean isFirstResp = true;
            for (Professorship professorship : executionCourse.getProfessorshipsSet()) {
                if (!professorship.getResponsibleFor().booleanValue()) continue;
                if (isFirstResp) {
                    isFirstResp = false;
                } else {
                    responsibleForStringBuilder.append("; ");
                    responsibleForEmailsStringBuilder.append("; ");
                }
                Teacher teacher = professorship.getTeacher();
                responsibleForStringBuilder.append(teacher.getPerson().getUsername());
                responsibleForStringBuilder.append(" ");
                Person person = teacher.getPerson();
                responsibleForStringBuilder.append(person.getName());
                responsibleForEmailsStringBuilder.append(person.getEmail());
            }
            row.setCell(responsibleForStringBuilder.toString());
            Map<Degree, Set<Integer>> degreeOccurenceMap = this.constructDegreeOccurenceMap(academicInterval, executionCourse);
            row.setCell(Integer.toString(degreeOccurenceMap.size()));
            StringBuilder degreeStringBuilder = new StringBuilder();
            boolean isFirst = true;
            for (Degree degree : degreeOccurenceMap.keySet()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    degreeStringBuilder.append("; ");
                }
                degreeStringBuilder.append(degree.getSigla());
            }
            row.setCell(degreeStringBuilder.toString());
            StringBuilder degreeCurricularYearStringBuilder = new StringBuilder();
            isFirst = true;
            for (Map.Entry<Degree, Set<Integer>> entry : degreeOccurenceMap.entrySet()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    degreeCurricularYearStringBuilder.append("; ");
                }
                Iterator degree3 = entry.getKey();
                degreeCurricularYearStringBuilder.append(degree3.getSigla());
                degreeCurricularYearStringBuilder.append('(');
                boolean isFirstYear = true;
                for (Integer curricularYearInteger : entry.getValue()) {
                    if (isFirstYear) {
                        isFirstYear = false;
                    } else {
                        degreeCurricularYearStringBuilder.append(", ");
                    }
                    degreeCurricularYearStringBuilder.append(curricularYearInteger.toString());
                }
                degreeCurricularYearStringBuilder.append(')');
            }
            row.setCell(degreeCurricularYearStringBuilder.toString());
            StringBuilder stringBuilder = new StringBuilder();
            TreeSet<DegreeType> degreeTypes = new TreeSet<DegreeType>();
            for (Degree degree4 : degreeOccurenceMap.keySet()) {
                degreeTypes.add(degree4.getDegreeType());
            }
            for (DegreeType degreeType : degreeTypes) {
                if (stringBuilder.length() > 0) {
                    degreeStringBuilder.append(", ");
                }
                stringBuilder.append(degreeType);
            }
            row.setCell(stringBuilder.toString());
            row.setCell(responsibleForEmailsStringBuilder.toString());
            int enrolmentCount = 0;
            for (Attends attends : executionCourse.getAttendsSet()) {
                if (attends.getEnrolment() == null) continue;
                ++enrolmentCount;
            }
            row.setCell(Integer.valueOf(enrolmentCount));
            row.setCell(Integer.valueOf(executionCourse.getAttendsSet().size()));
        }
    }

    private Map<Degree, Set<Integer>> constructDegreeOccurenceMap(AcademicInterval academicInterval, ExecutionCourse executionCourse) {
        HashMap<Degree, Set<Integer>> degreeOccurenceMap = new HashMap<Degree, Set<Integer>>();
        for (CurricularCourse curricularCourse : executionCourse.getAssociatedCurricularCoursesSet()) {
            List<DegreeModuleScope> degreeModuleScopes = curricularCourse.getActiveDegreeModuleScopesInAcademicInterval(academicInterval);
            for (DegreeModuleScope degreeModuleScope : degreeModuleScopes) {
                Set<Integer> curricularYears;
                Degree degree = curricularCourse.getDegreeCurricularPlan().getDegree();
                if (degreeOccurenceMap.containsKey(degree)) {
                    curricularYears = (Set)degreeOccurenceMap.get(degree);
                } else {
                    curricularYears = new TreeSet();
                    degreeOccurenceMap.put(degree, curricularYears);
                }
                curricularYears.add(degreeModuleScope.getCurricularYear());
            }
        }
        return degreeOccurenceMap;
    }
}

