/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.rectorate.batches;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.RectorateSubmissionBatch;
import org.fenixedu.academic.domain.serviceRequests.RectorateSubmissionState;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IDocumentRequest;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.commons.documentRequestExcel.DocumentRequestExcelUtils;
import org.fenixedu.academic.ui.struts.action.commons.zip.ZipUtils;
import org.fenixedu.academic.ui.struts.action.rectorate.batches.RectorateApplication;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=RectorateApplication.class, path="incoming-batches", titleKey="title.rectorateSubmission.received")
@Mapping(path="/rectorateIncomingBatches", module="rectorate")
@Forwards(value={@Forward(name="index", path="/rectorate/incomingBatches.jsp"), @Forward(name="viewBatch", path="/rectorate/showBatch.jsp")})
public class RectorateIncomingBatchesDispatchAction
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward index(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        HashSet<RectorateSubmissionBatch> batches = new HashSet<RectorateSubmissionBatch>();
        for (RectorateSubmissionBatch batch : RectorateSubmissionBatch.getRectorateSubmissionBatchesByState(rootDomainObject.getAdministrativeOfficesSet(), RectorateSubmissionState.SENT)) {
            if (this.getRelevantDocuments(batch.getDocumentRequestSet()).isEmpty()) continue;
            batches.add(batch);
        }
        request.setAttribute("batches", batches);
        return mapping.findForward("index");
    }

    private boolean obeysToPresentationRestriction(AcademicServiceRequest docRequest) {
        return !docRequest.isCancelled() && !docRequest.isRejected() && docRequest.isRegistryDiploma() || docRequest.isDiplomaSupplement();
    }

    private Set<AcademicServiceRequest> getRelevantDocuments(Set<AcademicServiceRequest> documentRequestSet) {
        HashSet<AcademicServiceRequest> requests = new HashSet<AcademicServiceRequest>();
        for (AcademicServiceRequest docRequest : documentRequestSet) {
            if (!this.obeysToPresentationRestriction(docRequest)) continue;
            requests.add(docRequest);
        }
        return requests;
    }

    public ActionForward viewBatch(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        RectorateSubmissionBatch batch = (RectorateSubmissionBatch)((Object)this.getDomainObject(request, "batchOid"));
        HashSet<String> actions = new HashSet<String>();
        actions.add("generateMetadataForRegistry");
        actions.add("zipDocuments");
        request.setAttribute("batch", (Object)batch);
        Set<AcademicServiceRequest> requests = this.getRelevantDocuments(batch.getDocumentRequestSet());
        request.setAttribute("requests", requests);
        request.setAttribute("actions", actions);
        return mapping.findForward("viewBatch");
    }

    public ActionForward zipDocuments(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        RectorateSubmissionBatch batch = (RectorateSubmissionBatch)((Object)this.getDomainObject(request, "batchOid"));
        Set<AcademicServiceRequest> requestsToZip = this.getRelevantDocuments(batch.getDocumentRequestSet());
        if (!requestsToZip.isEmpty()) {
            ZipUtils zipUtils = new ZipUtils();
            zipUtils.createAndFlushArchive(requestsToZip, response, batch);
            return null;
        }
        this.addActionMessage(request, "error.rectorateSubmission.noDocumentsToZip");
        request.setAttribute("batchOid", (Object)batch.getExternalId());
        return this.viewBatch(mapping, actionForm, request, response);
    }

    public ActionForward generateMetadataForRegistry(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        RectorateSubmissionBatch batch = (RectorateSubmissionBatch)((Object)this.getDomainObject(request, "batchOid"));
        Set<AcademicServiceRequest> docs = this.getRelevantDocuments(batch.getDocumentRequestSet());
        DocumentRequestExcelUtils excelUtils = new DocumentRequestExcelUtils(request, response);
        excelUtils.generateSortedExcel(docs, "registos-");
        return null;
    }

    protected IDocumentRequest getDocumentRequest(HttpServletRequest request) {
        return (IDocumentRequest)FenixFramework.getDomainObject((String)this.getRequestParameterAsString(request, "documentRequestId"));
    }

    public ActionForward printDocument(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        IDocumentRequest documentRequest = this.getDocumentRequest(request);
        try {
            byte[] data = documentRequest.generateDocument();
            response.setContentLength(data.length);
            response.setContentType("application/pdf");
            response.addHeader("Content-Disposition", "attachment; filename=" + documentRequest.getReportFileName() + ".pdf");
            ServletOutputStream writer = response.getOutputStream();
            writer.write(data);
            writer.flush();
            writer.close();
            response.flushBuffer();
            return null;
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getKey());
            return this.viewBatch(mapping, actionForm, request, response);
        }
    }
}

