/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.publico.candidacies.erasmus;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Installation;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.PublicCandidacyHashCode;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.DegreeOfficePublicCandidacyHashCode;
import org.fenixedu.academic.domain.candidacyProcess.DegreeOfficePublicCandidacyHashCodeOperations;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFile;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ApprovedLearningAgreementDocumentFile;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ErasmusApplyForSemesterType;
import org.fenixedu.academic.domain.candidacyProcess.exceptions.HashCodeForEmailAndProcessAlreadyBounded;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityApplicationProcess;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityIndividualApplicationProcess;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityIndividualApplicationProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityProgram;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityQuota;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityStudentDataBean;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UniversityUnit;
import org.fenixedu.academic.domain.person.IDDocumentType;
import org.fenixedu.academic.domain.util.email.EmailBean;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.domain.util.email.SystemSender;
import org.fenixedu.academic.dto.person.PersonBean;
import org.fenixedu.academic.report.candidacy.erasmus.LearningAgreementDocument;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.candidacy.erasmus.DegreeCourseInformationBean;
import org.fenixedu.academic.ui.struts.action.commons.FenixActionForward;
import org.fenixedu.academic.ui.struts.action.publico.PublicApplication;
import org.fenixedu.academic.ui.struts.action.publico.candidacies.RefactoredIndividualCandidacyProcessPublicDA;
import org.fenixedu.academic.util.report.ReportsUtils;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.i18n.I18N;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixWebFramework.rendererExtensions.util.IPresentableEnum;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=PublicApplication.PublicCandidaciesApp.class, path="mobility", titleKey="title.application.name.mobility")
@Mapping(path="/candidacies/caseHandlingMobilityApplicationIndividualProcess", module="publico")
@Forwards(value={@Forward(name="show-pre-creation-candidacy-form", path="/publico/candidacy/mobility/preCreationCandidacyForm.jsp"), @Forward(name="show-email-message-sent", path="/publico/candidacy/mobility/showEmailSent.jsp"), @Forward(name="show-application-submission-conditions", path="/publico/candidacy/mobility/applicationSubmissionConditions.jsp"), @Forward(name="open-candidacy-processes-not-found", path="/publico/candidacy/mobility/individualCandidacyNotFound.jsp"), @Forward(name="show-candidacy-creation-page", path="/publico/candidacy/mobility/createCandidacyPartOne.jsp"), @Forward(name="candidacy-continue-creation", path="/publico/candidacy/mobility/createCandidacyPartTwo.jsp"), @Forward(name="choose-mobility-program", path="/publico/candidacy/mobility/chooseMobilityProgram.jsp"), @Forward(name="fill-degree-and-courses-information", path="/publico/candidacy/mobility/fillDegreeAndCoursesInformation.jsp"), @Forward(name="accept-honour-declaration", path="/publico/candidacy/mobility/acceptHonourDeclaration.jsp"), @Forward(name="inform-submited-candidacy", path="/publico/candidacy/mobility/candidacySubmited.jsp"), @Forward(name="show-candidacy-details", path="/publico/candidacy/mobility/viewCandidacy.jsp"), @Forward(name="edit-candidacy", path="/publico/candidacy/mobility/editCandidacy.jsp"), @Forward(name="edit-candidacy-information", path="/publico/candidacy/mobility/editCandidacyInformation.jsp"), @Forward(name="edit-candidacy-degree-and-courses", path="/publico/candidacy/mobility/editCandidacyDegreeAndCourses.jsp"), @Forward(name="edit-candidacy-documents", path="/publico/candidacy/mobility/editCandidacyDocuments.jsp"), @Forward(name="edit-candidacy-degree-and-courses", path="/publico/candidacy/mobility/editCandidacyDegreeAndCourses.jsp"), @Forward(name="redirect-to-peps", path="/publico/candidacy/mobility/peps.jsp"), @Forward(name="show-application-submission-conditions-for-stork", path="/publico/candidacy/mobility/applicationSubmissionConditionsForStork.jsp"), @Forward(name="show-stork-error-page", path="/publico/candidacy/mobility/showStorkErrorPage.jsp"), @Forward(name="stork-candidacy-already-bounded", path="/publico/candidacy/mobility/candidacyAlreadyBounded.jsp"), @Forward(name="redirect-to-peps-to-access-application", path="/publico/candidacy/mobility/pepsAccessAplication.jsp"), @Forward(name="stork-error-authentication-failed", path="/publico/candidacy/mobility/storkAuthenticationFailed.jsp"), @Forward(name="show-recover-access-link-form", path="/publico/candidacy/mobility/recoverAccess.jsp"), @Forward(name="show-recovery-email-sent", path="/publico/candidacy/mobility/recoveryEmailSent.jsp"), @Forward(name="stork-attr-list-test", path="/publico/candidacy/mobility/storkAttrListTest.jsp"), @Forward(name="error-on-application-submission", path="/publico/candidacy/mobility/errorOnSubmission.jsp"), @Forward(name="bind-link-submited-individual-candidacy-with-stork", path="/publico/candidacy/mobility/bindSubmitedIndividualCandidacyWithStork.jsp"), @Forward(name="show-bind-process-success", path="/publico/candidacy/mobility/showBindProcessSuccess.jsp"), @Forward(name="open-candidacy-process-closed", path="/publico/candidacy/mobility/candidacyProcessClosed.jsp")})
public class ErasmusIndividualCandidacyProcessPublicDA
extends RefactoredIndividualCandidacyProcessPublicDA {
    private static final Logger logger = LoggerFactory.getLogger(ErasmusIndividualCandidacyProcessPublicDA.class);

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setLocale(request, Locale.ENGLISH);
        I18N.setLocale((HttpSession)request.getSession(), (Locale)Locale.ENGLISH);
        return super.execute(mapping, actionForm, request, response);
    }

    @Override
    protected String getCandidacyInformationLinkDefaultLanguage() {
        return this.getStringFromDefaultBundle("link.candidacy.information.default.erasmus");
    }

    @Override
    protected String getCandidacyInformationLinkEnglish() {
        return this.getStringFromDefaultBundle("link.candidacy.information.english.erasmus");
    }

    @Override
    protected String getCandidacyNameKey() {
        return "title.application.name.mobility";
    }

    @Override
    public ActionForward viewCandidacy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        MobilityIndividualApplicationProcess individualCandidacyProcess = (MobilityIndividualApplicationProcess)((Object)request.getAttribute("individualCandidacyProcess"));
        if (individualCandidacyProcess == null) {
            individualCandidacyProcess = (MobilityIndividualApplicationProcess)((Object)this.getProcess(request));
        }
        if (request.getAttribute("individualCandidacyProcessBean") == null) {
            MobilityIndividualApplicationProcessBean bean = new MobilityIndividualApplicationProcessBean(individualCandidacyProcess);
            bean.setPersonBean(new PersonBean(individualCandidacyProcess.getPersonalDetails()));
            request.setAttribute("individualCandidacyProcessBean", (Object)bean);
        }
        return mapping.findForward("show-candidacy-details");
    }

    protected Class getParentProcessType() {
        return MobilityApplicationProcess.class;
    }

    @Override
    protected Class getProcessType() {
        return MobilityIndividualApplicationProcess.class;
    }

    public ActionForward intro(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return new FenixActionForward(request, new ActionForward("http://nmci.ist.utl.pt/en/ist/erasmus/", true));
    }

    public ActionForward chooseSubmissionType(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return new FenixActionForward(request, new ActionForward("http://nmci.ist.utl.pt/en/ist/erasmus/", true));
    }

    public ActionForward prepareCandidacyCreation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        DegreeOfficePublicCandidacyHashCode candidacyHashCode = (DegreeOfficePublicCandidacyHashCode)((Object)PublicCandidacyHashCode.getPublicCandidacyCodeByHash(request.getParameter("hash")));
        if (candidacyHashCode.getIndividualCandidacyProcess() != null) {
            request.setAttribute("individualCandidacyProcess", (Object)candidacyHashCode.getIndividualCandidacyProcess());
            return this.viewCandidacy(mapping, form, request, response);
        }
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        CandidacyProcess candidacyProcess = this.getCurrentOpenParentProcess();
        MobilityIndividualApplicationProcessBean bean = new MobilityIndividualApplicationProcessBean(candidacyProcess);
        bean.setPersonBean(new PersonBean());
        bean.getPersonBean().setIdDocumentType(IDDocumentType.FOREIGNER_IDENTITY_CARD);
        bean.setPublicCandidacyHashCode(candidacyHashCode);
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        bean.getPersonBean().setEmail(candidacyHashCode.getEmail());
        return mapping.findForward("show-candidacy-creation-page");
    }

    @Override
    public ActionForward fillExternalPrecedentInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        return mapping.findForward("candidacy-continue-creation");
    }

    public ActionForward chooseMobilityProgram(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        MobilityIndividualApplicationProcessBean bean = (MobilityIndividualApplicationProcessBean)this.getIndividualCandidacyProcessBean();
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        if (bean.getMobilityStudentDataBean().getDateOfDeparture().isBefore((ReadablePartial)bean.getMobilityStudentDataBean().getDateOfArrival())) {
            this.addActionMessage("error", request, "mobility.error.date.of.departure.before.date.of.arrival");
            return mapping.findForward("candidacy-continue-creation");
        }
        if (!bean.getMobilityStudentDataBean().isSchoolLevelDefined()) {
            this.addActionMessage("error", request, "mobility.error.schoolLevel.not.defined");
            return mapping.findForward("candidacy-continue-creation");
        }
        if (bean.getMobilityStudentDataBean().getApplyFor() != ErasmusApplyForSemesterType.SECOND_SEMESTER && ExecutionYear.readCurrentExecutionYear().getNextExecutionYear() != null && bean.getMobilityStudentDataBean().getDateOfArrival().isAfter((ReadablePartial)ExecutionYear.readCurrentExecutionYear().getNextExecutionYear().getLastExecutionPeriod().getBeginDateYearMonthDay())) {
            this.addActionMessage("error", request, "mobility.error.wrong.period.for.spring.term.applications");
            return mapping.findForward("candidacy-continue-creation");
        }
        return mapping.findForward("choose-mobility-program");
    }

    public ActionForward fillDegreeInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        MobilityIndividualApplicationProcessBean bean = (MobilityIndividualApplicationProcessBean)this.getIndividualCandidacyProcessBean();
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        if (bean.getMobilityStudentDataBean().getSelectedMobilityProgram() == null) {
            this.addActionMessage("error", request, "mobility.error.mobility.cant.be.null");
            return mapping.findForward("choose-mobility-program");
        }
        request.setAttribute("mobilityIndividualApplicationProcessBean", (Object)bean);
        request.setAttribute("degreeCourseInformationBean", (Object)new DegreeCourseInformationBean((ExecutionYear)((Object)this.getCurrentOpenParentProcess().getCandidacyExecutionInterval()), (MobilityApplicationProcess)((Object)bean.getCandidacyProcess())));
        return mapping.findForward("fill-degree-and-courses-information");
    }

    private DegreeCourseInformationBean readDegreeCourseInformationBean(HttpServletRequest request) {
        return (DegreeCourseInformationBean)this.getRenderedObject("degree.course.information.bean");
    }

    private MobilityIndividualApplicationProcessBean readMobilityDegreeInformation(HttpServletRequest request) {
        return (MobilityIndividualApplicationProcessBean)this.getRenderedObject("mobility.individual.application");
    }

    public ActionForward chooseDegree(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        MobilityIndividualApplicationProcessBean bean = this.readMobilityDegreeInformation(request);
        request.setAttribute("mobilityIndividualApplicationProcessBean", (Object)bean);
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        request.setAttribute("degreeCourseInformationBean", (Object)this.readDegreeCourseInformationBean(request));
        RenderUtils.invalidateViewState();
        if ("editCandidacy".equals(request.getParameter("userAction"))) {
            return mapping.findForward("edit-candidacy-degree-and-courses");
        }
        return mapping.findForward("fill-degree-and-courses-information");
    }

    public ActionForward chooseDegreeForMobility(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        MobilityIndividualApplicationProcessBean bean = this.readMobilityDegreeInformation(request);
        request.setAttribute("selectDegreeView", (Object)true);
        request.setAttribute("mobilityIndividualApplicationProcessBean", (Object)bean);
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        request.setAttribute("degreeCourseInformationBean", (Object)this.readDegreeCourseInformationBean(request));
        RenderUtils.invalidateViewState();
        if ("editCandidacy".equals(request.getParameter("userAction"))) {
            return mapping.findForward("edit-candidacy-degree-and-courses");
        }
        return mapping.findForward("fill-degree-and-courses-information");
    }

    public ActionForward addCourse(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        MobilityIndividualApplicationProcessBean bean = (MobilityIndividualApplicationProcessBean)this.getIndividualCandidacyProcessBean();
        DegreeCourseInformationBean degreeCourseBean = this.readDegreeCourseInformationBean(request);
        if (degreeCourseBean.getChosenCourse() != null) {
            bean.addCurricularCourse(degreeCourseBean.getChosenCourse());
        }
        request.setAttribute("degreeCourseInformationBean", (Object)this.readDegreeCourseInformationBean(request));
        request.setAttribute("mobilityIndividualApplicationProcessBean", (Object)bean);
        RenderUtils.invalidateViewState();
        if ("editCandidacy".equals(request.getParameter("userAction"))) {
            return mapping.findForward("edit-candidacy-degree-and-courses");
        }
        return mapping.findForward("fill-degree-and-courses-information");
    }

    public ActionForward removeCourse(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        MobilityIndividualApplicationProcessBean bean = (MobilityIndividualApplicationProcessBean)this.getIndividualCandidacyProcessBean();
        DegreeCourseInformationBean degreeCourseBean = this.readDegreeCourseInformationBean(request);
        CurricularCourse courseToRemove = (CurricularCourse)((Object)this.getDomainObject(request, "removeCourseId"));
        bean.removeCurricularCourse(courseToRemove);
        request.setAttribute("degreeCourseInformationBean", (Object)this.readDegreeCourseInformationBean(request));
        request.setAttribute("mobilityIndividualApplicationProcessBean", (Object)bean);
        RenderUtils.invalidateViewState();
        if ("editCandidacy".equals(request.getParameter("userAction"))) {
            return mapping.findForward("edit-candidacy-degree-and-courses");
        }
        return mapping.findForward("fill-degree-and-courses-information");
    }

    public ActionForward acceptHonourDeclaration(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        MobilityIndividualApplicationProcessBean bean = (MobilityIndividualApplicationProcessBean)this.getIndividualCandidacyProcessBean();
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        try {
            MobilityQuota mobilityQuota = bean.determineMobilityQuota();
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getMessage());
            request.setAttribute("degreeCourseInformationBean", (Object)this.readDegreeCourseInformationBean(request));
            request.setAttribute("mobilityIndividualApplicationProcessBean", (Object)bean);
            RenderUtils.invalidateViewState();
            return mapping.findForward("fill-degree-and-courses-information");
        }
        return mapping.findForward("accept-honour-declaration");
    }

    public ActionForward submitCandidacy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, FenixServiceException {
        try {
            ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
            if (actionForwardError != null) {
                return actionForwardError;
            }
            MobilityIndividualApplicationProcessBean bean = (MobilityIndividualApplicationProcessBean)this.getIndividualCandidacyProcessBean();
            bean.setInternalPersonCandidacy(Boolean.TRUE);
            boolean isValid = this.hasInvalidViewState();
            if (!isValid) {
                this.invalidateDocumentFileRelatedViewStates();
                request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
                return mapping.findForward("accept-honour-declaration");
            }
            if (this.candidacyIndividualProcessExistsForThisEmail(bean.getPersonBean().getEmail())) {
                this.addActionMessage("error", request, "error.candidacy.hash.code.already.bounded");
                this.invalidateDocumentFileRelatedViewStates();
                request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
                return mapping.findForward("candidacy-continue-creation");
            }
            if (!bean.getHonorAgreement().booleanValue()) {
                this.addActionMessage("error", request, "error.must.agree.on.declaration.of.honor");
                this.invalidateDocumentFileRelatedViewStates();
                request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
                return mapping.findForward("accept-honour-declaration");
            }
            if (bean.isToAccessFenix() && bean.getPublicCandidacyHashCode() == null) {
                DegreeOfficePublicCandidacyHashCode candidacyHashCode = null;
                try {
                    candidacyHashCode = DegreeOfficePublicCandidacyHashCodeOperations.getUnusedOrCreateNewHashCodeAndSendEmailForApplicationSubmissionToCandidate(this.getProcessType(), this.getCurrentOpenParentProcess(), bean.getPersonBean().getEmail());
                    bean.setPublicCandidacyHashCode(candidacyHashCode);
                }
                catch (HashCodeForEmailAndProcessAlreadyBounded e) {
                    this.addActionMessage(request, "error.candidacy.hash.code.already.bounded");
                    return mapping.findForward("show-pre-creation-candidacy-form");
                }
            }
            MobilityIndividualApplicationProcess process2 = (MobilityIndividualApplicationProcess)((Object)this.createNewPublicProcess(bean));
            request.setAttribute("process", (Object)process2);
            request.setAttribute("mappingPath", (Object)mapping.getPath());
            request.setAttribute("individualCandidacyProcess", (Object)process2);
            request.setAttribute("endSubmissionDate", (Object)this.getFormattedApplicationSubmissionEndDate());
            return mapping.findForward("inform-submited-candidacy");
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getMessage(), e.getArgs());
            logger.error(e.getMessage(), (Throwable)((Object)e));
            this.getIndividualCandidacyProcessBean().getPersonBean().setPerson(null);
            request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
            this.sendSubmissionErrorReportMail(this.getIndividualCandidacyProcessBean(), e);
            return mapping.findForward("error-on-application-submission");
        }
    }

    public ActionForward editCandidacyProcess(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        MobilityIndividualApplicationProcessBean bean = (MobilityIndividualApplicationProcessBean)this.getIndividualCandidacyProcessBean();
        try {
            ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
            if (actionForwardError != null) {
                return actionForwardError;
            }
            PersonBean personBean = bean.getPersonBean();
            HashSet<Person> persons = new HashSet<Person>(Person.readByDocumentIdNumber(personBean.getDocumentIdNumber()));
            if (persons.size() > 1) {
                this.addActionMessage("individualCandidacyMessages", request, "mobility.error.person.with.same.identifier.exists");
                return this.prepareEditCandidacyProcess(mapping, form, request, response);
            }
            if (persons.size() == 1 && persons.iterator().next() != bean.getIndividualCandidacyProcess().getPersonalDetails().getPerson()) {
                this.addActionMessage("individualCandidacyMessages", request, "mobility.error.person.with.same.identifier.exists");
                return this.prepareEditCandidacyProcess(mapping, form, request, response);
            }
            this.executeActivity((Process)((Object)bean.getIndividualCandidacyProcess()), "EditPublicCandidacyPersonalInformation", this.getIndividualCandidacyProcessBean());
        }
        catch (DomainException e) {
            if (e.getMessage().equals("error.IndividualCandidacyEvent.invalid.payment.code")) {
                throw e;
            }
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
            return mapping.findForward("edit-candidacy");
        }
        request.setAttribute("individualCandidacyProcess", (Object)bean.getIndividualCandidacyProcess());
        return this.backToViewCandidacyInternal(mapping, form, request, response);
    }

    public ActionForward submitWithNationalCitizenCard(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        return mapping.findForward("redirect-to-peps");
    }

    public ActionForward accessApplicationWithNationalCitizenCard(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("redirect-to-peps-to-access-application");
    }

    public ActionForward prepareCandidacyCreationForStork(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        return mapping.findForward("show-candidacy-creation-page");
    }

    public ActionForward prepareEditCandidacyInformation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        return mapping.findForward("edit-candidacy-information");
    }

    @Override
    public ActionForward editCandidacyDocuments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException, IOException {
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        return super.editCandidacyDocuments(mapping, form, request, response);
    }

    @Override
    public ActionForward editCandidacyProcessInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        return super.editCandidacyProcessInvalid(mapping, form, request, response);
    }

    @Override
    public ActionForward prepareEditCandidacyDocuments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        return super.prepareEditCandidacyDocuments(mapping, form, request, response);
    }

    public ActionForward editCandidacyInformationInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        return mapping.findForward("edit-candidacy-information");
    }

    public ActionForward editCandidacyInformation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        MobilityIndividualApplicationProcessBean bean = (MobilityIndividualApplicationProcessBean)this.getIndividualCandidacyProcessBean();
        try {
            ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
            if (actionForwardError != null) {
                return actionForwardError;
            }
            if (bean.getMobilityStudentDataBean().getDateOfDeparture().isBefore((ReadablePartial)bean.getMobilityStudentDataBean().getDateOfArrival())) {
                this.addActionMessage("error", request, "mobility.error.date.of.departure.before.date.of.arrival");
                request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
                return mapping.findForward("edit-candidacy-information");
            }
            this.executeActivity((Process)((Object)bean.getIndividualCandidacyProcess()), "EditPublicCandidacyInformation", this.getIndividualCandidacyProcessBean());
        }
        catch (DomainException e) {
            if (e.getMessage().equals("error.IndividualCandidacyEvent.invalid.payment.code")) {
                throw e;
            }
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
            return mapping.findForward("edit-candidacy-information");
        }
        request.setAttribute("individualCandidacyProcess", (Object)bean.getIndividualCandidacyProcess());
        return this.backToViewCandidacyInternal(mapping, form, request, response);
    }

    public ActionForward prepareEditDegreeAndCourses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        MobilityIndividualApplicationProcessBean bean = (MobilityIndividualApplicationProcessBean)this.getIndividualCandidacyProcessBean();
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        request.setAttribute("degreeCourseInformationBean", (Object)new DegreeCourseInformationBean((ExecutionYear)((Object)this.getCurrentOpenParentProcess().getCandidacyExecutionInterval()), (MobilityApplicationProcess)((Object)this.getIndividualCandidacyProcessBean().getCandidacyProcess())));
        request.setAttribute("mobilityIndividualApplicationProcessBean", (Object)bean);
        return mapping.findForward("edit-candidacy-degree-and-courses");
    }

    public ActionForward prepareEditDegreeAndCoursesInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        return mapping.findForward("edit-candidacy-degree-and-courses");
    }

    public ActionForward editDegreeAndCourses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        MobilityIndividualApplicationProcessBean bean = (MobilityIndividualApplicationProcessBean)this.getIndividualCandidacyProcessBean();
        try {
            ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
            if (actionForwardError != null) {
                return actionForwardError;
            }
            MobilityQuota quota = bean.determineMobilityQuota();
            this.executeActivity((Process)((Object)bean.getIndividualCandidacyProcess()), "EditPublicDegreeAndCoursesInformation", this.getIndividualCandidacyProcessBean());
        }
        catch (DomainException e) {
            request.setAttribute("mobilityIndividualApplicationProcessBean", (Object)bean);
            request.setAttribute("degreeCourseInformationBean", (Object)this.readDegreeCourseInformationBean(request));
            request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
            this.addActionMessage("error", request, e.getMessage());
            RenderUtils.invalidateViewState();
            return mapping.findForward("edit-candidacy-degree-and-courses");
        }
        request.setAttribute("individualCandidacyProcess", (Object)bean.getIndividualCandidacyProcess());
        return this.backToViewCandidacyInternal(mapping, form, request, response);
    }

    private static final String f(String format, Object ... args) {
        return String.format(format, args);
    }

    public ActionForward chooseCountry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        MobilityIndividualApplicationProcessBean bean = (MobilityIndividualApplicationProcessBean)this.getIndividualCandidacyProcessBean();
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        request.setAttribute("degreeCourseInformationBean", (Object)this.readDegreeCourseInformationBean(request));
        RenderUtils.invalidateViewState();
        if ("editCandidacy".equals(request.getParameter("userAction"))) {
            bean.getMobilityStudentDataBean().setSelectedUniversity(null);
            return mapping.findForward("edit-candidacy-degree-and-courses");
        }
        return mapping.findForward("candidacy-continue-creation");
    }

    public ActionForward chooseUniversity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        MobilityIndividualApplicationProcessBean bean = (MobilityIndividualApplicationProcessBean)this.getIndividualCandidacyProcessBean();
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        request.setAttribute("degreeCourseInformationBean", (Object)this.readDegreeCourseInformationBean(request));
        RenderUtils.invalidateViewState();
        return mapping.findForward("edit-candidacy-degree-and-courses");
    }

    public ActionForward retrieveLearningAgreement(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MobilityIndividualApplicationProcess process2 = (MobilityIndividualApplicationProcess)((Object)this.getProcess(request));
        LearningAgreementDocument document = new LearningAgreementDocument(process2);
        byte[] data = ReportsUtils.generateReport(document).getData();
        response.setContentLength(data.length);
        response.setContentType("application/pdf");
        response.addHeader("Content-Disposition", "attachment; filename=" + document.getReportFileName() + ".pdf");
        ServletOutputStream writer = response.getOutputStream();
        writer.write(data);
        writer.flush();
        writer.close();
        response.flushBuffer();
        return mapping.findForward("");
    }

    public ActionForward retrieveApprovedLearningAgreement(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ApprovedLearningAgreementDocumentFile file = (ApprovedLearningAgreementDocumentFile)((Object)this.getDomainObject(request, "agreementId"));
        String hash = request.getParameter("hash");
        MobilityIndividualApplicationProcess process2 = file.getProcess();
        DegreeOfficePublicCandidacyHashCode candidacyHashCode = process2.getCandidacyHashCode();
        if (candidacyHashCode.getValue().equals(hash)) {
            byte[] content = file.getContent();
            response.setContentLength(content.length);
            response.setContentType("application/pdf");
            response.addHeader("Content-Disposition", "attachment; filename=" + file.getFilename());
            ServletOutputStream writer = response.getOutputStream();
            writer.write(content);
            writer.flush();
            writer.close();
            response.flushBuffer();
        }
        return null;
    }

    @Override
    public ActionForward continueCandidacyCreation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        MobilityIndividualApplicationProcessBean bean = (MobilityIndividualApplicationProcessBean)this.getIndividualCandidacyProcessBean();
        PersonBean personBean = bean.getPersonBean();
        if (this.existsIndividualCandidacyProcessForDocumentId(request, personBean.getIdDocumentType(), personBean.getDocumentIdNumber())) {
            this.addActionMessage("individualCandidacyMessages", request, "mobility.error.candidacy.for.person.already.exists");
            return this.executeCreateCandidacyPersonalInformationInvalid(mapping, form, request, response);
        }
        HashSet<Person> persons = new HashSet<Person>(Person.readByDocumentIdNumber(personBean.getDocumentIdNumber()));
        if (persons.size() > 1) {
            this.addActionMessage("individualCandidacyMessages", request, "mobility.error.person.with.same.identifier.exists.multiple");
            return this.executeCreateCandidacyPersonalInformationInvalid(mapping, form, request, response);
        }
        if (persons.size() == 1) {
            Person person = (Person)((Object)persons.iterator().next());
            if (person.getStudent() != null && person.getStudent().hasActiveRegistrations()) {
                this.addActionMessage("individualCandidacyMessages", request, "mobility.error.person.with.same.identifier.exists.active.registration");
                return this.executeCreateCandidacyPersonalInformationInvalid(mapping, form, request, response);
            }
            if (person.getStudent() != null && !person.getStudent().getNumber().toString().equals(bean.getPersonNumber())) {
                this.addActionMessage("individualCandidacyMessages", request, "mobility.error.person.with.same.identifier.exists.different.student", Unit.getInstitutionAcronym());
                return this.executeCreateCandidacyPersonalInformationInvalid(mapping, form, request, response);
            }
            personBean.setPerson(person);
        }
        IndividualCandidacyDocumentFile photoDocumentFile = this.createIndividualCandidacyDocumentFile(bean.getPhotoDocument(), bean.getPersonBean().getDocumentIdNumber());
        bean.getPhotoDocument().setDocumentFile(photoDocumentFile);
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        if (bean.isToAccessFenix() && !personBean.getEmail().equals(personBean.getEmailConfirmation())) {
            this.addActionMessage("individualCandidacyMessages", request, "mobility.error.emails.are.not.equals");
            return this.executeCreateCandidacyPersonalInformationInvalid(mapping, form, request, response);
        }
        if (bean.isToAccessFenix() && bean.getPublicCandidacyHashCode() == null) {
            DegreeOfficePublicCandidacyHashCode candidacyHashCode = null;
            candidacyHashCode = DegreeOfficePublicCandidacyHashCode.getPublicCandidacyHashCodeByEmailAndCandidacyProcessType(bean.getPersonBean().getEmail(), this.getProcessType(), this.getCurrentOpenParentProcess());
            if (candidacyHashCode != null && candidacyHashCode.getIndividualCandidacyProcess() != null) {
                this.addActionMessage("individualCandidacyMessages", request, "mobility.error.email.is.bounded.to.candidacy");
                return this.executeCreateCandidacyPersonalInformationInvalid(mapping, form, request, response);
            }
        }
        return mapping.findForward("candidacy-continue-creation");
    }

    public ActionForward prepareTestStorkAttrString(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("attrStringTestBean", (Object)new StorkAttrStringTestBean());
        return mapping.findForward("stork-attr-list-test");
    }

    public ActionForward prepareBindLinkSubmitedIndividualCandidacyWithStork(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        MobilityIndividualApplicationProcessBean bean = (MobilityIndividualApplicationProcessBean)this.getIndividualCandidacyProcessBean();
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        return mapping.findForward("bind-link-submited-individual-candidacy-with-stork");
    }

    public ActionForward answerNationalIdCardAvoidanceQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        MobilityIndividualApplicationProcessBean bean = (MobilityIndividualApplicationProcessBean)this.getIndividualCandidacyProcessBean();
        try {
            this.executeActivity((Process)((Object)bean.getIndividualCandidacyProcess()), "AnswerNationalIdCardAvoidanceOnSubmissionQuestion", this.getIndividualCandidacyProcessBean());
        }
        catch (DomainException e) {
            request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
            this.addActionMessage("error", request, e.getMessage());
            RenderUtils.invalidateViewState();
            return this.viewCandidacy(mapping, form, request, response);
        }
        return this.viewCandidacy(mapping, form, request, response);
    }

    public ActionForward answerNationalIdCardAvoidanceQuestionInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        MobilityIndividualApplicationProcessBean bean = (MobilityIndividualApplicationProcessBean)this.getIndividualCandidacyProcessBean();
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        return this.viewCandidacy(mapping, form, request, response);
    }

    public ActionForward answerNationalIdCardAvoidanceQuestionPostback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        MobilityIndividualApplicationProcessBean bean = (MobilityIndividualApplicationProcessBean)this.getIndividualCandidacyProcessBean();
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        RenderUtils.invalidateViewState();
        return this.viewCandidacy(mapping, form, request, response);
    }

    private String fillEmptyString(String value) {
        return StringUtils.isEmpty((String)value) ? "\u00ab\u00ab empty \u00bb\u00bb" : value;
    }

    private String reportAppenderAuxString(String field, String value) {
        return field + "........: " + this.fillEmptyString(value) + "\n";
    }

    private String reportAppenderAuxToStringable(String field, Object obj) {
        String value = null;
        if (obj != null) {
            value = obj.toString();
        }
        return this.reportAppenderAuxString(field, value);
    }

    private String reportAppenderAuxEnum(String field, IPresentableEnum obj) {
        String value = null;
        if (obj != null) {
            value = obj.getLocalizedName();
        }
        return this.reportAppenderAuxString(field, value);
    }

    private String reportAppenderAuxDate(String field, Object obj) {
        String DATE_FORMAT_STRING = "dd/MM/yyyy";
        String value = null;
        if (obj != null) {
            if (obj instanceof YearMonthDay) {
                value = ((YearMonthDay)obj).toString("dd/MM/yyyy");
            } else if (obj instanceof LocalDate) {
                value = ((LocalDate)obj).toString("dd/MM/yyyy");
            }
        }
        return this.reportAppenderAuxString(field, value);
    }

    private String reportAppenderAuxCountry(String field, Country obj) {
        String value = null;
        if (obj != null) {
            value = obj.getLocalizedName().getContent();
        }
        return this.reportAppenderAuxString(field, value);
    }

    private String reportAppenderAuxProgram(String field, MobilityProgram obj) {
        String value = null;
        if (obj != null) {
            value = obj.getName().getContent();
        }
        return this.reportAppenderAuxString(field, value);
    }

    private String reportAppenderAuxUnivUnitDegree(String field, Object obj) {
        String value = null;
        if (obj != null) {
            if (obj instanceof UniversityUnit) {
                value = ((UniversityUnit)((Object)obj)).getPresentationName();
            } else if (obj instanceof Degree) {
                value = ((Degree)obj).getPresentationName();
            }
        }
        return this.reportAppenderAuxString(field, value);
    }

    private String reportAppenderAuxCourses(String field, List<CurricularCourse> obj) {
        StringBuilder value = new StringBuilder();
        if (obj != null && !obj.isEmpty()) {
            for (CurricularCourse curricularCourse : obj) {
                value.append("[");
                value.append(curricularCourse.getDegree().getSigla());
                value.append("] ");
                value.append(StringUtils.isEmpty((String)curricularCourse.getNameI18N().getContent()) ? curricularCourse.getName() : curricularCourse.getNameI18N().getContent());
                value.append("; ");
            }
            if (value.length() > 0) {
                value.setLength(value.length() - 2);
            }
        }
        return this.reportAppenderAuxString(field, value.toString());
    }

    private void sendSubmissionErrorReportMail(IndividualCandidacyProcessBean individualCandidacyProcessBean, DomainException exception) {
        StringBuilder sb = new StringBuilder();
        MobilityIndividualApplicationProcessBean mobilityBean = (MobilityIndividualApplicationProcessBean)individualCandidacyProcessBean;
        sb.append(BundleUtil.getString((String)"resources.CandidateResources", (String)"error.mobility.report.mail.intro", (String[])new String[0]));
        sb.append("\n");
        sb.append("\nError message: ");
        sb.append(BundleUtil.getString((String)"resources.ApplicationResources", (String)exception.getKey(), (String[])exception.getArgs()));
        sb.append("\n");
        PersonBean personBean = mobilityBean.getPersonBean();
        sb.append("\nPersonal data entered:\n");
        sb.append(this.reportAppenderAuxString("Name", personBean.getName()));
        sb.append(this.reportAppenderAuxEnum("Gender", personBean.getGender()));
        sb.append(this.reportAppenderAuxDate("Date of Birth", personBean.getDateOfBirth()));
        sb.append(this.reportAppenderAuxString("Documentation Number", personBean.getDocumentIdNumber()));
        sb.append(this.reportAppenderAuxCountry("Nationality", personBean.getNationality()));
        sb.append(this.reportAppenderAuxString("Address", personBean.getAddress()));
        sb.append(this.reportAppenderAuxString("Zip-Code", personBean.getAreaCode()));
        sb.append(this.reportAppenderAuxString("City.", personBean.getArea()));
        sb.append(this.reportAppenderAuxCountry("Country of Residence", personBean.getCountryOfResidence()));
        sb.append(this.reportAppenderAuxString("Phone", personBean.getPhone()));
        sb.append(this.reportAppenderAuxString("Email", personBean.getEmail()));
        sb.append(this.reportAppenderAuxString("Email Confirmation", personBean.getEmailConfirmation()));
        sb.append(this.reportAppenderAuxString("Student Number", mobilityBean.getPersonNumber()));
        MobilityStudentDataBean mobilityStudentDataBean = mobilityBean.getMobilityStudentDataBean();
        sb.append("\nMobility Data Entered:\n");
        sb.append(this.reportAppenderAuxCountry("Selected Country", mobilityStudentDataBean.getSelectedCountry()));
        sb.append(this.reportAppenderAuxUnivUnitDegree("Selected Univ", (Object)mobilityStudentDataBean.getSelectedUniversity()));
        sb.append(this.reportAppenderAuxEnum("School Level", mobilityStudentDataBean.getSchoolLevel()));
        sb.append(this.reportAppenderAuxString("Other School Level", mobilityStudentDataBean.getOtherSchoolLevel()));
        sb.append(this.reportAppenderAuxString("Exchange Coord Name", mobilityStudentDataBean.getHomeInstitutionExchangeCoordinatorName()));
        sb.append(this.reportAppenderAuxToStringable("Has Diploma/Degree", mobilityStudentDataBean.getHasDiplomaOrDegree()));
        sb.append(this.reportAppenderAuxString("Diploma Name", mobilityStudentDataBean.getDiplomaName()));
        sb.append(this.reportAppenderAuxToStringable("Diploma Year", mobilityStudentDataBean.getDiplomaConclusionYear()));
        sb.append(this.reportAppenderAuxToStringable("Experience Research", mobilityStudentDataBean.getExperienceCarryingOutProject()));
        sb.append(this.reportAppenderAuxDate("Date of Arrival", mobilityStudentDataBean.getDateOfArrival()));
        sb.append(this.reportAppenderAuxDate("Date of Departure", mobilityStudentDataBean.getDateOfDeparture()));
        sb.append(this.reportAppenderAuxToStringable("Types of Programme", mobilityStudentDataBean.getTypeOfProgrammeList()));
        sb.append(this.reportAppenderAuxString("Thesis Main Subject", mobilityStudentDataBean.getMainSubjectThesis()));
        sb.append(this.reportAppenderAuxToStringable("Has contacted Staff", mobilityStudentDataBean.getHasContactedOtherStaff()));
        sb.append(this.reportAppenderAuxString("Staff Name", mobilityStudentDataBean.getNameOfContact()));
        sb.append(this.reportAppenderAuxEnum("Applying for period", mobilityStudentDataBean.getApplyFor()));
        sb.append(this.reportAppenderAuxString("Observations", individualCandidacyProcessBean.getObservations()));
        sb.append("\nMobility Program, Degree and Courses:\n");
        sb.append(this.reportAppenderAuxProgram("Selected Program", mobilityStudentDataBean.getSelectedMobilityProgram()));
        sb.append(this.reportAppenderAuxUnivUnitDegree("Chosen Degree", mobilityBean.getDegree()));
        sb.append(this.reportAppenderAuxCourses("Chosen Courses", mobilityBean.getSortedSelectedCurricularCourses()));
        sb.append("\n");
        sb.append(BundleUtil.getString((String)"resources.CandidateResources", (String)"error.mobility.report.mail.stacktrace", (String[])new String[0]));
        sb.append("\n");
        sb.append("\nException key: ");
        sb.append(exception.getKey());
        sb.append("\nException args:");
        if (exception.getArgs().length == 0) {
            sb.append("\u00ab\u00ab no args \u00bb\u00bb");
        } else {
            for (String arg : exception.getArgs()) {
                sb.append(" " + arg + ",");
            }
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("\nException stacktrace:\n");
        sb.append(ExceptionUtils.getStackTrace((Throwable)((Object)exception)));
        sb.append("\n");
        String errorReportAddress = Installation.getInstance().getInstituitionalEmailAddress("nmci");
        String errorReportSubject = BundleUtil.getString((String)"resources.CandidateResources", (String)"error.mobility.report.mail.subject", (String[])new String[]{Unit.getInstitutionAcronym()});
        String errorReportBody = sb.toString();
        SystemSender systemSender = Bennu.getInstance().getSystemSender();
        EmailBean emailBean = new EmailBean();
        emailBean.setSender((Sender)((Object)systemSender));
        emailBean.setReplyTos(systemSender.getConcreteReplyTos());
        emailBean.setRecipients(Collections.emptyList());
        emailBean.setSubject(errorReportSubject);
        emailBean.setMessage(errorReportBody);
        emailBean.setBccs(errorReportAddress);
        emailBean.send();
    }

    public static class StorkAttrStringTestBean
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String attrList;

        public String getAttrList() {
            return this.attrList;
        }

        public void setAttrList(String value) {
            this.attrList = value;
        }
    }
}

