/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.mobility.outbound;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityProgram;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyContest;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyContestGroup;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyPeriod;
import org.fenixedu.academic.domain.organizationalStructure.UniversityUnit;
import org.fenixedu.academic.domain.period.CandidacyPeriod;
import org.fenixedu.academic.ui.struts.action.mobility.outbound.OutboundMobilityContextBean$callable$addMobilityCoordinator;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class OutboundMobilityContextBean
implements Serializable {
    private ExecutionYear executionYear;
    private SortedSet<OutboundMobilityCandidacyPeriod> candidacyPeriods = new TreeSet<OutboundMobilityCandidacyPeriod>();
    private SortedSet<MobilityProgram> mobilityPrograms = new TreeSet<MobilityProgram>();
    private SortedSet<OutboundMobilityCandidacyContestGroup> mobilityGroups = new TreeSet<OutboundMobilityCandidacyContestGroup>();
    private DateTime startDateTime;
    private DateTime endDateTime;
    private MobilityProgram mobilityProgram;
    private ExecutionDegree executionDegree;
    private UniversityUnit unit;
    private Integer vacancies;
    private Person person;
    private transient InputStream stream;
    private long fileSize;
    private String fileName;
    private String optionIntroductoryDestription;
    private String optionValue;
    private Boolean availableForCandidates;
    public static final Advice advice$addMobilityCoordinator = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public OutboundMobilityContextBean() {
        this.setExecutionYear(ExecutionYear.readCurrentExecutionYear());
        OutboundMobilityCandidacyPeriod last = null;
        for (CandidacyPeriod candidacyPeriod : this.executionYear.getCandidacyPeriodsSet()) {
            if (!(candidacyPeriod instanceof OutboundMobilityCandidacyPeriod)) continue;
            OutboundMobilityCandidacyPeriod outboundMobilityCandidacyPeriod = (OutboundMobilityCandidacyPeriod)((Object)candidacyPeriod);
            if (last != null && !last.getStart().isBefore((ReadableInstant)outboundMobilityCandidacyPeriod.getStart())) continue;
            last = outboundMobilityCandidacyPeriod;
        }
        if (last != null) {
            this.candidacyPeriods.add(last);
        }
    }

    public ExecutionYear getExecutionYear() {
        return this.executionYear;
    }

    public void setExecutionYear(ExecutionYear executionYear) {
        if (executionYear != this.executionYear) {
            this.executionYear = executionYear;
            this.candidacyPeriods.clear();
            this.getPossibleCandidacyPeriods(this.candidacyPeriods);
        }
    }

    public void getPossibleCandidacyPeriods(SortedSet<OutboundMobilityCandidacyPeriod> candidacyPeriods) {
        if (this.executionYear != null) {
            for (CandidacyPeriod candidacyPeriod : this.executionYear.getCandidacyPeriodsSet()) {
                if (!(candidacyPeriod instanceof OutboundMobilityCandidacyPeriod)) continue;
                OutboundMobilityCandidacyPeriod outboundMobilityCandidacyPeriod = (OutboundMobilityCandidacyPeriod)((Object)candidacyPeriod);
                candidacyPeriods.add(outboundMobilityCandidacyPeriod);
            }
        }
    }

    public SortedSet<OutboundMobilityCandidacyPeriod> getCandidacyPeriods() {
        return this.candidacyPeriods;
    }

    public List<OutboundMobilityCandidacyPeriod> getCandidacyPeriodsAsList() {
        return new ArrayList<OutboundMobilityCandidacyPeriod>(this.candidacyPeriods);
    }

    public void setCandidacyPeriodsAsList(List<OutboundMobilityCandidacyPeriod> candidacyPeriodsAsList) {
        this.candidacyPeriods.retainAll(candidacyPeriodsAsList);
        this.candidacyPeriods.addAll(candidacyPeriodsAsList);
    }

    public SortedSet<OutboundMobilityCandidacyContestGroup> getMobilityGroups() {
        return this.mobilityGroups;
    }

    public List<OutboundMobilityCandidacyContestGroup> getMobilityGroupsAsList() {
        return new ArrayList<OutboundMobilityCandidacyContestGroup>(this.mobilityGroups);
    }

    public void setMobilityGroupsAsList(List<OutboundMobilityCandidacyContestGroup> mobilityGroupsAsList) {
        this.mobilityGroups.retainAll(mobilityGroupsAsList);
        this.mobilityGroups.addAll(mobilityGroupsAsList);
    }

    public SortedSet<MobilityProgram> getMobilityPrograms() {
        return this.mobilityPrograms;
    }

    public List<MobilityProgram> getMobilityProgramsAsList() {
        return new ArrayList<MobilityProgram>(this.mobilityPrograms);
    }

    public void setMobilityProgramsAsList(List<MobilityProgram> mobilityProgramsAsList) {
        this.mobilityPrograms.retainAll(mobilityProgramsAsList);
        this.mobilityPrograms.addAll(mobilityProgramsAsList);
    }

    public DateTime getStartDateTime() {
        return this.startDateTime;
    }

    public void setStartDateTime(DateTime startDateTime) {
        this.startDateTime = startDateTime;
    }

    public DateTime getEndDateTime() {
        return this.endDateTime;
    }

    public void setEndDateTime(DateTime endDateTime) {
        this.endDateTime = endDateTime;
    }

    public void createNewOutboundMobilityCandidacyPeriod() {
        OutboundMobilityCandidacyPeriod candidacyPeriod = OutboundMobilityCandidacyPeriod.create((ExecutionInterval)((Object)this.getExecutionYear()), this.getStartDateTime(), this.getEndDateTime());
        this.candidacyPeriods.add(candidacyPeriod);
    }

    public void createNewOutboundMobilityCandidacyContest() {
        for (OutboundMobilityCandidacyPeriod candidacyPeriod : this.candidacyPeriods) {
            if (this.executionDegree == null) {
                for (OutboundMobilityCandidacyContestGroup mobilityGroup : this.mobilityGroups) {
                    candidacyPeriod.createOutboundMobilityCandidacyContest(mobilityGroup, this.mobilityProgram, this.unit, this.vacancies);
                }
                continue;
            }
            candidacyPeriod.createOutboundMobilityCandidacyContest(this.executionDegree, this.mobilityProgram, this.unit, this.vacancies);
        }
        this.executionDegree = null;
        this.unit = null;
        this.vacancies = null;
    }

    public ExecutionDegree getExecutionDegree() {
        return this.executionDegree;
    }

    public void setExecutionDegree(ExecutionDegree executionDegree) {
        this.executionDegree = executionDegree;
    }

    public UniversityUnit getUnit() {
        return this.unit;
    }

    public void setUnit(UniversityUnit unit) {
        this.unit = unit;
    }

    public Integer getVacancies() {
        return this.vacancies;
    }

    public void setVacancies(Integer vacancies) {
        this.vacancies = vacancies;
    }

    public MobilityProgram getMobilityProgram() {
        return this.mobilityProgram;
    }

    public void setMobilityProgram(MobilityProgram mobilityProgram) {
        this.mobilityProgram = mobilityProgram;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public SortedSet<OutboundMobilityCandidacyContest> getOutboundMobilityCandidacyContest() {
        TreeSet<OutboundMobilityCandidacyContest> result = new TreeSet<OutboundMobilityCandidacyContest>();
        for (OutboundMobilityCandidacyPeriod candidacyPeriod : this.candidacyPeriods) {
            for (OutboundMobilityCandidacyContest contest : candidacyPeriod.getOutboundMobilityCandidacyContestSet()) {
                OutboundMobilityCandidacyContestGroup mobilityGroup;
                if (!this.mobilityPrograms.contains(contest.getMobilityAgreement().getMobilityProgram()) || !this.mobilityGroups.contains(mobilityGroup = contest.getOutboundMobilityCandidacyContestGroup())) continue;
                result.add(contest);
            }
        }
        return result;
    }

    public void addDegreeToGroup() {
        for (OutboundMobilityCandidacyContestGroup mobilityGroup : this.mobilityGroups) {
            mobilityGroup.addExecutionDegreeService(this.executionDegree);
        }
    }

    public void removeDegreeFromGroup() {
        for (OutboundMobilityCandidacyContestGroup mobilityGroup : this.mobilityGroups) {
            mobilityGroup.removeExecutionDegreeService(this.executionDegree);
        }
    }

    public void addMobilityCoordinator() {
        Object object = advice$addMobilityCoordinator.perform((Callable)new OutboundMobilityContextBean$callable$addMobilityCoordinator(this));
    }

    static /* synthetic */ void advised$addMobilityCoordinator(OutboundMobilityContextBean this_) {
        if (this_.person != null) {
            for (OutboundMobilityCandidacyContestGroup mobilityGroup : this_.mobilityGroups) {
                mobilityGroup.addMobilityCoordinatorService(this_.person);
            }
            this_.addOperationPermissions(this_.person);
        }
    }

    private void addOperationPermissions(Person person) {
        AcademicOperationType.VALIDATE_MOBILITY_OUTBOUND_CANDIDACIES.grant(person.getUser());
    }

    public InputStream getStream() {
        return this.stream;
    }

    public void setStream(InputStream stream) {
        this.stream = stream;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getOptionIntroductoryDestription() {
        return this.optionIntroductoryDestription;
    }

    public void setOptionIntroductoryDestription(String optionIntroductoryDestription) {
        this.optionIntroductoryDestription = optionIntroductoryDestription;
    }

    public String getOptionValue() {
        return this.optionValue;
    }

    public void setOptionValue(String optionValue) {
        this.optionValue = optionValue;
    }

    public Boolean getAvailableForCandidates() {
        return this.availableForCandidates;
    }

    public void setAvailableForCandidates(Boolean availableForCandidates) {
        this.availableForCandidates = availableForCandidates;
    }

    protected String readStreamContents() throws IOException {
        try (InputStream stream = this.getStream();){
            if (stream == null || this.getFileSize() == 0L) {
                String string = null;
                return string;
            }
            String string = new String(ByteStreams.toByteArray((InputStream)stream), StandardCharsets.UTF_8);
            return string;
        }
    }

    public void uploadClassifications() throws IOException {
        String contents = this.readStreamContents();
        if (contents != null) {
            for (OutboundMobilityCandidacyContestGroup group : this.mobilityGroups) {
                for (OutboundMobilityCandidacyPeriod candidacyPeriod : this.candidacyPeriods) {
                    group.setGrades(candidacyPeriod, contents);
                }
            }
        } else {
            throw new DomainException("error.mobility.outbound.unable.to.set.grades", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"error.mobility.outbound.null.file", (String[])new String[0]));
        }
    }

    public void addCandidateOption() {
        for (OutboundMobilityCandidacyPeriod period : this.candidacyPeriods) {
            if (this.optionIntroductoryDestription != null && !this.optionIntroductoryDestription.isEmpty()) {
                period.setOptionIntroductoryDestriptionService(this.optionIntroductoryDestription);
            }
            if (this.optionValue == null || this.optionValue.isEmpty()) continue;
            period.addOption(this.optionValue, this.availableForCandidates);
        }
    }
}

