/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.manager.enrolments;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.EnrolmentPeriod;
import org.fenixedu.academic.domain.EnrolmentPeriodInCurricularCourses;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.log.CurriculumLineLog;
import org.fenixedu.academic.domain.log.EnrolmentLog;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.dto.curriculumLineLog.SearchCurriculumLineLog;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.manager.ManagerApplications;
import org.fenixedu.academic.util.EnrolmentAction;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

@StrutsFunctionality(app=ManagerApplications.ManagerStudentsApp.class, path="curriculum-logs", titleKey="title.curriculum.line.logs")
@Mapping(path="/curriculumLineLogs", module="manager")
@Forwards(value={@Forward(name="searchCurriculumLineLogs", path="/manager/viewCurriculumLineLogs.jsp"), @Forward(name="viewCurriculumLineLogStatistics", path="/manager/viewCurriculumLineLogStatistics.jsp")})
public class CurriculumLineLogsDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward prepareViewCurriculumLineLogs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("bean", (Object)new SearchCurriculumLineLog());
        return mapping.findForward("searchCurriculumLineLogs");
    }

    public ActionForward viewCurriculumLineLogs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SearchCurriculumLineLog searchCurriculumLineLog = (SearchCurriculumLineLog)this.getRenderedObject();
        request.setAttribute("bean", (Object)searchCurriculumLineLog);
        Student student = Student.readStudentByNumber(searchCurriculumLineLog.getStudentNumber());
        if (student == null) {
            this.addActionMessage(request, "exception.student.does.not.exist");
            return mapping.findForward("searchCurriculumLineLogs");
        }
        request.setAttribute("curriculumLineLogs", student.getCurriculumLineLogs(searchCurriculumLineLog.getExecutionPeriod()));
        return mapping.findForward("searchCurriculumLineLogs");
    }

    public ActionForward viewCurriculumLineLogStatistics(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ExecutionSemester executionSemester = (ExecutionSemester)this.getDomainObject(request, "executionSemesterId");
        if (executionSemester != null) {
            request.setAttribute("executionSemester", (Object)executionSemester);
            CurriculumLineLogStatisticsCalculator curriculumLineLogStatisticsCalculator = new CurriculumLineLogStatisticsCalculator(executionSemester);
            request.setAttribute("curriculumLineLogStatisticsCalculator", (Object)curriculumLineLogStatisticsCalculator);
            return mapping.findForward("viewCurriculumLineLogStatistics");
        }
        return this.prepareViewCurriculumLineLogs(mapping, form, request, response);
    }

    public static class CurriculumLineLogStatisticsCalculator {
        private static final int INTERVAL_SIZE_IN_MILLIS = 300000;
        final Interval enrolmentPeriod;
        final int[] enrolments;
        final int[] unenrolments;

        public CurriculumLineLogStatisticsCalculator(ExecutionSemester executionSemester) {
            this.enrolmentPeriod = this.findEnrolmentPeriod(executionSemester);
            long start = this.enrolmentPeriod.getStart().getMillis();
            long durationMillis = this.enrolmentPeriod.toDurationMillis();
            int numberOfIntervals = (int)(durationMillis / 300000L) + 1;
            this.enrolments = new int[numberOfIntervals];
            this.unenrolments = new int[numberOfIntervals];
            for (CurriculumLineLog curriculumLineLog : executionSemester.getCurriculumLineLogsSet()) {
                DateTime dateTime;
                if (!(curriculumLineLog instanceof EnrolmentLog) || !this.enrolmentPeriod.contains((ReadableInstant)(dateTime = curriculumLineLog.getDateDateTime()))) continue;
                long offset = dateTime.getMillis() - start;
                int i = (int)offset / 300000;
                if (curriculumLineLog.getAction() == EnrolmentAction.ENROL) {
                    int n = i;
                    this.enrolments[n] = this.enrolments[n] + 1;
                    continue;
                }
                int n = i;
                this.unenrolments[n] = this.unenrolments[n] + 1;
            }
        }

        public Interval getEnrolmentPeriod() {
            return this.enrolmentPeriod;
        }

        public int[] getEnrolments() {
            return this.enrolments;
        }

        public int[] getUnenrolments() {
            return this.unenrolments;
        }

        private Interval findEnrolmentPeriod(ExecutionSemester executionSemester) {
            DateTime start = null;
            DateTime end = null;
            for (EnrolmentPeriod enrolmentPeriod : executionSemester.getEnrolmentPeriodSet()) {
                DegreeType degreeType;
                if (!(enrolmentPeriod instanceof EnrolmentPeriodInCurricularCourses) || !(degreeType = enrolmentPeriod.getDegreeCurricularPlan().getDegreeType()).isBolonhaDegree() && !degreeType.isIntegratedMasterDegree()) continue;
                if (start == null || start.isAfter((ReadableInstant)enrolmentPeriod.getStartDateDateTime())) {
                    start = enrolmentPeriod.getStartDateDateTime();
                }
                if (end != null && !end.isBefore((ReadableInstant)enrolmentPeriod.getEndDateDateTime())) continue;
                end = enrolmentPeriod.getEndDateDateTime();
            }
            return start == null || end == null ? null : new Interval(start, end);
        }
    }
}

