/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.manager.curricularCourses;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.degreeStructure.RootCourseGroup;
import org.fenixedu.academic.util.MultiLanguageString;

public class SearchCurricularCourseBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final DegreeCurricularPlan degreeCurricularPlan;
    private ExecutionYear beginExecutionYear;
    private ExecutionYear endExecutionYear;
    private String name;

    public SearchCurricularCourseBean(DegreeCurricularPlan degreeCurricularPlan) {
        this.degreeCurricularPlan = degreeCurricularPlan;
    }

    public Set<Context> search() {
        HashSet<Context> result = new HashSet<Context>();
        RootCourseGroup root = this.getDegreeCurricularPlan().getRoot();
        this.searchRecursive((CourseGroup)((Object)root), result);
        return result;
    }

    private void searchRecursive(CourseGroup courseGroup, Set<Context> result) {
        Set childContexts = courseGroup.getChildContextsSet();
        for (Context context : childContexts) {
            DegreeModule childDegreeModule = context.getChildDegreeModule();
            if (childDegreeModule.isCourseGroup()) {
                this.searchRecursive((CourseGroup)((Object)childDegreeModule), result);
                continue;
            }
            if (this.getBeginExecutionYear() != null && context.getBeginExecutionPeriod().getExecutionYear().isBefore(this.getBeginExecutionYear()) || this.getEndExecutionYear() != null && context.getEndExecutionPeriod().getExecutionYear().isAfter(this.getEndExecutionYear())) continue;
            MultiLanguageString nameI18N = childDegreeModule.getNameI18N();
            Collection<String> allContents = nameI18N.getAllContents();
            Pattern searchPattern = this.getSearchRegex();
            for (String degreeModuleName : allContents) {
                if (!searchPattern.matcher(degreeModuleName).matches()) continue;
                result.add(context);
            }
        }
    }

    public DegreeCurricularPlan getDegreeCurricularPlan() {
        return this.degreeCurricularPlan;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Pattern getSearchRegex() {
        String[] split = this.getName().split("\\s+");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            String compound = split[i];
            sb.append("(.*").append(compound).append(".*)");
            if (i >= split.length - 1) continue;
            sb.append("(\\s+)");
        }
        Pattern searchPattern = Pattern.compile(sb.toString());
        return searchPattern;
    }

    public ExecutionYear getBeginExecutionYear() {
        return this.beginExecutionYear;
    }

    public void setBeginExecutionYear(ExecutionYear beginExecutionYear) {
        this.beginExecutionYear = beginExecutionYear;
    }

    public ExecutionYear getEndExecutionYear() {
        return this.endExecutionYear;
    }

    public void setEndExecutionYear(ExecutionYear endExecutionYear) {
        this.endExecutionYear = endExecutionYear;
    }
}

