/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.internationalRelatOffice.candidacy.erasmus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessDocumentUploadBean;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFile;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ApprovedLearningAgreementDocumentFile;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ErasmusAlert;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityIndividualApplication;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityIndividualApplicationProcess;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityIndividualApplicationProcessBean;
import org.fenixedu.academic.domain.caseHandling.Activity;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleLevel;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.EnrollmentDomainException;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.NoCourseGroupCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.NoCourseGroupCurriculumGroupType;
import org.fenixedu.academic.dto.administrativeOffice.studentEnrolment.MobilityExtraEnrolmentBean;
import org.fenixedu.academic.dto.person.PersonBean;
import org.fenixedu.academic.dto.student.enrollment.bolonha.BolonhaStudentEnrollmentBean;
import org.fenixedu.academic.dto.student.enrollment.bolonha.CycleEnrolmentBean;
import org.fenixedu.academic.dto.student.enrollment.bolonha.ErasmusBolonhaStudentEnrollmentBean;
import org.fenixedu.academic.predicate.IllegalDataAccessException;
import org.fenixedu.academic.report.candidacy.erasmus.LearningAgreementDocument;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.student.administrativeOfficeServices.CreateExtraEnrolment;
import org.fenixedu.academic.service.services.student.enrolment.bolonha.EnrolBolonhaStudent;
import org.fenixedu.academic.service.services.student.enrolment.bolonha.EnrolInAffinityCycle;
import org.fenixedu.academic.ui.struts.FenixActionForm;
import org.fenixedu.academic.ui.struts.action.internationalRelatOffice.candidacy.erasmus.ErasmusCandidacyProcessDA;
import org.fenixedu.academic.util.report.ReportsUtils;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.joda.time.YearMonthDay;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@Mapping(path="/caseHandlingMobilityIndividualApplicationProcess", module="internationalRelatOffice", formBeanClass=FenixActionForm.class, functionality=ErasmusCandidacyProcessDA.class)
@Forwards(value={@Forward(name="intro", path="/internationalRelatOffice/caseHandlingMobilityApplicationProcess.do?method=listProcessAllowedActivities"), @Forward(name="list-allowed-activities", path="/candidacy/erasmus/listIndividualCandidacyActivities.jsp"), @Forward(name="prepare-create-new-process", path="/candidacy/erasmus/selectPersonForCandidacy.jsp"), @Forward(name="fill-personal-information", path="/candidacy/erasmus/fillPersonalInformation.jsp"), @Forward(name="fill-candidacy-information", path="/candidacy/erasmus/fillCandidacyInformation.jsp"), @Forward(name="fill-degree-information", path="/candidacy/erasmus/fillDegreeInformation.jsp"), @Forward(name="fill-courses-information", path="/candidacy/erasmus/fillCoursesInformation.jsp"), @Forward(name="edit-candidacy-personal-information", path="/candidacy/erasmus/editPersonalInformation.jsp"), @Forward(name="edit-candidacy-information", path="/candidacy/erasmus/editCandidacyInformation.jsp"), @Forward(name="edit-degree-courses-information", path="/candidacy/erasmus/editDegreeAndCoursesInformation.jsp"), @Forward(name="set-gri-validation", path="/internationalRelatOffice/candidacy/erasmus/setGriValidation.jsp"), @Forward(name="visualize-alerts", path="/candidacy/erasmus/visualizeAlerts.jsp"), @Forward(name="prepare-edit-candidacy-documents", path="/candidacy/erasmus/editCandidacyDocuments.jsp"), @Forward(name="create-student-data", path="/candidacy/erasmus/createStudentData.jsp"), @Forward(name="view-student-data-username", path="/candidacy/erasmus/viewStudentDataUsername.jsp"), @Forward(name="edit-eidentifier", path="/candidacy/erasmus/editEidentifier.jsp"), @Forward(name="cancel-candidacy", path="/candidacy/cancelCandidacy.jsp"), @Forward(name="view-approved-learning-agreements", path="/candidacy/erasmus/viewApprovedLearningAgreements.jsp"), @Forward(name="upload-learning-agreement", path="/candidacy/erasmus/uploadLearningAgreement.jsp"), @Forward(name="reject-candidacy", path="/candidacy/rejectCandidacy.jsp"), @Forward(name="revert-candidacy-to-standby", path="/candidacy/erasmus/revertCandidacyToStandby.jsp"), @Forward(name="enrol-student", path="/candidacy/erasmus/enrolStudent.jsp"), @Forward(name="chooseCycleCourseGroupToEnrol", path="/candidacy/erasmus/chooseCycleCourseGroupToEnrol.jsp")})
public class ErasmusIndividualCandidacyProcessDA
extends org.fenixedu.academic.ui.struts.action.candidacy.erasmus.ErasmusIndividualCandidacyProcessDA {
    @Override
    protected List<Activity> getAllowedActivities(IndividualCandidacyProcess process2) {
        List activities = process2.getAllowedActivities(Authenticate.getUser());
        ArrayList<Activity> resultActivities = new ArrayList<Activity>();
        for (Activity activity : activities) {
            if (!activity.isVisibleForGriOffice().booleanValue()) continue;
            resultActivities.add(activity);
        }
        return resultActivities;
    }

    public ActionForward prepareExecuteSetGriValidation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        MobilityIndividualApplicationProcessBean bean = new MobilityIndividualApplicationProcessBean(this.getProcess(request));
        bean.setCreateAlert(true);
        bean.setSendEmail(true);
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        return mapping.findForward("set-gri-validation");
    }

    public ActionForward executeSetGriValidation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            MobilityIndividualApplicationProcessBean bean = this.getIndividualCandidacyProcessBean();
            if (!bean.getCreateAlert().booleanValue() || !StringUtils.isEmpty((String)bean.getAlertSubject()) && !StringUtils.isEmpty((String)bean.getAlertBody())) {
                this.executeActivity((Process)((Object)this.getProcess(request)), "SetGriValidation", this.getIndividualCandidacyProcessBean());
                return this.listProcessAllowedActivities(mapping, actionForm, request, response);
            }
            this.addActionMessage(request, "error.erasmus.alert.subject.and.body.must.not.be.empty");
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
        }
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        return mapping.findForward("set-gri-validation");
    }

    public ActionForward executeSetGriValidationInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        return mapping.findForward("set-gri-validation");
    }

    public ActionForward prepareExecuteCreateStudentData(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        MobilityIndividualApplicationProcessBean bean = new MobilityIndividualApplicationProcessBean(this.getProcess(request));
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        return mapping.findForward("create-student-data");
    }

    public ActionForward prepareExecuteCreateStudentDataInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        return mapping.findForward("create-student-data");
    }

    public ActionForward executeCreateStudentData(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        try {
            this.executeActivity((Process)((Object)this.getProcess(request)), "CreateStudentData", this.getIndividualCandidacyProcessBean());
            this.executeActivity((Process)((Object)this.getProcess(request)), "ImportToLDAP", this.getIndividualCandidacyProcessBean());
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
            return mapping.findForward("create-student-data");
        }
        return mapping.findForward("view-student-data-username");
    }

    public ActionForward prepareExecuteSetEIdentifierForTesting(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        MobilityIndividualApplicationProcessBean bean = new MobilityIndividualApplicationProcessBean(this.getProcess(request));
        bean.setPersonBean(new PersonBean(this.getProcess(request).getPersonalDetails()));
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        return mapping.findForward("edit-eidentifier");
    }

    public ActionForward prepareExecuteSetEIdentifierForTestingInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        MobilityIndividualApplicationProcessBean bean = new MobilityIndividualApplicationProcessBean(this.getProcess(request));
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        return mapping.findForward("edit-eidentifier");
    }

    public ActionForward executeSetEIdentifierForTesting(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        MobilityIndividualApplicationProcessBean bean = new MobilityIndividualApplicationProcessBean(this.getProcess(request));
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        try {
            this.executeActivity((Process)((Object)this.getProcess(request)), "SetEIdentifierForTesting", this.getIndividualCandidacyProcessBean());
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
            return mapping.findForward("edit-eidentifier");
        }
        return this.listProcessAllowedActivities(mapping, actionForm, request, response);
    }

    public ActionForward prepareExecuteViewApprovedLearningAgreements(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        MobilityIndividualApplicationProcessBean bean = new MobilityIndividualApplicationProcessBean(this.getProcess(request));
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        return mapping.findForward("view-approved-learning-agreements");
    }

    public ActionForward markApprovedLearningAgreementAsViewed(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ApprovedLearningAgreementDocumentFile file = (ApprovedLearningAgreementDocumentFile)FenixFramework.getDomainObject((String)request.getParameter("approvedLearningAgreementId"));
        file.markLearningAgreementViewed();
        return this.prepareExecuteViewApprovedLearningAgreements(mapping, actionForm, request, response);
    }

    public ActionForward markApprovedLearningAgreementAsSent(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ApprovedLearningAgreementDocumentFile file = (ApprovedLearningAgreementDocumentFile)FenixFramework.getDomainObject((String)request.getParameter("approvedLearningAgreementId"));
        file.markLearningAgreementSent();
        return this.prepareExecuteViewApprovedLearningAgreements(mapping, actionForm, request, response);
    }

    public ActionForward markAlertAsViewed(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        ErasmusAlert alert = (ErasmusAlert)FenixFramework.getDomainObject((String)request.getParameter("erasmusAlertId"));
        this.executeActivity((Process)((Object)this.getProcess(request)), "MarkAlertAsViewed", (Object)alert);
        return this.prepareExecuteVisualizeAlerts(mapping, actionForm, request, response);
    }

    public ActionForward sendEmailToAcceptedStudent(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        ApprovedLearningAgreementDocumentFile file = (ApprovedLearningAgreementDocumentFile)FenixFramework.getDomainObject((String)request.getParameter("approvedLearningAgreementId"));
        this.executeActivity((Process)((Object)this.getProcess(request)), "SendEmailToAcceptedStudent", null);
        return this.prepareExecuteViewApprovedLearningAgreements(mapping, actionForm, request, response);
    }

    public ActionForward retrieveLearningAgreement(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MobilityIndividualApplicationProcess process2 = this.getProcess(request);
        LearningAgreementDocument document = new LearningAgreementDocument(process2);
        byte[] data = ReportsUtils.generateReport(document).getData();
        response.setContentLength(data.length);
        response.setContentType("application/pdf");
        response.addHeader("Content-Disposition", "attachment; filename=" + document.getReportFileName() + ".pdf");
        ServletOutputStream writer = response.getOutputStream();
        writer.write(data);
        writer.flush();
        writer.close();
        response.flushBuffer();
        return mapping.findForward("");
    }

    public ActionForward revokeApprovedLearningAgreement(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        ApprovedLearningAgreementDocumentFile file = (ApprovedLearningAgreementDocumentFile)FenixFramework.getDomainObject((String)request.getParameter("approvedLearningAgreementId"));
        CandidacyProcessDocumentUploadBean documentBean = new CandidacyProcessDocumentUploadBean();
        documentBean.setDocumentFile((IndividualCandidacyDocumentFile)((Object)file));
        this.executeActivity((Process)((Object)this.getProcess(request)), "RevokeDocumentFile", documentBean);
        return this.prepareExecuteViewApprovedLearningAgreements(mapping, form, request, response);
    }

    public ActionForward prepareExecuteRevertCandidacyToStandBy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        return mapping.findForward("revert-candidacy-to-standby");
    }

    public ActionForward executeRevertCandidacyToStandBy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            this.executeActivity((Process)((Object)this.getProcess(request)), "RevertCandidacyToStandBy", null);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            return mapping.findForward("revert-candidacy-to-standby");
        }
        return this.listProcessAllowedActivities(mapping, form, request, response);
    }

    public ActionForward enrolStudent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        ErasmusBolonhaStudentEnrollmentBean bean;
        MobilityIndividualApplicationProcess process2 = this.getProcess(request);
        MobilityIndividualApplication candidacy = process2.getCandidacy();
        if (candidacy.getRegistration().getActiveStudentCurricularPlan() != null) {
            Boolean restrictEnrollment = true;
            ExecutionSemester semester = ExecutionSemester.readByYearMonthDay(new YearMonthDay());
            bean = new ErasmusBolonhaStudentEnrollmentBean(candidacy.getRegistration().getActiveStudentCurricularPlan(), semester, null, CurricularRuleLevel.ENROLMENT_NO_RULES, candidacy);
        } else {
            Boolean restrictEnrollment = false;
            bean = null;
        }
        return this.enrolStudent(mapping, request, process2, bean);
    }

    private ActionForward enrolStudent(ActionMapping mapping, HttpServletRequest request, MobilityIndividualApplicationProcess process2, ErasmusBolonhaStudentEnrollmentBean bean) {
        MobilityIndividualApplication candidacy = process2.getCandidacy();
        Boolean restrictEnrollment = candidacy.getRegistration().getActiveStudentCurricularPlan() != null ? Boolean.valueOf(true) : Boolean.valueOf(false);
        request.setAttribute("process", (Object)process2);
        request.setAttribute("restrictEnrollment", (Object)restrictEnrollment);
        request.setAttribute("bolonhaStudentEnrollmentBean", (Object)bean);
        request.setAttribute("action", (Object)"/caseHandlingMobilityIndividualApplicationProcess.do");
        return mapping.findForward("enrol-student");
    }

    public ActionForward postBack(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        MobilityIndividualApplicationProcess process2 = this.getProcess(request);
        MobilityIndividualApplication candidacy = process2.getCandidacy();
        ExecutionSemester semester = ((ErasmusBolonhaStudentEnrollmentBean)this.getRenderedObject()).getExecutionPeriod();
        RenderUtils.invalidateViewState();
        ErasmusBolonhaStudentEnrollmentBean bean = new ErasmusBolonhaStudentEnrollmentBean(candidacy.getRegistration().getActiveStudentCurricularPlan(), semester, null, CurricularRuleLevel.ENROLMENT_NO_RULES, candidacy);
        return this.enrolStudent(mapping, request, process2, bean);
    }

    public ActionForward doEnrol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        ErasmusBolonhaStudentEnrollmentBean erasmusBolonhaStudentEnrollmentBean = (ErasmusBolonhaStudentEnrollmentBean)this.getRenderedObject();
        try {
            RuleResult ruleResults = EnrolBolonhaStudent.run(erasmusBolonhaStudentEnrollmentBean.getStudentCurricularPlan(), erasmusBolonhaStudentEnrollmentBean.getExecutionPeriod(), erasmusBolonhaStudentEnrollmentBean.getDegreeModulesToEvaluate(), erasmusBolonhaStudentEnrollmentBean.getCurriculumModulesToRemove(), erasmusBolonhaStudentEnrollmentBean.getCurricularRuleLevel());
            if (!erasmusBolonhaStudentEnrollmentBean.getDegreeModulesToEvaluate().isEmpty() || !erasmusBolonhaStudentEnrollmentBean.getCurriculumModulesToRemove().isEmpty()) {
                this.addActionMessage("success", request, "label.save.success");
            }
            if (ruleResults.isWarning()) {
                this.addRuleResultMessagesToActionMessages("warning", request, ruleResults);
            }
        }
        catch (EnrollmentDomainException ex) {
            this.addRuleResultMessagesToActionMessages("error", request, ex.getFalseResult());
            return this.enrolStudent(mapping, form, request, response);
        }
        catch (DomainException ex) {
            this.addActionMessage("error", request, ex.getKey(), ex.getArgs());
            return this.enrolStudent(mapping, form, request, response);
        }
        StudentCurricularPlan studentCurricularPlan = erasmusBolonhaStudentEnrollmentBean.getStudentCurricularPlan();
        ExecutionSemester executionSemester = erasmusBolonhaStudentEnrollmentBean.getExecutionPeriod();
        NoCourseGroupCurriculumGroup group = studentCurricularPlan.getNoCourseGroupCurriculumGroup(NoCourseGroupCurriculumGroupType.STANDALONE);
        HashSet remaining = new HashSet();
        HashSet<CurricularCourse> set = new HashSet<CurricularCourse>();
        set.addAll(erasmusBolonhaStudentEnrollmentBean.getCandidacy().getCurricularCoursesSet());
        for (Enrolment enrolment : group.getEnrolments()) {
            set.add(enrolment.getCurricularCourse());
        }
        remaining.addAll(set);
        for (ErasmusBolonhaStudentEnrollmentBean.ErasmusExtraCurricularEnrolmentBean bean : erasmusBolonhaStudentEnrollmentBean.getExtraCurricularEnrolments()) {
            remaining.remove((Object)bean.getCurricularCourse());
            if (group.hasEnrolmentWithEnroledState(bean.getCurricularCourse(), erasmusBolonhaStudentEnrollmentBean.getExecutionPeriod())) continue;
            MobilityExtraEnrolmentBean mobilityExtraEnrolmentBean = new MobilityExtraEnrolmentBean(studentCurricularPlan, executionSemester);
            mobilityExtraEnrolmentBean.setCurriculumGroup((CurriculumGroup)((Object)studentCurricularPlan.getNoCourseGroupCurriculumGroup(NoCourseGroupCurriculumGroupType.STANDALONE)));
            mobilityExtraEnrolmentBean.setDegree(bean.getCurricularCourse().getDegree());
            mobilityExtraEnrolmentBean.setDegreeType(bean.getCurricularCourse().getDegree().getDegreeType());
            mobilityExtraEnrolmentBean.setDegreeCurricularPlan(bean.getCurricularCourse().getDegreeCurricularPlan());
            mobilityExtraEnrolmentBean.setSelectedCurricularCourse(bean.getCurricularCourse());
            mobilityExtraEnrolmentBean.setCurricularRuleLevel(CurricularRuleLevel.EXTRA_ENROLMENT);
            try {
                RuleResult ruleResult = CreateExtraEnrolment.run(mobilityExtraEnrolmentBean);
                if (!ruleResult.isWarning()) continue;
                this.addRuleResultMessagesToActionMessages("warning", request, ruleResult);
            }
            catch (IllegalDataAccessException e) {
                this.addActionMessage("error", request, "error.notAuthorized");
                return this.enrolStudent(mapping, form, request, response);
            }
            catch (EnrollmentDomainException ex) {
                this.addRuleResultMessagesToActionMessages("enrolmentError", request, ex.getFalseResult());
                return this.enrolStudent(mapping, form, request, response);
            }
            catch (DomainException e) {
                this.addActionMessage("error", request, e.getMessage(), e.getArgs());
                return this.enrolStudent(mapping, form, request, response);
            }
        }
        for (Enrolment enrolment : group.getEnrolmentsBy(executionSemester)) {
            if (!remaining.contains((Object)enrolment.getCurricularCourse())) continue;
            studentCurricularPlan.removeCurriculumModulesFromNoCourseGroupCurriculumGroup(Collections.singletonList(enrolment), executionSemester, NoCourseGroupCurriculumGroupType.STANDALONE);
        }
        MobilityIndividualApplicationProcess process2 = this.getProcess(request);
        MobilityIndividualApplication candidacy = process2.getCandidacy();
        ErasmusBolonhaStudentEnrollmentBean bean = new ErasmusBolonhaStudentEnrollmentBean(candidacy.getRegistration().getActiveStudentCurricularPlan(), erasmusBolonhaStudentEnrollmentBean.getExecutionPeriod(), null, CurricularRuleLevel.ENROLMENT_NO_RULES, candidacy);
        RenderUtils.invalidateViewState();
        return this.enrolStudent(mapping, request, this.getProcess(request), bean);
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        return null;
    }

    protected BolonhaStudentEnrollmentBean getBolonhaStudentEnrollmentBeanFromViewState() {
        return (BolonhaStudentEnrollmentBean)this.getRenderedObject("bolonhaStudentEnrolments");
    }

    public ActionForward prepareChooseCycleCourseGroupToEnrol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ErasmusBolonhaStudentEnrollmentBean studentEnrollmentBean = (ErasmusBolonhaStudentEnrollmentBean)this.getRenderedObject();
        CycleEnrolmentBean cycleEnrolmentBean = new CycleEnrolmentBean(studentEnrollmentBean.getStudentCurricularPlan(), studentEnrollmentBean.getExecutionPeriod(), studentEnrollmentBean.getCycleTypeToEnrol().getSourceCycleAffinity(), studentEnrollmentBean.getCycleTypeToEnrol());
        request.setAttribute("cycleEnrolmentBean", (Object)cycleEnrolmentBean);
        request.setAttribute("withRules", (Object)false);
        request.setAttribute("process", (Object)studentEnrollmentBean.getCandidacy().getCandidacyProcess());
        return mapping.findForward("chooseCycleCourseGroupToEnrol");
    }

    public ActionForward cancelChooseCycleCourseGroupToEnrol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        return this.enrolStudent(mapping, form, request, response);
    }

    public ActionForward enrolInCycleCourseGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        CycleEnrolmentBean cycleEnrolmentBean = this.getCycleEnrolmentBeanFromViewState();
        try {
            EnrolInAffinityCycle.run(this.getLoggedPerson(request), cycleEnrolmentBean);
        }
        catch (IllegalDataAccessException e) {
            this.addActionMessage(request, "error.NotAuthorized");
            request.setAttribute("withRules", (Object)request.getParameter("withRules"));
            request.setAttribute("cycleEnrolmentBean", (Object)cycleEnrolmentBean);
            return mapping.findForward("chooseCycleCourseGroupToEnrol");
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getKey(), e.getArgs());
            request.setAttribute("withRules", (Object)request.getParameter("withRules"));
            request.setAttribute("cycleEnrolmentBean", (Object)cycleEnrolmentBean);
            return mapping.findForward("chooseCycleCourseGroupToEnrol");
        }
        return this.enrolStudent(mapping, form, request, response);
    }

    private CycleEnrolmentBean getCycleEnrolmentBeanFromViewState() {
        return (CycleEnrolmentBean)this.getRenderedObject("cycleEnrolmentBean");
    }
}

