/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.candidate;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.candidacy.Candidacy;
import org.fenixedu.academic.domain.candidacy.CandidacySituationType;
import org.fenixedu.academic.domain.candidacy.DFACandidacy;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;
import org.fenixedu.academic.dto.candidacy.PrecedentDegreeInformationBean;
import org.fenixedu.academic.service.services.administrativeOffice.candidacy.EditPrecedentDegreeInformation;
import org.fenixedu.academic.service.services.commons.StateMachineRunner;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.candidate.ViewCandidaciesDispatchAction;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@Mapping(module="candidate", path="/changePersonalData", functionality=ViewCandidaciesDispatchAction.class)
@Forwards(value={@Forward(name="change", path="/candidate/changePersonalData.jsp"), @Forward(name="changeSuccess", path="/candidate/changeSuccessPersonalData.jsp"), @Forward(name="cannotChange", path="/candidate/cannotChangePersonalData.jsp")})
public class ChangePersonalDataDispatchAction
extends FenixDispatchAction {
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Candidacy candidacy = this.getCandidacy(request);
        if (candidacy instanceof DFACandidacy && candidacy.getActiveCandidacySituation().canChangePersonalData()) {
            request.setAttribute("candidacy", (Object)candidacy);
            PrecedentDegreeInformation precedentDegreeInformation = ((DFACandidacy)((Object)candidacy)).getPrecedentDegreeInformation();
            request.setAttribute("precedentDegreeInformation", (Object)new PrecedentDegreeInformationBean(precedentDegreeInformation));
            return mapping.findForward("change");
        }
        return mapping.findForward("cannotChange");
    }

    public ActionForward change(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        PrecedentDegreeInformationBean precedentDegreeInformation = (PrecedentDegreeInformationBean)RenderUtils.getViewState((String)"precedentDegreeInformation").getMetaObject().getObject();
        EditPrecedentDegreeInformation.run(precedentDegreeInformation);
        try {
            StateMachineRunner.run(new StateMachineRunner.RunnerArgs(precedentDegreeInformation.getPrecedentDegreeInformation().getStudentCandidacy().getActiveCandidacySituation(), CandidacySituationType.STAND_BY_FILLED_DATA.toString()));
        }
        catch (DomainException domainException) {
            // empty catch block
        }
        request.setAttribute("candidacy", (Object)precedentDegreeInformation.getPrecedentDegreeInformation().getStudentCandidacy());
        return mapping.findForward("changeSuccess");
    }

    private Candidacy getCandidacy(HttpServletRequest request) {
        String candidacyId = request.getParameter("candidacyID");
        for (Candidacy candidacy : ChangePersonalDataDispatchAction.getUserView(request).getPerson().getCandidaciesSet()) {
            if (!candidacy.getExternalId().equals(candidacyId)) continue;
            return candidacy;
        }
        return null;
    }
}

