/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.components;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Installation;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class UIBreadCrumbs
extends UIInput {
    private static final String CRUMB_SEPERATOR = "&nbsp;&gt;&nbsp;";
    private static final String DEGREE_SITE_LINK = "/publico/showDegreeSite.do?method=showDescription&degreeID=";
    public static final String COMPONENT_TYPE = UIBreadCrumbs.class.getName();
    public static final String COMPONENT_FAMILY = UIBreadCrumbs.class.getName();

    public UIBreadCrumbs() {
        this.setRendererType(null);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        Map attributes = this.getAttributes();
        Degree degree = (Degree)attributes.get("degree");
        String trailingCrumb = (String)attributes.get("trailingCrumb");
        ResponseWriter responseWriter = context.getResponseWriter();
        String institutionUrl = Installation.getInstance().getInstituitionURL();
        String institutionNameAbbreviation = Unit.getInstitutionAcronym();
        String linkInstitution = BundleUtil.getString((String)"resources.GlobalResources", (String)"link.institution", (String[])new String[0]);
        String labelEducation = BundleUtil.getString((String)"resources.PublicDegreeInformation", (String)"public.degree.information.label.education", (String[])new String[0]).toString();
        this.writeLink(responseWriter, institutionUrl, institutionNameAbbreviation);
        responseWriter.write(CRUMB_SEPERATOR);
        this.writeLink(responseWriter, institutionUrl + linkInstitution, labelEducation);
        responseWriter.write(CRUMB_SEPERATOR);
        if (degree != null) {
            this.writeLink(responseWriter, context.getExternalContext().getRequestContextPath() + DEGREE_SITE_LINK + degree.getExternalId(), degree.getSigla());
            responseWriter.write(CRUMB_SEPERATOR);
            responseWriter.write(trailingCrumb);
        }
    }

    private void writeLink(ResponseWriter responseWriter, String link, String text) throws IOException {
        responseWriter.startElement("a", (UIComponent)this);
        responseWriter.writeAttribute("href", (Object)link, null);
        responseWriter.write(text);
        responseWriter.endElement("a");
    }

    private void writeBR(ResponseWriter responseWriter) throws IOException {
        responseWriter.startElement("br", (UIComponent)this);
        responseWriter.endElement("br");
    }
}

