/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.bean.manager.curricularPlans;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.faces.model.SelectItem;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.commons.CurricularCourseByExecutionSemesterBean;
import org.fenixedu.academic.predicate.IllegalDataAccessException;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.manager.CreateOldCurricularCourse;
import org.fenixedu.academic.service.services.manager.EditOldCurricularCourse;
import org.fenixedu.academic.ui.faces.bean.bolonhaManager.curricularPlans.CurricularCourseManagementBackingBean;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class ManagerCurricularCourseManagementBackingBean
extends CurricularCourseManagementBackingBean {
    private String code;
    private String acronym;
    private Integer minimumValueForAcumulatedEnrollments;
    private Integer maximumValueForAcumulatedEnrollments;
    private Integer enrollmentWeigth;
    private Double credits;
    private Double ectsCredits;
    private Double theoreticalHours;
    private Double labHours;
    private Double praticalHours;
    private Double theoPratHours;
    private String gradeScaleString;
    private GradeScale gradeScale;
    private CurricularCourseByExecutionSemesterBean curricularCourseSemesterBean = null;

    public ManagerCurricularCourseManagementBackingBean() {
        if (this.getCurricularCourse() != null && this.getExecutionYear() != null) {
            this.curricularCourseSemesterBean = new CurricularCourseByExecutionSemesterBean(this.getCurricularCourse(), ExecutionSemester.readBySemesterAndExecutionYear(2, this.getExecutionYear().getYear()));
        }
    }

    @Override
    public CurricularCourseByExecutionSemesterBean getCurricularCourseSemesterBean() {
        return this.curricularCourseSemesterBean;
    }

    @Override
    public void setCurricularCourseSemesterBean(CurricularCourseByExecutionSemesterBean curricularCourseSemesterBean) {
        this.curricularCourseSemesterBean = curricularCourseSemesterBean;
    }

    public String getAcronym() {
        if (this.getCurricularCourse() != null) {
            this.acronym = this.getCurricularCourse().getAcronym();
        }
        return this.acronym;
    }

    public void setAcronym(String acronym) {
        this.acronym = acronym;
    }

    public String getCode() {
        if (this.code == null) {
            this.code = this.getCurricularCourse() != null ? this.getCurricularCourse().getCode() : "";
        }
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Double getCredits() {
        if (this.credits == null) {
            this.credits = this.getCurricularCourse() != null ? this.getCurricularCourse().getCredits() : Double.valueOf(0.0);
        }
        return this.credits;
    }

    public void setCredits(Double credits) {
        this.credits = credits;
    }

    public Double getEctsCredits() {
        if (this.ectsCredits == null) {
            this.ectsCredits = this.getCurricularCourse() != null ? this.getCurricularCourse().getEctsCredits() : Double.valueOf(0.0);
        }
        return this.ectsCredits;
    }

    public void setEctsCredits(Double ectsCredits) {
        this.ectsCredits = ectsCredits;
    }

    public Double getTheoreticalHours() {
        if (this.theoreticalHours == null) {
            this.theoreticalHours = this.getCurricularCourse() != null ? this.getCurricularCourse().getTheoreticalHours() : Double.valueOf(0.0);
        }
        return this.theoreticalHours;
    }

    public void setTheoreticalHours(Double theoreticalHours) {
        this.theoreticalHours = theoreticalHours;
    }

    public Double getLabHours() {
        if (this.labHours == null) {
            this.labHours = this.getCurricularCourse() != null ? this.getCurricularCourse().getLabHours() : Double.valueOf(0.0);
        }
        return this.labHours;
    }

    public void setLabHours(Double labHours) {
        this.labHours = labHours;
    }

    public Double getPraticalHours() {
        if (this.praticalHours == null) {
            this.praticalHours = this.getCurricularCourse() != null ? this.getCurricularCourse().getPraticalHours() : Double.valueOf(0.0);
        }
        return this.praticalHours;
    }

    public void setPraticalHours(Double praticalHours) {
        this.praticalHours = praticalHours;
    }

    public Double getTheoPratHours() {
        if (this.theoPratHours == null) {
            this.theoPratHours = this.getCurricularCourse() != null ? this.getCurricularCourse().getTheoPratHours() : Double.valueOf(0.0);
        }
        return this.theoPratHours;
    }

    public void setTheoPratHours(Double theoPratHours) {
        this.theoPratHours = theoPratHours;
    }

    public Integer getEnrollmentWeigth() {
        if (this.enrollmentWeigth == null) {
            this.enrollmentWeigth = this.getCurricularCourse() != null ? this.getCurricularCourse().getEnrollmentWeigth() : Integer.valueOf(0);
        }
        return this.enrollmentWeigth;
    }

    public void setEnrollmentWeigth(Integer enrollmentWeigth) {
        this.enrollmentWeigth = enrollmentWeigth;
    }

    public Integer getMaximumValueForAcumulatedEnrollments() {
        if (this.maximumValueForAcumulatedEnrollments == null) {
            this.maximumValueForAcumulatedEnrollments = this.getCurricularCourse() != null ? this.getCurricularCourse().getMaximumValueForAcumulatedEnrollments() : Integer.valueOf(0);
        }
        return this.maximumValueForAcumulatedEnrollments;
    }

    public void setMaximumValueForAcumulatedEnrollments(Integer maximumValueForAcumulatedEnrollments) {
        this.maximumValueForAcumulatedEnrollments = maximumValueForAcumulatedEnrollments;
    }

    public Integer getMinimumValueForAcumulatedEnrollments() {
        if (this.minimumValueForAcumulatedEnrollments == null) {
            this.minimumValueForAcumulatedEnrollments = this.getCurricularCourse() != null ? this.getCurricularCourse().getMinimumValueForAcumulatedEnrollments() : Integer.valueOf(0);
        }
        return this.minimumValueForAcumulatedEnrollments;
    }

    public void setMinimumValueForAcumulatedEnrollments(Integer minimumValueForAcumulatedEnrollments) {
        this.minimumValueForAcumulatedEnrollments = minimumValueForAcumulatedEnrollments;
    }

    public String createOldCurricularCourse() {
        try {
            this.checkCourseGroup();
            this.checkCurricularSemesterAndYear();
            CreateOldCurricularCourse.run(this.getDegreeCurricularPlanID(), this.getCourseGroupID(), this.getName(), this.getNameEn(), this.getCode(), this.getAcronym(), this.getMinimumValueForAcumulatedEnrollments(), this.getMaximumValueForAcumulatedEnrollments(), this.getWeight(), this.getEnrollmentWeigth(), this.getCredits(), this.getEctsCredits(), this.getCurricularYearID(), this.getCurricularSemesterID(), this.getBeginExecutionPeriodID(), this.getEndExecutionPeriodID(), this.getGradeScale());
        }
        catch (FenixActionException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getMessage(), (String[])new String[0]));
            return "";
        }
        catch (IllegalDataAccessException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"error.notAuthorized", (String[])new String[0]));
            return "buildCurricularPlan";
        }
        catch (FenixServiceException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getMessage(), (String[])new String[0]));
            return "";
        }
        catch (DomainException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)e.getMessage(), (String[])new String[0]));
            return "";
        }
        catch (Exception e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"general.error", (String[])new String[0]));
            return "buildCurricularPlan";
        }
        this.addInfoMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"curricularCourseCreated", (String[])new String[0]));
        return "buildCurricularPlan";
    }

    public String editOldCurricularCourse() {
        try {
            EditOldCurricularCourse.run(this.getCurricularCourseID(), this.getName(), this.getNameEn(), this.getCode(), this.getAcronym(), this.getMinimumValueForAcumulatedEnrollments(), this.getMaximumValueForAcumulatedEnrollments(), this.getWeight(), this.getEnrollmentWeigth(), this.getCredits(), this.getEctsCredits(), this.getTheoreticalHours(), this.getLabHours(), this.getPraticalHours(), this.getTheoPratHours(), this.getGradeScale());
            this.setContextID(null);
        }
        catch (FenixServiceException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getMessage(), (String[])new String[0]));
        }
        this.addInfoMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"curricularCourseEdited", (String[])new String[0]));
        return "";
    }

    @Override
    protected List<SelectItem> readExecutionYearItems() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        if (this.isBolonha()) {
            this.readBolonhaExecutionYears(result);
        } else {
            this.readPreBolonhaExecutionYears(result);
        }
        Collections.sort(result, new Comparator<SelectItem>(){

            @Override
            public int compare(SelectItem o1, SelectItem o2) {
                return -o1.getLabel().compareTo(o2.getLabel());
            }
        });
        return result;
    }

    private void readBolonhaExecutionYears(List<SelectItem> result) {
        Set executionDegrees = this.getDegreeCurricularPlan().getExecutionDegreesSet();
        if (executionDegrees.isEmpty()) {
            for (ExecutionYear executionYear : ExecutionYear.readNotClosedExecutionYears()) {
                result.add(new SelectItem((Object)executionYear.getExternalId(), executionYear.getYear()));
            }
            if (this.getExecutionYearID() == null) {
                this.setExecutionYearID(ExecutionYear.readCurrentExecutionYear().getExternalId());
            }
        } else {
            for (ExecutionDegree executionDegree : executionDegrees) {
                result.add(new SelectItem((Object)executionDegree.getExecutionYear().getExternalId(), executionDegree.getExecutionYear().getYear()));
            }
            if (this.getExecutionYearID() == null) {
                this.setExecutionYearID(this.getDegreeCurricularPlan().getMostRecentExecutionDegree().getExecutionYear().getExternalId());
            }
        }
    }

    private void readPreBolonhaExecutionYears(List<SelectItem> result) {
        for (ExecutionYear executionYear : rootDomainObject.getExecutionYearsSet()) {
            result.add(new SelectItem((Object)executionYear.getExternalId(), executionYear.getYear()));
        }
        if (this.getExecutionYearID() == null) {
            this.setExecutionYearID(ExecutionYear.readCurrentExecutionYear().getExternalId());
        }
    }

    @Override
    protected List<SelectItem> readExecutionPeriodItems() {
        return this.isBolonha() ? super.readExecutionPeriodItems() : this.readPreBolonhaExecutionPeriodItems();
    }

    private List<SelectItem> readPreBolonhaExecutionPeriodItems() {
        ArrayList semesters = new ArrayList(rootDomainObject.getExecutionPeriodsSet());
        Collections.sort(semesters, new ReverseComparator(ExecutionSemester.COMPARATOR_BY_SEMESTER_AND_YEAR));
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        for (ExecutionSemester semester : semesters) {
            result.add(new SelectItem((Object)semester.getExternalId(), semester.getQualifiedName()));
        }
        return result;
    }

    public List<SelectItem> getGradeScales() {
        ArrayList<SelectItem> res = new ArrayList<SelectItem>();
        this.getClass();
        res.add(new SelectItem((Object)"-1", BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"choose", (String[])new String[0])));
        for (GradeScale gradeScale : GradeScale.values()) {
            res.add(new SelectItem((Object)gradeScale.getName(), BundleUtil.getString((String)"resources.EnumerationResources", (String)gradeScale.getName(), (String[])new String[0])));
        }
        return res;
    }

    public String getGradeScaleString() {
        if (this.gradeScaleString == null && this.getCurricularCourse() != null) {
            this.gradeScaleString = this.getCurricularCourse().getGradeScale() != null ? this.getCurricularCourse().getGradeScale().name() : null;
        }
        return this.gradeScaleString;
    }

    public void setGradeScaleString(String value) {
        this.gradeScaleString = value;
    }

    /*
     * Enabled aggressive block sorting
     */
    private GradeScale getGradeScale() {
        if (this.gradeScale == null && this.getGradeScaleString() != null) {
            this.getClass();
            if (!"-1".equals(this.getGradeScaleString())) {
                this.gradeScale = GradeScale.valueOf(this.getGradeScaleString());
                return this.gradeScale;
            }
        }
        if (this.gradeScale != null) return this.gradeScale;
        if (this.getGradeScaleString() == null) return this.gradeScale;
        this.getClass();
        if (!"-1".equals(this.getGradeScaleString())) return this.gradeScale;
        this.gradeScale = null;
        return this.gradeScale;
    }
}

