/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.bean.coordinator;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accessControl.SearchDegreeStudentsGroup;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;
import org.fenixedu.academic.domain.studentCurricularPlan.StudentCurricularPlanState;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.faces.bean.base.FenixBackingBean;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import pt.ist.fenixframework.FenixFramework;

public class CoordinatorStudentsBackingBean
extends FenixBackingBean {
    private static final int RESULTS_PER_PAGE = 100;
    private String degreeCurricularPlanID = null;
    private String executionDegreeId = null;
    private String sortBy = null;
    private String studentCurricularPlanStateString = StudentCurricularPlanState.ACTIVE.toString();
    private String registrationStateTypeString;
    private String minGradeString = "";
    private String maxGradeString = "";
    private String minNumberApprovedString = "";
    private String maxNumberApprovedString = "";
    private String minStudentNumberString = "";
    private String maxStudentNumberString = "";
    private String minimumYearString = "";
    private String maximumYearString = "";
    private Integer minIndex = null;
    private Integer maxIndex = null;
    private Boolean showPhoto = null;

    public String getDegreeCurricularPlanID() {
        return this.degreeCurricularPlanID == null ? (this.degreeCurricularPlanID = this.getAndHoldStringParameter("degreeCurricularPlanID")) : this.degreeCurricularPlanID;
    }

    public void setDegreeCurricularPlanID(String degreeCurricularPlanID) {
        this.degreeCurricularPlanID = degreeCurricularPlanID;
    }

    public String getExecutionDegreeId() {
        return this.executionDegreeId == null ? (this.executionDegreeId = this.getAndHoldStringParameter("executionDegreeId")) : this.executionDegreeId;
    }

    public void setExecutionDegreeId(String executionDegreeId) {
        this.executionDegreeId = executionDegreeId;
    }

    public String getSortBy() {
        return this.sortBy == null ? (this.sortBy = this.getAndHoldStringParameter("sortBy")) : this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public DegreeCurricularPlan getDegreeCurricularPlan() {
        String degreeCurricularPlanID = this.getDegreeCurricularPlanID();
        return (DegreeCurricularPlan)FenixFramework.getDomainObject((String)degreeCurricularPlanID);
    }

    public String getStudentCurricularPlanStateString() {
        return this.studentCurricularPlanStateString == null ? (this.studentCurricularPlanStateString = this.getAndHoldStringParameter("studentCurricularPlanStateString")) : this.studentCurricularPlanStateString;
    }

    public void setStudentCurricularPlanStateString(String studentCurricularPlanStateString) {
        this.studentCurricularPlanStateString = studentCurricularPlanStateString;
    }

    public String getRegistrationStateTypeString() {
        if (this.registrationStateTypeString == null) {
            this.registrationStateTypeString = this.getAndHoldStringParameter("registrationStateTypeString");
        }
        return this.registrationStateTypeString == null ? RegistrationStateType.REGISTERED.toString() : this.registrationStateTypeString;
    }

    public void setRegistrationStateTypeString(String registrationStateTypeString) {
        this.registrationStateTypeString = registrationStateTypeString;
    }

    public String getMaxGradeString() {
        if (this.maxGradeString == null || this.maxGradeString.length() == 0) {
            this.maxGradeString = this.getAndHoldStringParameter("maxGradeString");
        }
        return this.maxGradeString != null ? this.maxGradeString : "";
    }

    public void setMaxGradeString(String maxGradeString) {
        this.maxGradeString = maxGradeString;
    }

    public String getMinGradeString() {
        if (this.minGradeString == null || this.minGradeString.length() == 0) {
            this.minGradeString = this.getAndHoldStringParameter("minGradeString");
        }
        return this.minGradeString != null ? this.minGradeString : "";
    }

    public void setMinGradeString(String minGradeString) {
        this.minGradeString = minGradeString;
    }

    public Double getMinGrade() {
        String minGradeString = this.getMinGradeString();
        return minGradeString != null && minGradeString.length() > 0 ? Double.valueOf(minGradeString) : null;
    }

    public Double getMaxGrade() {
        String maxGradeString = this.getMaxGradeString();
        return maxGradeString != null && maxGradeString.length() > 0 ? Double.valueOf(maxGradeString) : null;
    }

    public String getMaxNumberApprovedString() {
        if (this.maxNumberApprovedString == null || this.maxNumberApprovedString.length() == 0) {
            this.maxNumberApprovedString = this.getAndHoldStringParameter("maxNumberApprovedString");
        }
        return this.maxNumberApprovedString != null ? this.maxNumberApprovedString : "";
    }

    public void setMaxNumberApprovedString(String maxNumberApprovedString) {
        this.maxNumberApprovedString = maxNumberApprovedString;
    }

    public String getMinNumberApprovedString() {
        if (this.minNumberApprovedString == null || this.minNumberApprovedString.length() == 0) {
            this.minNumberApprovedString = this.getAndHoldStringParameter("minNumberApprovedString");
        }
        return this.minNumberApprovedString != null ? this.minNumberApprovedString : "";
    }

    public void setMinNumberApprovedString(String minNumberApprovedString) {
        this.minNumberApprovedString = minNumberApprovedString;
    }

    public Double getMinNumberApproved() {
        String minNumberApprovedString = this.getMinNumberApprovedString();
        return minNumberApprovedString != null && minNumberApprovedString.length() > 0 ? Double.valueOf(minNumberApprovedString) : null;
    }

    public Double getMaxNumberApproved() {
        String maxNumberApprovedString = this.getMaxNumberApprovedString();
        return maxNumberApprovedString != null && maxNumberApprovedString.length() > 0 ? Double.valueOf(maxNumberApprovedString) : null;
    }

    public String getMinStudentNumberString() {
        if (this.minStudentNumberString == null || this.minStudentNumberString.length() == 0) {
            this.minStudentNumberString = this.getAndHoldStringParameter("minStudentNumberString");
        }
        return this.minStudentNumberString != null ? this.minStudentNumberString : "";
    }

    public void setMinStudentNumberString(String minStudentNumberString) {
        this.minStudentNumberString = minStudentNumberString;
    }

    public String getMaxStudentNumberString() {
        if (this.maxStudentNumberString == null || this.maxStudentNumberString.length() == 0) {
            this.maxStudentNumberString = this.getAndHoldStringParameter("maxStudentNumberString");
        }
        return this.maxStudentNumberString != null ? this.maxStudentNumberString : "";
    }

    public void setMaxStudentNumberString(String maxStudentNumberString) {
        this.maxStudentNumberString = maxStudentNumberString;
    }

    public Double getMinStudentNumber() {
        String minStudentNumberString = this.getMinStudentNumberString();
        return minStudentNumberString != null && minStudentNumberString.length() > 0 ? Double.valueOf(minStudentNumberString) : null;
    }

    public Double getMaxStudentNumber() {
        String maxStudentNumberString = this.getMaxStudentNumberString();
        return maxStudentNumberString != null && maxStudentNumberString.length() > 0 ? Double.valueOf(maxStudentNumberString) : null;
    }

    public int getNumberResults() {
        return this.filterAllStudentCurricularPlans().size();
    }

    public String getMinimumYearString() {
        if (this.minimumYearString == null || this.minimumYearString.length() == 0) {
            this.minimumYearString = this.getAndHoldStringParameter("minimumYearString");
        }
        return this.minimumYearString != null ? this.minimumYearString : "";
    }

    public Integer getMinimumYear() {
        String minimumYearString = this.getMinimumYearString();
        return minimumYearString != null && minimumYearString.length() > 0 ? Integer.valueOf(minimumYearString) : null;
    }

    public void setMinimumYearString(String minimumYearString) {
        this.minimumYearString = minimumYearString;
    }

    public String getMaximumYearString() {
        if (this.maximumYearString == null || this.maximumYearString.length() == 0) {
            this.maximumYearString = this.getAndHoldStringParameter("maximumYearString");
        }
        return this.maximumYearString != null ? this.maximumYearString : "";
    }

    public Integer getMaximumYear() {
        String maximumYearString = this.getMaximumYearString();
        return maximumYearString != null && maximumYearString.length() > 0 ? Integer.valueOf(maximumYearString) : null;
    }

    public void setMaximumYearString(String maximumYearString) {
        this.maximumYearString = maximumYearString;
    }

    public List<Map.Entry<StudentCurricularPlan, RegistrationStateType>> getStudentCurricularPlans() throws FenixServiceException {
        Map<StudentCurricularPlan, RegistrationStateType> studentCurricularPlans = this.filterPageStudentCurricularPlans();
        for (StudentCurricularPlan studentCurricularPlan : studentCurricularPlans.keySet()) {
            Object var2_3;
            if (studentCurricularPlan.getRegistration() == null) {
                var2_3 = null;
            }
            if (studentCurricularPlan.getRegistration().getLastRegistrationState(this.getExecutionYear()) == null) {
                var2_3 = null;
            }
            RegistrationStateType registrationState = studentCurricularPlan.getRegistration().getLastRegistrationState(this.getExecutionYear()).getStateType();
            studentCurricularPlans.put(studentCurricularPlan, registrationState);
        }
        return new ArrayList<Map.Entry<StudentCurricularPlan, RegistrationStateType>>(studentCurricularPlans.entrySet());
    }

    public ExecutionYear getExecutionYear() {
        if (this.executionDegreeId != null) {
            ExecutionDegree executionDegree = (ExecutionDegree)FenixFramework.getDomainObject((String)this.executionDegreeId);
            return executionDegree.getExecutionYear();
        }
        return ExecutionYear.readCurrentExecutionYear();
    }

    private SearchDegreeStudentsGroup getSearchCriteriaGroup() {
        return new SearchDegreeStudentsGroup(this.getDegreeCurricularPlan(), this.getExecutionYear(), this.getSortBy(), this.getRegistrationStateType(), this.getMinGrade(), this.getMaxGrade(), this.getMinNumberApproved(), this.getMaxNumberApproved(), this.getMinStudentNumber(), this.getMaxStudentNumber(), this.getMinimumYear(), this.getMaximumYear());
    }

    private Map<StudentCurricularPlan, RegistrationStateType> filterAllStudentCurricularPlans() {
        SearchDegreeStudentsGroup searchGroup = this.getSearchCriteriaGroup();
        Map<StudentCurricularPlan, RegistrationStateType> map = searchGroup.searchStudentCurricularPlans(null, null);
        return map;
    }

    private Map<StudentCurricularPlan, RegistrationStateType> filterPageStudentCurricularPlans() {
        SearchDegreeStudentsGroup searchGroup = this.getSearchCriteriaGroup();
        Map<StudentCurricularPlan, RegistrationStateType> map = searchGroup.searchStudentCurricularPlans(this.getMinIndex(), this.getMaxIndex());
        return map;
    }

    public String getApplicationResourcesString(String name) {
        return BundleUtil.getString((String)"resources.ApplicationResources", (String)name, (String[])new String[0]);
    }

    public String getSerializedFilteredStudents() {
        SearchDegreeStudentsGroup searchGroup = this.getSearchCriteriaGroup();
        return searchGroup.serialize();
    }

    public StudentCurricularPlanState getStudentCurricularPlanState() {
        String studentCurricularPlanStateString = this.getStudentCurricularPlanStateString();
        return studentCurricularPlanStateString != null && studentCurricularPlanStateString.length() > 0 ? StudentCurricularPlanState.valueOf(studentCurricularPlanStateString) : null;
    }

    public RegistrationStateType getRegistrationStateType() {
        String registrationStateTypeString = this.getRegistrationStateTypeString();
        return registrationStateTypeString != null && registrationStateTypeString.length() > 0 && !registrationStateTypeString.equals("SHOWALL") ? RegistrationStateType.valueOf(registrationStateTypeString) : null;
    }

    public Integer getMaxIndex() {
        if (this.maxIndex == null) {
            this.maxIndex = this.getAndHoldIntegerParameter("maxIndex");
        }
        return this.maxIndex == null ? 100 : this.maxIndex;
    }

    public void setMaxIndex(Integer maxIndex) {
        this.maxIndex = maxIndex;
    }

    public Integer getMinIndex() {
        if (this.minIndex == null) {
            this.minIndex = this.getAndHoldIntegerParameter("minIndex");
        }
        return this.minIndex == null ? 1 : this.minIndex;
    }

    public void setMinIndex(Integer minIndex) {
        this.minIndex = minIndex;
    }

    public List<Integer> getIndexes() throws FenixServiceException {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        double numberIndexes = Math.ceil(0.5 + (double)(this.getNumberResults() / 100));
        int i = 1;
        while ((double)i <= numberIndexes) {
            indexes.add((i - 1) * 100 + 1);
            ++i;
        }
        return indexes;
    }

    public Integer getResultsPerPage() {
        return 100;
    }

    public Boolean getShowPhoto() {
        String showPhotoString = this.getAndHoldStringParameter("showPhoto");
        return "true".equals(showPhotoString) ? Boolean.TRUE : this.showPhoto;
    }

    public void setShowPhoto(Boolean showPhoto) {
        this.showPhoto = showPhoto;
    }

    public void exportStudentsToExcel() throws IOException {
        Spreadsheet spreadsheet = this.generateSpreadsheet();
        this.getResponse().setContentType("application/vnd.ms-excel");
        this.getResponse().setHeader("Content-disposition", "attachment; filename=" + this.getFilename() + ".xls");
        spreadsheet.exportToXLSSheet((OutputStream)this.getResponse().getOutputStream());
        this.getResponse().getOutputStream().flush();
        this.getResponse().flushBuffer();
        FacesContext.getCurrentInstance().responseComplete();
    }

    private Spreadsheet generateSpreadsheet() {
        Spreadsheet spreadsheet = this.createSpreadSheet();
        for (StudentCurricularPlan studentCurricularPlan : this.filterAllStudentCurricularPlans().keySet()) {
            Spreadsheet.Row row = spreadsheet.addRow();
            row.setCell(studentCurricularPlan.getRegistration().getNumber());
            row.setCell(studentCurricularPlan.getPerson().getName());
            row.setCell(studentCurricularPlan.getPerson().getInstitutionalOrDefaultEmailAddressValue());
            row.setCell(studentCurricularPlan.getRegistration().getLastRegistrationState(this.getExecutionYear()).getStateType().getDescription());
            row.setCell(Integer.valueOf(studentCurricularPlan.getRegistration().getNumberOfCurriculumEntries()));
            row.setCell(Double.valueOf(studentCurricularPlan.getRegistration().getEctsCredits()));
            row.setCell(this.getAverageInformation(studentCurricularPlan));
            row.setCell(Integer.valueOf(studentCurricularPlan.getRegistration().getCurricularYear()));
        }
        return spreadsheet;
    }

    private String getFilename() {
        return BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.students.lowercase", (String[])new String[0]);
    }

    private String getAverageInformation(StudentCurricularPlan studentCurricularPlan) {
        Registration registration = studentCurricularPlan.getRegistration();
        if (registration.isConcluded()) {
            if (registration.isRegistrationConclusionProcessed() && (!registration.isBolonha() || studentCurricularPlan.getInternalCycleCurriculumGroupsSize() == 1)) {
                return registration.getRawGrade().getValue();
            }
            return " - ";
        }
        return registration.getRawGrade().getValue();
    }

    private Spreadsheet createSpreadSheet() {
        Spreadsheet spreadsheet = new Spreadsheet(BundleUtil.getString((String)"resources.ApplicationResources", (String)"list.students", (String[])new String[0]));
        spreadsheet.setHeaders(new String[]{BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.number", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.name", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.email", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.student.curricular.plan.state", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.number.approved.curricular.courses", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.ects", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.aritmeticAverage", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.student.curricular.year", (String[])new String[0]), " ", " "});
        return spreadsheet;
    }
}

