/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.accounting.paymentPlan;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.accounting.Installment;
import org.fenixedu.academic.domain.accounting.installments.InstallmentForFirstTimeStudents;
import org.fenixedu.academic.domain.accounting.installments.InstallmentWithMonthlyPenalty;
import org.fenixedu.academic.domain.accounting.installments.PartialRegimeInstallment;
import org.fenixedu.academic.dto.accounting.paymentPlan.PaymentPlanBean;
import org.fenixedu.academic.util.Money;
import org.joda.time.YearMonthDay;

public class InstallmentBean
implements Serializable {
    private static final long serialVersionUID = -103744109361724129L;
    private boolean selected;
    private Money amount;
    private BigDecimal ectsForAmount;
    private List<ExecutionSemester> executionSemesters;
    private YearMonthDay startDate;
    private YearMonthDay endDate;
    private boolean penaltyAppliable;
    private BigDecimal montlyPenaltyPercentage;
    private YearMonthDay whenToStartApplyPenalty;
    private Integer maxMonthsToApplyPenalty;
    private PaymentPlanBean paymentPlanBean;
    private Integer numberOfDaysToStartApplyingPenalty = null;

    public InstallmentBean(PaymentPlanBean paymentPlanBean) {
        this.setExecutionSemesters(new ArrayList<ExecutionSemester>());
        this.setPaymentPlanBean(paymentPlanBean);
    }

    public InstallmentBean(Installment installment) {
        this.setPaymentPlanBean(new PaymentPlanBean(installment.getPaymentPlan().getExecutionYear()));
        this.setExecutionSemesters(new ArrayList<ExecutionSemester>());
        this.setAmount(installment.getAmount());
        this.setStartDate(installment.getStartDate());
        this.setEndDate(installment.getEndDate());
        if (installment instanceof InstallmentWithMonthlyPenalty) {
            InstallmentWithMonthlyPenalty installmentWithPenalty = (InstallmentWithMonthlyPenalty)((Object)installment);
            this.setMaxMonthsToApplyPenalty(installmentWithPenalty.getMaxMonthsToApplyPenalty());
            if (!(installment instanceof InstallmentForFirstTimeStudents)) {
                this.setWhenToStartApplyPenalty(installmentWithPenalty.getWhenStartToApplyPenalty());
            }
            this.setMontlyPenaltyPercentage(installmentWithPenalty.getPenaltyPercentage());
        }
        if (installment instanceof PartialRegimeInstallment) {
            PartialRegimeInstallment partialInstallment = (PartialRegimeInstallment)((Object)installment);
            this.setExecutionSemesters(partialInstallment.getExecutionSemestersSet());
            this.setEctsForAmount(partialInstallment.getEctsForAmount());
        }
        if (installment instanceof InstallmentForFirstTimeStudents) {
            InstallmentForFirstTimeStudents installmentForFirstTimeStudents = (InstallmentForFirstTimeStudents)((Object)installment);
            this.setNumberOfDaysToStartApplyingPenalty(installmentForFirstTimeStudents.getNumberOfDaysToStartApplyingPenalty());
        }
    }

    public PaymentPlanBean getPaymentPlanBean() {
        return this.paymentPlanBean;
    }

    public void setPaymentPlanBean(PaymentPlanBean paymentPlanBean) {
        this.paymentPlanBean = paymentPlanBean;
    }

    public Money getAmount() {
        return this.amount;
    }

    public void setAmount(Money amount) {
        this.amount = amount;
    }

    public YearMonthDay getStartDate() {
        return this.startDate;
    }

    public void setStartDate(YearMonthDay startDate) {
        this.startDate = startDate;
    }

    public YearMonthDay getEndDate() {
        return this.endDate;
    }

    public void setEndDate(YearMonthDay endDate) {
        this.endDate = endDate;
    }

    public BigDecimal getMontlyPenaltyPercentage() {
        return this.montlyPenaltyPercentage;
    }

    public void setMontlyPenaltyPercentage(BigDecimal montlyPenaltyPercentage) {
        this.montlyPenaltyPercentage = montlyPenaltyPercentage;
    }

    public YearMonthDay getWhenToStartApplyPenalty() {
        return this.whenToStartApplyPenalty;
    }

    public void setWhenToStartApplyPenalty(YearMonthDay whenToStartApplyPenalty) {
        this.whenToStartApplyPenalty = whenToStartApplyPenalty;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public Integer getMaxMonthsToApplyPenalty() {
        return this.maxMonthsToApplyPenalty;
    }

    public void setMaxMonthsToApplyPenalty(Integer maxMonthsToApplyPenalty) {
        this.maxMonthsToApplyPenalty = maxMonthsToApplyPenalty;
    }

    public boolean hasRequiredInformation() {
        boolean result;
        boolean bl = result = this.amount != null && this.startDate != null && this.endDate != null;
        if (!this.isPenaltyAppliable()) {
            return result;
        }
        return result && this.montlyPenaltyPercentage != null && this.whenToStartApplyPenalty != null && this.maxMonthsToApplyPenalty != null;
    }

    public boolean isPenaltyAppliable() {
        return this.penaltyAppliable;
    }

    public void setPenaltyAppliable(boolean penaltyAppliable) {
        this.penaltyAppliable = penaltyAppliable;
    }

    public BigDecimal getEctsForAmount() {
        return this.ectsForAmount;
    }

    public void setEctsForAmount(BigDecimal ectsForAmount) {
        this.ectsForAmount = ectsForAmount;
    }

    public Collection<ExecutionSemester> getExecutionSemesters() {
        ArrayList<ExecutionSemester> result = new ArrayList<ExecutionSemester>();
        for (ExecutionSemester each : this.executionSemesters) {
            result.add(each);
        }
        return result;
    }

    public void setExecutionSemesters(Collection<ExecutionSemester> executionSemesters) {
        ArrayList<ExecutionSemester> result = new ArrayList<ExecutionSemester>();
        for (ExecutionSemester each : executionSemesters) {
            result.add(each);
        }
        this.executionSemesters = result;
    }

    public Integer getNumberOfDaysToStartApplyingPenalty() {
        return this.numberOfDaysToStartApplyingPenalty;
    }

    public void setNumberOfDaysToStartApplyingPenalty(Integer numberOfDaysToStartApplyingPenalty) {
        this.numberOfDaysToStartApplyingPenalty = numberOfDaysToStartApplyingPenalty;
    }

    public boolean isForFirstTimeInstitutionStudents() {
        return this.getNumberOfDaysToStartApplyingPenalty() != null;
    }
}

