/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degree.enrollment.NotNeedToEnrollInCurricularCourse;
import org.fenixedu.academic.domain.studentCurricularPlan.Specialization;
import org.fenixedu.academic.domain.studentCurricularPlan.StudentCurricularPlanState;
import org.fenixedu.academic.dto.InfoBranch;
import org.fenixedu.academic.dto.InfoDegreeCurricularPlan;
import org.fenixedu.academic.dto.InfoEnrolment;
import org.fenixedu.academic.dto.InfoNotNeedToEnrollInCurricularCourse;
import org.fenixedu.academic.dto.InfoObject;
import org.fenixedu.academic.dto.InfoStudent;

public class InfoStudentCurricularPlan
extends InfoObject
implements Serializable,
Comparable {
    private final StudentCurricularPlan studentCurricularPlan;

    public InfoStudentCurricularPlan(StudentCurricularPlan studentCurricularPlan) {
        this.studentCurricularPlan = studentCurricularPlan;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof InfoStudentCurricularPlan && this.getStudentCurricularPlan() == ((InfoStudentCurricularPlan)obj).getStudentCurricularPlan();
    }

    public String toString() {
        return this.getStudentCurricularPlan().toString();
    }

    public StudentCurricularPlanState getCurrentState() {
        return this.getStudentCurricularPlan().getCurrentState();
    }

    public InfoBranch getInfoBranch() {
        return InfoBranch.newInfoFromDomain(this.getStudentCurricularPlan().getBranch());
    }

    public InfoDegreeCurricularPlan getInfoDegreeCurricularPlan() {
        return InfoDegreeCurricularPlan.newInfoFromDomain(this.getStudentCurricularPlan().getDegreeCurricularPlan());
    }

    public InfoStudent getInfoStudent() {
        return InfoStudent.newInfoFromDomain(this.getStudentCurricularPlan().getRegistration());
    }

    public Date getStartDate() {
        return this.getStudentCurricularPlan().getStartDate();
    }

    public String getStartDateFormatted() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.getStartDate());
        String result = calendar.get(5) + "/" + (calendar.get(2) + 1) + "/" + calendar.get(1);
        return result;
    }

    public Specialization getSpecialization() {
        return this.getStudentCurricularPlan().getSpecialization();
    }

    public Double getClassification() {
        return this.getStudentCurricularPlan().getClassification();
    }

    public Integer getEnrolledCourses() {
        return this.getStudentCurricularPlan().getEnrolledCourses();
    }

    public Integer getCompletedCourses() {
        return this.getStudentCurricularPlan().getCompletedCourses();
    }

    public List getInfoEnrolments() {
        ArrayList<InfoEnrolment> infoEnrolments = new ArrayList<InfoEnrolment>();
        for (Enrolment enrolment : this.getStudentCurricularPlan().getEnrolmentsSet()) {
            infoEnrolments.add(InfoEnrolment.newInfoFromDomain(enrolment));
        }
        return infoEnrolments;
    }

    public List getInfoEnrolmentsSorted() {
        List infoEnrolments = this.getInfoEnrolments();
        ComparatorChain comparatorChain = new ComparatorChain();
        comparatorChain.addComparator((Comparator)new BeanComparator("infoExecutionPeriod.infoExecutionYear.year"));
        comparatorChain.addComparator((Comparator)new BeanComparator("infoExecutionPeriod.semester"));
        comparatorChain.addComparator((Comparator)new BeanComparator("infoCurricularCourse.name", (Comparator)Collator.getInstance()));
        Collections.sort(infoEnrolments, comparatorChain);
        return infoEnrolments;
    }

    public int compareTo(Object arg0) {
        InfoStudentCurricularPlan obj0 = (InfoStudentCurricularPlan)arg0;
        return obj0.getCurrentState().compareTo(this.getCurrentState());
    }

    public Date getWhen() {
        return this.getStudentCurricularPlan().getWhen();
    }

    public String getObservations() {
        return this.getStudentCurricularPlan().getObservations();
    }

    public InfoBranch getInfoSecundaryBranch() {
        return InfoBranch.newInfoFromDomain(this.getStudentCurricularPlan().getSecundaryBranch());
    }

    public static InfoStudentCurricularPlan newInfoFromDomain(StudentCurricularPlan studentCurricularPlan) {
        return studentCurricularPlan == null ? null : new InfoStudentCurricularPlan(studentCurricularPlan);
    }

    public Double getGivenCredits() {
        return this.getStudentCurricularPlan().getGivenCredits();
    }

    public List<InfoNotNeedToEnrollInCurricularCourse> getInfoNotNeedToEnrollCurricularCourses() {
        ArrayList<InfoNotNeedToEnrollInCurricularCourse> infoNotNeedToEnrollInCurricularCourses = new ArrayList<InfoNotNeedToEnrollInCurricularCourse>();
        for (NotNeedToEnrollInCurricularCourse notNeedToEnrollInCurricularCourse : this.getStudentCurricularPlan().getNotNeedToEnrollCurricularCoursesSet()) {
            infoNotNeedToEnrollInCurricularCourses.add(InfoNotNeedToEnrollInCurricularCourse.newInfoFromDomain(notNeedToEnrollInCurricularCourse));
        }
        return infoNotNeedToEnrollInCurricularCourses;
    }

    @Override
    public String getExternalId() {
        return this.getStudentCurricularPlan().getExternalId();
    }

    @Override
    public void setExternalId(String integer) {
        throw new Error("Method should not be called!");
    }

    public StudentCurricularPlan getStudentCurricularPlan() {
        return this.studentCurricularPlan;
    }
}

