/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.studentCurriculum;

import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.degreeStructure.OptionalCurricularCourse;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.log.OptionalDismissalLog;
import org.fenixedu.academic.domain.studentCurriculum.Credits;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academic.domain.studentCurriculum.OptionalDismissal_Base;
import org.fenixedu.academic.util.EnrolmentAction;

public class OptionalDismissal
extends OptionalDismissal_Base {
    public OptionalDismissal() {
    }

    public OptionalDismissal(Credits credits, CurriculumGroup curriculumGroup, OptionalCurricularCourse optionalCurricularCourse, Double ectsCredits) {
        this.init(credits, curriculumGroup, optionalCurricularCourse, ectsCredits);
        this.createCurriculumLineLog(EnrolmentAction.ENROL);
    }

    protected void init(Credits credits, CurriculumGroup curriculumGroup, OptionalCurricularCourse optionalCurricularCourse, Double ectsCredits) {
        this.init(credits, curriculumGroup, (CurricularCourse)((Object)optionalCurricularCourse));
        this.checkCredits(ectsCredits);
        this.setEctsCredits(ectsCredits);
    }

    private void checkCredits(Double ectsCredits) {
        if (ectsCredits == null || ectsCredits == 0.0) {
            throw new DomainException("error.OptionalDismissal.invalid.credits", new String[0]);
        }
    }

    public OptionalCurricularCourse getCurricularCourse() {
        return (OptionalCurricularCourse)((Object)super.getCurricularCourse());
    }

    public void setDegreeModule(DegreeModule degreeModule) {
        if (degreeModule != null && !(degreeModule instanceof OptionalCurricularCourse)) {
            throw new DomainException("error.optionalDismissal.DegreeModuleCanOnlyBeOptionalCurricularCourse", new String[0]);
        }
        super.setDegreeModule(degreeModule);
    }

    public StringBuilder print(String tabs) {
        StringBuilder builder = new StringBuilder();
        builder.append(tabs);
        builder.append("[OD ").append(this.getDegreeModule() != null ? this.getDegreeModule().getName() : "").append(" ]\n");
        return builder;
    }

    public boolean isSimilar(Dismissal dismissal) {
        return dismissal instanceof OptionalDismissal && super.isSimilar(dismissal) && this.hasSameEctsCredits((OptionalDismissal)((Object)dismissal));
    }

    private boolean hasSameEctsCredits(OptionalDismissal dismissal) {
        return this.getEctsCredits().equals(dismissal.getEctsCredits());
    }

    protected void createCurriculumLineLog(EnrolmentAction action) {
        new OptionalDismissalLog(action, this.getRegistration(), this.getCurricularCourse(), this.getCredits(), this.getEctsCredits(), this.getExecutionPeriod(), this.getCurrentUser());
    }

    public boolean isOptional() {
        return true;
    }
}

