/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests.documentRequests;

import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.PastDiplomaRequest_Base;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestBean;
import org.fenixedu.academic.dto.serviceRequests.DocumentRequestCreateBean;

public class PastDiplomaRequest
extends PastDiplomaRequest_Base {
    public PastDiplomaRequest() {
    }

    public PastDiplomaRequest(DocumentRequestCreateBean bean) {
        this();
        this.init(bean);
        this.checkParameters(bean);
    }

    public DocumentRequestType getDocumentRequestType() {
        return DocumentRequestType.PAST_DIPLOMA_REQUEST;
    }

    public String getDocumentTemplateKey() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.getDegreeType().getName();
    }

    public boolean isPagedDocument() {
        return false;
    }

    public boolean isAvailableForTransitedRegistrations() {
        return false;
    }

    public boolean isPayedUponCreation() {
        return false;
    }

    public boolean isToPrint() {
        return false;
    }

    public boolean isPossibleToSendToOtherEntity() {
        return true;
    }

    public boolean isManagedWithRectorateSubmissionBatch() {
        return false;
    }

    public EventType getEventType() {
        return EventType.PAST_DEGREE_DIPLOMA_REQUEST;
    }

    public boolean hasPersonalInfo() {
        return true;
    }

    protected final void internalChangeState(AcademicServiceRequestBean academicServiceRequestBean) {
        if (academicServiceRequestBean.isToProcess()) {
            this.checkForDuplicate();
            if (!this.getRegistration().isRegistrationConclusionProcessed()) {
                throw new DomainException("DiplomaRequest.registration.not.submited.to.conclusion.process", new String[0]);
            }
        }
    }

    private void checkForDuplicate() {
        PastDiplomaRequest diplomaRequest = this.getRegistration().getPastDiplomaRequest();
        if (diplomaRequest != null && diplomaRequest != this) {
            throw new DomainException("DiplomaRequest.diploma.already.requested", new String[0]);
        }
    }
}

