/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests.documentRequests;

import java.util.Arrays;
import java.util.List;

public enum DocumentRequestType {
    SCHOOL_REGISTRATION_CERTIFICATE(true, false, true, false, false, false),
    ENROLMENT_CERTIFICATE(true, false, true, false, false, false),
    APPROVEMENT_CERTIFICATE(true, false),
    APPROVEMENT_MOBILITY_CERTIFICATE(true, false),
    DEGREE_FINALIZATION_CERTIFICATE(true, false, false, true, false, false),
    PHD_FINALIZATION_CERTIFICATE(false, false),
    EXAM_DATE_CERTIFICATE(true, false),
    SCHOOL_REGISTRATION_DECLARATION(false, true),
    ENROLMENT_DECLARATION(true, true),
    IRS_DECLARATION(true, true),
    GENERIC_DECLARATION(true, true),
    REGISTRY_DIPLOMA_REQUEST(true, false),
    DIPLOMA_REQUEST(false, false),
    DIPLOMA_SUPPLEMENT_REQUEST(true, false, false, false, false, true),
    PAST_DIPLOMA_REQUEST(true, false, false, false, true, false),
    PHOTOCOPY(false, false),
    COURSE_LOAD(true, false),
    EXTERNAL_COURSE_LOAD(true, false),
    PROGRAM_CERTIFICATE(true, false),
    EXTERNAL_PROGRAM_CERTIFICATE(true, false),
    EXTRA_CURRICULAR_CERTIFICATE(true, false),
    UNDER_23_TRANSPORTS_REQUEST(false, false),
    STANDALONE_ENROLMENT_CERTIFICATE(true, false);

    private boolean hasAdditionalInformation;
    private boolean allowedToQuickDeliver;
    private boolean studentRequestable;
    private boolean withBranch;
    private boolean preBolonha;
    private boolean bolonhaOnly;
    private static List<DocumentRequestType> CERTIFICATES;
    private static List<DocumentRequestType> DECLARATIONS;

    private DocumentRequestType(boolean hasAdditionalInformation, boolean allowedToQuickDeliver, boolean studentRequestable, boolean withBranch, boolean preBolonha, boolean bolonhaOnly) {
        this.hasAdditionalInformation = hasAdditionalInformation;
        this.allowedToQuickDeliver = allowedToQuickDeliver;
        this.studentRequestable = studentRequestable;
        this.withBranch = withBranch;
        this.preBolonha = preBolonha;
        this.bolonhaOnly = bolonhaOnly;
    }

    private DocumentRequestType(boolean hasAdditionalInformation, boolean allowedToQuickDeliver) {
        this(hasAdditionalInformation, allowedToQuickDeliver, false, false, false, false);
    }

    public String getName() {
        return this.name();
    }

    public String getQualifiedName() {
        return DocumentRequestType.class.getSimpleName() + "." + this.name();
    }

    public String getFullyQualifiedName() {
        return DocumentRequestType.class.getName() + "." + this.name();
    }

    public boolean isCertificate() {
        return CERTIFICATES.contains((Object)this);
    }

    public boolean isDeclaration() {
        return DECLARATIONS.contains((Object)this);
    }

    public boolean isDiplomaSupplement() {
        return this == DIPLOMA_SUPPLEMENT_REQUEST;
    }

    public boolean isDiploma() {
        return this == DIPLOMA_REQUEST;
    }

    public boolean isRegistryDiploma() {
        return this == REGISTRY_DIPLOMA_REQUEST;
    }

    public boolean isPastDiploma() {
        return this == PAST_DIPLOMA_REQUEST;
    }

    public final boolean getHasAdditionalInformation() {
        return this.hasAdditionalInformation;
    }

    public boolean isAllowedToQuickDeliver() {
        return this.allowedToQuickDeliver;
    }

    public boolean isStudentRequestable() {
        return this.studentRequestable;
    }

    public boolean isPreBolonha() {
        return this.preBolonha;
    }

    public boolean isBolonhaOnly() {
        return this.bolonhaOnly;
    }

    public boolean withBranch() {
        return this.withBranch;
    }

    public boolean getCanBeFreeProcessed() {
        return this.isDeclaration() || this == SCHOOL_REGISTRATION_CERTIFICATE || this == DEGREE_FINALIZATION_CERTIFICATE;
    }

    static {
        CERTIFICATES = Arrays.asList(SCHOOL_REGISTRATION_CERTIFICATE, ENROLMENT_CERTIFICATE, APPROVEMENT_CERTIFICATE, APPROVEMENT_MOBILITY_CERTIFICATE, DEGREE_FINALIZATION_CERTIFICATE, EXAM_DATE_CERTIFICATE, COURSE_LOAD, EXTERNAL_COURSE_LOAD, PROGRAM_CERTIFICATE, EXTERNAL_PROGRAM_CERTIFICATE, EXTRA_CURRICULAR_CERTIFICATE, STANDALONE_ENROLMENT_CERTIFICATE);
        DECLARATIONS = Arrays.asList(SCHOOL_REGISTRATION_DECLARATION, ENROLMENT_DECLARATION, IRS_DECLARATION, GENERIC_DECLARATION);
    }
}

