/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests.documentRequests;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Locale;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.IDiplomaRequest;
import org.fenixedu.academic.domain.serviceRequests.RegistryCode;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.AcademicServiceRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DiplomaRequest_Base;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IRectorateSubmissionBatchDocumentEntry;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.RegistryDiplomaRequest;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.curriculum.ConclusionProcess_Base;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestBean;
import org.fenixedu.academic.dto.serviceRequests.DocumentRequestCreateBean;
import org.fenixedu.academic.dto.serviceRequests.RegistrationAcademicServiceRequestCreateBean;
import org.fenixedu.academic.dto.student.RegistrationConclusionBean;
import org.fenixedu.academic.predicate.AcademicPredicates;
import org.fenixedu.academic.predicate.AccessControl;
import org.joda.time.LocalDate;

public class DiplomaRequest
extends DiplomaRequest_Base
implements IDiplomaRequest,
IRectorateSubmissionBatchDocumentEntry {
    public DiplomaRequest() {
    }

    public DiplomaRequest(DocumentRequestCreateBean bean) {
        this();
        super.init((RegistrationAcademicServiceRequestCreateBean)bean);
        this.checkParameters(bean);
        this.setProgramConclusion(bean.getProgramConclusion());
    }

    protected void checkParameters(DocumentRequestCreateBean bean) {
        if (bean.getProgramConclusion() == null) {
            throw new DomainException("error.program.conclusion.empty", new String[0]);
        }
        this.checkForDuplicate(bean.getProgramConclusion());
    }

    private void checkForDuplicate(ProgramConclusion programConclusion) {
        DiplomaRequest diplomaRequest = this.getRegistration().getDiplomaRequest(programConclusion);
        if (diplomaRequest != null && diplomaRequest != this) {
            throw new DomainException("DiplomaRequest.diploma.already.requested", new String[0]);
        }
    }

    @Override
    public final String getDescription() {
        return Joiner.on((String)" : ").join((Object)super.getDescription(this.getAcademicServiceRequestType()), (Object)this.getProgramConclusion().getName().getContent(), new Object[0]);
    }

    @Override
    public final DocumentRequestType getDocumentRequestType() {
        return DocumentRequestType.DIPLOMA_REQUEST;
    }

    @Override
    public final String getDocumentTemplateKey() {
        String key = this.getClass().getName();
        String suffix = null;
        if (this.getDegreeType().isPreBolonhaMasterDegree()) {
            suffix = "preBolonhaMasterDegree";
        }
        if (this.getDegreeType().isAdvancedFormationDiploma()) {
            suffix = "advancedFormationDiploma";
        }
        if (this.getDegreeType().isAdvancedSpecializationDiploma()) {
            suffix = "advancedSpecializationDiploma";
        }
        if (!Strings.isNullOrEmpty((String)suffix)) {
            return key + "." + suffix;
        }
        return key;
    }

    public static Set<EventType> getPossibleEventTypes() {
        return ImmutableSet.of((Object)((Object)EventType.BOLONHA_DEGREE_DIPLOMA_REQUEST), (Object)((Object)EventType.BOLONHA_MASTER_DEGREE_DIPLOMA_REQUEST), (Object)((Object)EventType.BOLONHA_ADVANCED_FORMATION_DIPLOMA_REQUEST), (Object)((Object)EventType.BOLONHA_ADVANCED_SPECIALIZATION_DIPLOMA_REQUEST));
    }

    @Override
    public final EventType getEventType() {
        Sets.SetView eventTypesToUse = Sets.intersection(DiplomaRequest.getPossibleEventTypes(), this.getProgramConclusion().getEventTypes().getTypes());
        if (eventTypesToUse.size() != 1) {
            throw new DomainException("error.program.conclusion.many.event.types", new String[0]);
        }
        return (EventType)((Object)eventTypesToUse.iterator().next());
    }

    public AcademicServiceRequestType getAcademicServiceRequestType() {
        return AcademicServiceRequestType.DIPLOMA_REQUEST;
    }

    protected final void internalChangeState(AcademicServiceRequestBean academicServiceRequestBean) {
        if (academicServiceRequestBean.isToProcess()) {
            RegistryDiplomaRequest registryRequest;
            if (this.getRegistration().getDegreeType().isSpecializationDegree()) {
                throw new DomainException("DiplomaRequest.diploma.not.available", new String[0]);
            }
            this.checkForDuplicate(this.getProgramConclusion());
            if (!this.getProgramConclusion().isConclusionProcessed(this.getRegistration())) {
                throw new DomainException("DiplomaRequest.registration.not.submited.to.conclusion.process", new String[0]);
            }
            if (this.hasDissertationTitle() && !this.getRegistration().hasDissertationThesis()) {
                throw new DomainException("DiplomaRequest.registration.doesnt.have.dissertation.thesis", new String[0]);
            }
            if (this.getRegistration().isBolonha() && !this.getRegistration().getDegreeType().isAdvancedFormationDiploma() && !this.getRegistration().getDegreeType().isAdvancedSpecializationDiploma() && (registryRequest = this.getRegistration().getRegistryDiplomaRequest(this.getProgramConclusion())) == null) {
                throw new DomainException("DiplomaRequest.registration.withoutRegistryRequest", new String[0]);
            }
            if (!this.getRegistration().getDegreeType().isAdvancedFormationDiploma() && !this.getRegistration().getDegreeType().isAdvancedSpecializationDiploma()) {
                RegistryCode code = this.getRegistryCode();
                if (code != null) {
                    if (!code.getDocumentRequestSet().contains(this)) {
                        code.addDocumentRequest((AcademicServiceRequest)((Object)this));
                        this.getAdministrativeOffice().getCurrentRectorateSubmissionBatch().addDocumentRequest((AcademicServiceRequest)((Object)this));
                    }
                } else {
                    this.getRootDomainObject().getInstitutionUnit().getRegistryCodeGenerator().createRegistryFor((AcademicServiceRequest)((Object)this));
                    this.getAdministrativeOffice().getCurrentRectorateSubmissionBatch().addDocumentRequest((AcademicServiceRequest)((Object)this));
                }
            }
            if (this.getLastGeneratedDocument() == null) {
                this.generateDocument();
            }
        }
    }

    public final boolean hasFinalAverageDescription() {
        return !this.hasDissertationTitle();
    }

    public final boolean hasDissertationTitle() {
        return this.getDegreeType().isPreBolonhaMasterDegree();
    }

    @Override
    public CycleType getRequestedCycle() {
        return this.getProgramConclusion().groupFor(this.getRegistration()).filter(CurriculumModule::isCycleCurriculumGroup).map(cg -> ((CycleCurriculumGroup)((Object)((Object)cg))).getCycleType()).orElse(null);
    }

    public CurriculumGroup getCurriculumGroup() {
        Registration registration = this.getRegistration();
        if (this.getProgramConclusion() == null) {
            if (registration.getDegreeType().hasExactlyOneCycleType()) {
                return registration.getLastStudentCurricularPlan().getLastOrderedCycleCurriculumGroup();
            }
            return null;
        }
        return this.getProgramConclusion().groupFor(this.getRegistration()).orElse(null);
    }

    public boolean hasCurriculumGroup() {
        return this.getCurriculumGroup() != null;
    }

    public boolean hasPersonalInfo() {
        return true;
    }

    public boolean isPagedDocument() {
        return false;
    }

    public boolean isToPrint() {
        return false;
    }

    public void generateRegistryCode() {
        if (this.getRegistryCode() == null) {
            this.getRootDomainObject().getInstitutionUnit().getRegistryCodeGenerator().createRegistryFor((AcademicServiceRequest)((Object)this));
            this.getAdministrativeOffice().getCurrentRectorateSubmissionBatch().addDocumentRequest((AcademicServiceRequest)((Object)this));
        }
        if (this.getLastGeneratedDocument() == null) {
            this.generateDocument();
        }
    }

    @Override
    public RegistryCode getRegistryCode() {
        RegistryDiplomaRequest registry = this.getRegistration().getRegistryDiplomaRequest(this.getProgramConclusion());
        return registry != null ? registry.getRegistryCode() : super.getRegistryCode();
    }

    public boolean isPossibleToSendToOtherEntity() {
        return this.getDegree() == null || this.getDegreeType() == null || !this.getDegreeType().isAdvancedFormationDiploma();
    }

    public boolean isManagedWithRectorateSubmissionBatch() {
        return this.getDegree() == null || this.getDegreeType() == null || !this.getDegreeType().isAdvancedFormationDiploma();
    }

    public boolean isAvailableForTransitedRegistrations() {
        return false;
    }

    public boolean isPayedUponCreation() {
        return false;
    }

    public boolean isCanGenerateRegistryCode() {
        return this.isSendToExternalEntitySituationAccepted() && !this.hasRegistryCode() && !this.getProgramConclusion().getGraduationTitle().isEmpty();
    }

    public void revertToProcessingState() {
        AccessControl.check(this, AcademicPredicates.SERVICE_REQUESTS_REVERT_TO_PROCESSING_STATE);
        this.internalRevertToProcessingState();
    }

    public boolean hasRegistryDiplomaRequest() {
        return this.getRegistration().getRegistryDiplomaRequest(this.getProgramConclusion()) != null;
    }

    @Override
    public LocalDate getConclusionDate() {
        RegistrationConclusionBean registrationConclusionBean = new RegistrationConclusionBean(this.getRegistration(), this.getProgramConclusion());
        return registrationConclusionBean.getConclusionDate().toLocalDate();
    }

    @Override
    public Integer getFinalAverage() {
        RegistrationConclusionBean registrationConclusionBean = new RegistrationConclusionBean(this.getRegistration(), this.getProgramConclusion());
        return registrationConclusionBean.getFinalGrade().getIntegerValue();
    }

    @Override
    public String getFinalAverageQualified() {
        return this.getRegistration().getDegree().getGradeScale().getQualifiedName(this.getFinalAverage().toString());
    }

    @Override
    public String getDissertationThesisTitle() {
        return this.getRegistration().getDissertationThesisTitle();
    }

    public ExecutionYear getConclusionYear() {
        return this.getProgramConclusion().groupFor(this.getRegistration()).map(CurriculumGroup::getConclusionProcess).map(ConclusionProcess_Base::getConclusionYear).orElse(null);
    }

    @Override
    public String getGraduateTitle(Locale locale) {
        return this.getProgramConclusion().groupFor(this.getRegistration()).map(cg -> cg.getDegreeModule().getGraduateTitle(this.getConclusionYear(), locale)).orElse(null);
    }

    public String getDegreeFilteredName() {
        return this.getDegree().getFilteredName(this.getConclusionYear(), this.getLanguage());
    }

    @Override
    public String getProgrammeTypeDescription() {
        return this.getDegreeType().getName().getContent();
    }

    @Override
    public String getViewStudentProgrammeLink() {
        return "/student.do?method=visualizeRegistration&amp;registrationID=" + this.getRegistration().getExternalId();
    }

    @Override
    public String getReceivedActionLink() {
        return "/academicServiceRequestsManagement.do?method=prepareReceiveAcademicServiceRequest&amp;academicServiceRequestId=" + this.getExternalId();
    }

    @Override
    public boolean isProgrammeLinkVisible() {
        return this.getRegistration().isAllowedToManageRegistration();
    }
}

