/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.thesis;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProgramDocumentUploadBean;
import org.fenixedu.academic.domain.phd.thesis.PhdJuryElementsRatificationEntity;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisFinalGrade;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessStateType;
import org.fenixedu.academic.domain.phd.thesis.ThesisJuryElement;
import org.fenixedu.academic.util.MultiLanguageString;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class PhdThesisProcessBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private PhdIndividualProgramProcess process;
    private PhdThesisProcess thesisProcess;
    private boolean toNotify = true;
    private String remarks;
    private Boolean finalThesis;
    private LocalDate whenJuryValidated;
    private LocalDate whenJuryDesignated;
    private LocalDate whenJuryRequested;
    private LocalDate whenThesisDiscussionRequired;
    private List<PhdProgramDocumentUploadBean> documents = new ArrayList<PhdProgramDocumentUploadBean>();
    private ThesisJuryElement juryElement;
    private DateTime scheduledDate;
    private String scheduledPlace;
    private String mailSubject;
    private String mailBody;
    private LocalDate whenFinalThesisRatified;
    private PhdThesisFinalGrade finalGrade;
    private LocalDate conclusionDate;
    private Boolean generateAlert;
    private PhdThesisProcessStateType processState;
    private PhdJuryElementsRatificationEntity phdJuryElementsRatificationEntity;
    private String ratificationEntityCustomMessage;
    private LocalDate stateDate;
    private MultiLanguageString presidentTitle;

    public PhdThesisProcessBean() {
    }

    public PhdThesisProcessBean(PhdIndividualProgramProcess process2) {
        this();
        this.setGenerateAlert(process2.getPhdConfigurationIndividualProgramProcess().getGenerateAlert());
        this.process = process2;
        this.thesisProcess = process2.getThesisProcess();
        if (this.thesisProcess != null) {
            this.whenJuryValidated = this.thesisProcess.getWhenJuryValidated();
            this.whenJuryDesignated = this.thesisProcess.getWhenJuryDesignated();
            this.whenJuryRequested = this.thesisProcess.getWhenJuryRequired();
            this.whenThesisDiscussionRequired = this.thesisProcess.getWhenThesisDiscussionRequired();
            this.whenFinalThesisRatified = this.thesisProcess.getWhenFinalThesisRatified();
            this.phdJuryElementsRatificationEntity = this.thesisProcess.getPhdJuryElementsRatificationEntity();
            this.conclusionDate = this.thesisProcess.getConclusionDate();
            this.finalGrade = this.thesisProcess.getFinalGrade();
            this.phdJuryElementsRatificationEntity = this.thesisProcess.getPhdJuryElementsRatificationEntity();
            this.ratificationEntityCustomMessage = this.thesisProcess.getRatificationEntityCustomMessage();
            this.setPresidentTitle(this.thesisProcess.getPresidentTitle());
        }
    }

    public PhdIndividualProgramProcess getProcess() {
        return this.process;
    }

    public void setProcess(PhdIndividualProgramProcess process2) {
        this.process = process2;
    }

    public PhdThesisProcess getThesisProcess() {
        return this.thesisProcess;
    }

    public void setThesisProcess(PhdThesisProcess thesisProcess) {
        this.thesisProcess = thesisProcess;
    }

    public boolean isToNotify() {
        return this.toNotify;
    }

    public void setToNotify(boolean toNotify) {
        this.toNotify = toNotify;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public List<PhdProgramDocumentUploadBean> getDocuments() {
        return this.documents;
    }

    public void addDocument(PhdProgramDocumentUploadBean document) {
        this.documents.add(document);
    }

    public void setDocuments(List<PhdProgramDocumentUploadBean> documents) {
        this.documents = documents;
    }

    public Boolean getFinalThesis() {
        return this.finalThesis;
    }

    public void setFinalThesis(Boolean finalThesis) {
        this.finalThesis = finalThesis;
    }

    public LocalDate getWhenJuryValidated() {
        return this.whenJuryValidated;
    }

    public void setWhenJuryValidated(LocalDate whenJuryValidated) {
        this.whenJuryValidated = whenJuryValidated;
    }

    public LocalDate getWhenJuryDesignated() {
        return this.whenJuryDesignated;
    }

    public void setWhenJuryDesignated(LocalDate whenJuryDesignated) {
        this.whenJuryDesignated = whenJuryDesignated;
    }

    public ThesisJuryElement getJuryElement() {
        return this.juryElement;
    }

    public void setJuryElement(ThesisJuryElement juryElement) {
        this.juryElement = juryElement;
    }

    public DateTime getScheduledDate() {
        return this.scheduledDate;
    }

    public void setScheduledDate(DateTime scheduledDate) {
        this.scheduledDate = scheduledDate;
    }

    public String getScheduledPlace() {
        return this.scheduledPlace;
    }

    public void setScheduledPlace(String scheduledPlace) {
        this.scheduledPlace = scheduledPlace;
    }

    public String getMailSubject() {
        return this.mailSubject;
    }

    public void setMailSubject(String mailSubject) {
        this.mailSubject = mailSubject;
    }

    public String getMailBody() {
        return this.mailBody;
    }

    public void setMailBody(String mailBody) {
        this.mailBody = mailBody;
    }

    public LocalDate getWhenFinalThesisRatified() {
        return this.whenFinalThesisRatified;
    }

    public void setWhenFinalThesisRatified(LocalDate whenFinalThesisRatified) {
        this.whenFinalThesisRatified = whenFinalThesisRatified;
    }

    public PhdThesisFinalGrade getFinalGrade() {
        return this.finalGrade;
    }

    public void setFinalGrade(PhdThesisFinalGrade finalGrade) {
        this.finalGrade = finalGrade;
    }

    public LocalDate getConclusionDate() {
        return this.conclusionDate;
    }

    public void setConclusionDate(LocalDate conclusionDate) {
        this.conclusionDate = conclusionDate;
    }

    public Boolean getGenerateAlert() {
        return this.generateAlert;
    }

    public void setGenerateAlert(Boolean generateAlert) {
        this.generateAlert = generateAlert;
    }

    public PhdThesisProcessStateType getProcessState() {
        return this.processState;
    }

    public void setProcessState(PhdThesisProcessStateType processState) {
        this.processState = processState;
    }

    public LocalDate getWhenThesisDiscussionRequired() {
        return this.whenThesisDiscussionRequired;
    }

    public void setWhenThesisDiscussionRequired(LocalDate whenThesisDiscussionRequired) {
        this.whenThesisDiscussionRequired = whenThesisDiscussionRequired;
    }

    public LocalDate getWhenJuryRequested() {
        return this.whenJuryRequested;
    }

    public void setWhenJuryRequested(LocalDate whenJuryRequested) {
        this.whenJuryRequested = whenJuryRequested;
    }

    public PhdJuryElementsRatificationEntity getPhdJuryElementsRatificationEntity() {
        return this.phdJuryElementsRatificationEntity;
    }

    public void setPhdJuryElementsRatificationEntity(PhdJuryElementsRatificationEntity phdJuryElementsRatificationEntity) {
        this.phdJuryElementsRatificationEntity = phdJuryElementsRatificationEntity;
    }

    public String getRatificationEntityCustomMessage() {
        return this.ratificationEntityCustomMessage;
    }

    public void setRatificationEntityCustomMessage(String ratificationEntityCustomMessage) {
        this.ratificationEntityCustomMessage = ratificationEntityCustomMessage;
    }

    public LocalDate getStateDate() {
        return this.stateDate;
    }

    public void setStateDate(LocalDate stateDate) {
        this.stateDate = stateDate;
    }

    public MultiLanguageString getPresidentTitle() {
        return this.presidentTitle;
    }

    public void setPresidentTitle(MultiLanguageString presidentTitle) {
        this.presidentTitle = presidentTitle;
    }
}

