/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.migration.common;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.phd.migration.common.exceptions.InvalidCountryCodeException;

public class NationalityTranslator {
    private static HashMap<Integer, String> translationMap = new HashMap();

    public static Country translate(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        String code = translationMap.get(Integer.valueOf(value));
        if (StringUtils.isEmpty((String)code)) {
            throw new InvalidCountryCodeException();
        }
        return Country.readByTwoLetterCode(code);
    }

    static {
        translationMap.put(1, "PT");
        translationMap.put(2, "PT");
        translationMap.put(3, "PT");
        translationMap.put(4, "PT");
        translationMap.put(5, "PT");
        translationMap.put(6, "PT");
        translationMap.put(10, "AO");
        translationMap.put(11, "BR");
        translationMap.put(12, "CV");
        translationMap.put(13, "GW");
        translationMap.put(14, "MZ");
        translationMap.put(15, "ST");
        translationMap.put(20, "BE");
        translationMap.put(21, "DK");
        translationMap.put(22, "ES");
        translationMap.put(23, "FR");
        translationMap.put(24, "NL");
        translationMap.put(25, "IE");
        translationMap.put(26, "IT");
        translationMap.put(27, "LU");
        translationMap.put(28, "DE");
        translationMap.put(29, "UK");
        translationMap.put(32, "FI");
        translationMap.put(33, "ZA");
        translationMap.put(34, "AR");
        translationMap.put(35, "CA");
        translationMap.put(36, "CL");
        translationMap.put(37, "EC");
        translationMap.put(38, "US");
        translationMap.put(39, "IR");
        translationMap.put(40, "MA");
        translationMap.put(41, "VE");
        translationMap.put(42, "AU");
        translationMap.put(43, "PK");
        translationMap.put(50, "CU");
        translationMap.put(60, "RU");
        translationMap.put(61, "RU");
        translationMap.put(62, "UA");
        translationMap.put(70, "CN");
        translationMap.put(71, "JP");
        translationMap.put(63, "CZ");
        translationMap.put(64, "BG");
        translationMap.put(65, "YU");
        translationMap.put(66, "RO");
        translationMap.put(67, "HR");
        translationMap.put(68, "AM");
        translationMap.put(51, "MX");
        translationMap.put(44, "IN");
        translationMap.put(74, "EG");
        translationMap.put(52, "PE");
        translationMap.put(72, "CS");
        translationMap.put(73, "BY");
        translationMap.put(75, "PL");
        translationMap.put(76, "SE");
        translationMap.put(77, "CO");
        translationMap.put(77, "CO");
    }
}

