/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.individualProcess.activities;

import org.fenixedu.academic.domain.Job;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accessControl.AcademicAuthorizationGroup;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.individualProcess.activities.PhdIndividualProgramProcessActivity;
import org.fenixedu.bennu.core.domain.User;

public class DeleteJobInformation
extends PhdIndividualProgramProcessActivity {
    @Override
    protected void activityPreConditions(PhdIndividualProgramProcess process2, User userView) {
        if (!process2.isAllowedToManageProcess(userView)) {
            throw new PreConditionNotValidException();
        }
    }

    @Override
    protected PhdIndividualProgramProcess executeActivity(PhdIndividualProgramProcess process2, User userView, Object object) {
        Job job = (Job)((Object)object);
        if (process2.getPerson().getJobsSet().contains((Object)job)) {
            if (!this.canDelete(job, userView.getPerson())) {
                throw new DomainException("error.PhdIndividualProgramProcess.DeleteJobInformation.not.authorized", new String[0]);
            }
            job.delete();
        }
        return process2;
    }

    private boolean canDelete(Job job, Person person) {
        if (job.getCreator() == null) {
            return false;
        }
        return job.getCreator() == person || AcademicAuthorizationGroup.get(AcademicOperationType.MANAGE_PHD_PROCESS_STATE).isMember(job.getCreator().getUser());
    }
}

